/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.service;

import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.functionaltest.cucumber.step.World;

public final class LogHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogHelper.class);

    private LogHelper() {
    }

    public static void logVariable(World world, String variable, String value) {
        world.getScenario().log(variable + ": '" + value + "'");
        world.getScenario().attach(value, "text/plain", variable);
    }

    public static void logJson(World world, String variable, Object value) {
        String valueStr = JsonHandler.prettyPrint((Object)value);
        world.getScenario().log(variable + ": " + valueStr);
        world.getScenario().attach(valueStr, "application/json", variable);
    }
}

