/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Iterables;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import io.cucumber.datatable.DataTable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;

public class AccessService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessService.class);
    private static final String TITLE = "Title";

    public String findUnitGUIDByTitleAndOperationId(AccessExternalClient accessClient, int tenantId, String contractId, String applicationSessionId, String operationId, String auTitle) throws InvalidCreateOperationException, VitamClientException {
        String auId = "";
        SelectMultiQuery searchQuery = new SelectMultiQuery();
        searchQuery.addQueries(new Query[]{QueryHelper.and().add(new Query[]{QueryHelper.match((String)TITLE, (String)("\"" + auTitle + "\""))}).add(new Query[]{QueryHelper.in((String)VitamFieldsHelper.operations(), (String[])new String[]{operationId})})});
        RequestResponse requestResponse = accessClient.selectUnits(new VitamContext(Integer.valueOf(tenantId)).setAccessContract(contractId).setApplicationSessionId(applicationSessionId), (JsonNode)searchQuery.getFinalSelect());
        if (requestResponse.isOk()) {
            JsonNode firstJsonNode;
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            if (requestResponseOK.getHits().getTotal() == 0L) {
                Fail.fail((String)("Archive Unit not found : title = " + auTitle));
            }
            if ((firstJsonNode = (JsonNode)Iterables.get((Iterable)requestResponseOK.getResults(), (int)0)).get(VitamFieldsHelper.id()) != null) {
                auId = firstJsonNode.get(VitamFieldsHelper.id()).textValue();
            }
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request selectUnit return an error: " + vitamError.getCode()));
        }
        return auId;
    }

    public void checkResultsForParticularData(List<JsonNode> results, int resultNumber, DataTable dataTable) throws Throwable {
        JsonNode jsonNode = (JsonNode)Iterables.get(results, (int)resultNumber);
        this.checkResultsForParticularData(jsonNode, dataTable);
    }

    public void checkResultsForParticularData(JsonNode jsonNode, DataTable dataTable) throws Throwable {
        List raws = dataTable.cells();
        for (List raw : raws) {
            Set expectedrray;
            Set resultArray;
            String resultExpected;
            String resultValue;
            String key = (String)raw.get(0);
            boolean isArray = false;
            boolean isOfArray = false;
            if (null != key && key.endsWith(".array[][]")) {
                key = key.replace(".array[][]", "");
                isOfArray = true;
            }
            if (null != key && key.endsWith(".array[]")) {
                key = key.replace(".array[]", "");
                isArray = true;
            }
            if (null != (resultValue = this.getResultValue(jsonNode, key))) {
                resultValue = resultValue.replace("\n", "").replace("\\n", "");
            }
            if (null != (resultExpected = (String)raw.get(1))) {
                resultExpected = resultExpected.replace("\n", "").replace("\\n", "");
            }
            if (!isArray && !isOfArray) {
                Assertions.assertThat((String)resultValue).contains(new CharSequence[]{resultExpected});
                continue;
            }
            if (isArray) {
                resultArray = (Set)JsonHandler.getFromStringAsTypeReference((String)resultValue, (TypeReference)new TypeReference<Set<String>>(this){});
                expectedrray = (Set)JsonHandler.getFromStringAsTypeReference((String)resultExpected, (TypeReference)new TypeReference<Set<String>>(this){});
                Assertions.assertThat((Collection)resultArray).isEqualTo((Object)expectedrray);
                continue;
            }
            resultArray = (Set)JsonHandler.getFromStringAsTypeReference((String)resultValue, (TypeReference)new TypeReference<Set<Set<String>>>(this){});
            expectedrray = (Set)JsonHandler.getFromStringAsTypeReference((String)resultExpected, (TypeReference)new TypeReference<Set<Set<String>>>(this){});
            Assertions.assertThat((Collection)expectedrray).isEqualTo((Object)resultArray);
        }
    }

    private String getResultValue(JsonNode lastJsonNode, String key) {
        String[] paths;
        String rawCopy = new String(key);
        for (String path : paths = rawCopy.split("\\.")) {
            if (lastJsonNode == null) continue;
            if (lastJsonNode.isArray()) {
                try {
                    int value = Integer.parseInt(path);
                    lastJsonNode = lastJsonNode.get(value);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn((Throwable)e);
                }
                continue;
            }
            lastJsonNode = lastJsonNode.get(path);
        }
        if (lastJsonNode != null) {
            return JsonHandler.unprettyPrint((Object)lastJsonNode);
        }
        return "{}";
    }
}

