/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.report;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.functionaltest.cucumber.report.Report;
import fr.gouv.vitam.functionaltest.cucumber.report.TagInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class Reports {
    private List<Report> reports = new ArrayList<Report>();
    private LocalDateTime start = LocalDateUtil.now();
    private LocalDateTime end;

    public long getNumberOfTestOK() {
        return this.reports.stream().filter(Report::isOK).count();
    }

    public long getNumberOfTestKO() {
        return this.reports.stream().filter(report -> !report.isOK()).count();
    }

    public long numberOfTestOKByTagName(String tagName) {
        return this.reports.stream().filter(report -> report.getTags().contains(tagName) && report.isOK()).count();
    }

    public long numberOfTestKOByTagName(String tagName) {
        return this.reports.stream().filter(report -> report.getTags().contains(tagName) && !report.isOK()).count();
    }

    public List<TagInfo> getTags() {
        return this.reports.stream().map(report -> report.getTags()).flatMap(Collection::stream).collect(Collectors.toSet()).stream().map(tagName -> new TagInfo((String)tagName, this.numberOfTestOKByTagName((String)tagName), this.numberOfTestKOByTagName((String)tagName))).collect(Collectors.toList());
    }

    public List<Report> getReports() {
        return this.reports;
    }

    public void add(Report report) {
        this.reports.add(report);
    }

    public LocalDateTime getEnd() {
        return this.end;
    }

    public void setEnd(LocalDateTime end) {
        this.end = end;
    }

    public LocalDateTime getStart() {
        return this.start;
    }
}

