/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.client;

import fr.gouv.vitam.client.IhmRecetteClientFactory;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.exception.VitamException;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;

public class IhmRecetteClient
extends DefaultClient {
    private static final List<String> COLLECTION_TO_EMPTY = Arrays.asList("delete/logbook/operation", "delete/masterdata/accessContract", "delete/masterdata/ingestContract", "delete/logbook/lifecycle/unit", "delete/logbook/lifecycle/objectgroup", "delete/metadata/objectgroup", "delete/metadata/unit", "delete/accessionregisters");

    public IhmRecetteClient(VitamClientFactoryInterface<?> factory) {
        super(factory);
    }

    IhmRecetteClient(IhmRecetteClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    public void deleteTnrCollectionsTenant(String tenantId) throws VitamException {
        VitamRequestBuilder request = VitamRequestBuilder.delete().withHeader("X-Tenant-Id", (Object)tenantId).withJsonAccept();
        for (String url : COLLECTION_TO_EMPTY) {
            Response response = this.make(request.withPath(url));
            try {
                this.check(response);
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
    }

    private void check(Response response) throws VitamClientInternalException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        String message = String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), status.getReasonPhrase());
        throw new VitamClientInternalException(message);
    }
}

