/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.reconstruction;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.metrics.PassiveExpiringCache;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@ThreadSafe
public class FunctionalAdministrationReconstructionMetricsCache {
    private final PassiveExpiringCache<Pair<FunctionalAdminCollections, Integer>, LocalDateTime> reconstructionMetricsCache;

    public FunctionalAdministrationReconstructionMetricsCache(long cacheDuration, TimeUnit cacheDurationUnit) {
        this.reconstructionMetricsCache = new PassiveExpiringCache(cacheDuration, cacheDurationUnit);
    }

    public void registerLastDocumentReconstructionDate(FunctionalAdminCollections collection, int tenant, LocalDateTime lastDocumentReconstructionDate) {
        ParametersChecker.checkParameter((String)"Missing collection", (Object[])new Object[]{collection});
        ParametersChecker.checkParameter((String)"Missing lastReconstructedDocumentDate", (Object[])new Object[]{lastDocumentReconstructionDate});
        this.reconstructionMetricsCache.put((Object)new ImmutablePair((Object)collection, (Object)tenant), (Object)lastDocumentReconstructionDate);
    }

    public Duration getReconstructionLatency(FunctionalAdminCollections collection, int tenant) {
        ParametersChecker.checkParameter((String)"Missing collection", (Object[])new Object[]{collection});
        LocalDateTime lastReconstructionDate = (LocalDateTime)this.reconstructionMetricsCache.get((Object)new ImmutablePair((Object)collection, (Object)tenant));
        if (lastReconstructionDate == null) {
            return null;
        }
        return Duration.between(lastReconstructionDate, LocalDateUtil.now());
    }
}

