/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.reconstruction;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.metrics.GaugeUtils;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.core.reconstruction.FunctionalAdministrationReconstructionMetricsCache;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FunctionalAdministrationReconstructionMetrics {
    private static final String TENANT_LABEL = "tenant";
    private static final String COLLECTION_LABEL = "collection";
    private static final AtomicBoolean isInitialized = new AtomicBoolean(false);

    private FunctionalAdministrationReconstructionMetrics() {
    }

    public static synchronized void initialize(FunctionalAdministrationReconstructionMetricsCache reconstructionMetricsCache) {
        if (isInitialized.get()) {
            return;
        }
        GaugeUtils.createCustomGauge((String)"vitam_functional_administration_reconstruction_latency_seconds", (String)"Functional-administration reconstruction latency (in seconds)", List.of(TENANT_LABEL, COLLECTION_LABEL), () -> FunctionalAdministrationReconstructionMetrics.collectReconstructionMetrics(reconstructionMetricsCache)).register();
        isInitialized.set(true);
    }

    private static Map<List<String>, Double> collectReconstructionMetrics(FunctionalAdministrationReconstructionMetricsCache reconstructionMetricsCache) {
        HashMap<List<String>, Double> metricsByLabelValues = new HashMap<List<String>, Double>();
        List<FunctionalAdminCollections> supportedCollections = List.of(FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL, FunctionalAdminCollections.ACCESSION_REGISTER_SYMBOLIC);
        for (FunctionalAdminCollections collection : supportedCollections) {
            for (Integer tenant : VitamConfiguration.getTenants()) {
                Duration durationSinceLastReconstruction = reconstructionMetricsCache.getReconstructionLatency(collection, tenant);
                List<String> labelValues = List.of(Integer.toString(tenant), collection.getName().toLowerCase());
                metricsByLabelValues.put(labelValues, FunctionalAdministrationReconstructionMetrics.getReconstructionLatency(durationSinceLastReconstruction));
            }
        }
        return metricsByLabelValues;
    }

    private static double getReconstructionLatency(Duration durationSinceLastReconstruction) {
        return durationSinceLastReconstruction == null ? Double.POSITIVE_INFINITY : Math.max(0.0, (double)durationSinceLastReconstruction.toSeconds());
    }
}

