/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.griffin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.DocumentAlreadyExistsException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.preservation.GriffinByFormat;
import fr.gouv.vitam.common.model.administration.preservation.GriffinModel;
import fr.gouv.vitam.common.model.administration.preservation.PreservationScenarioModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.FileFormat;
import fr.gouv.vitam.functional.administration.common.Griffin;
import fr.gouv.vitam.functional.administration.common.PreservationScenario;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessReferential;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.format.model.FileFormatModel;
import fr.gouv.vitam.functional.administration.core.format.model.FunctionalOperationModel;
import fr.gouv.vitam.functional.administration.core.griffin.LogbookGriffinHelper;
import fr.gouv.vitam.functional.administration.core.griffin.PreservationScenarioReport;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;

public class PreservationScenarioService {
    private static final String SCENARIO_BACKUP_EVENT = "STP_BACKUP_SCENARIO";
    private static final String SCENARIO_IMPORT_EVENT = "STP_IMPORT_PRESERVATION_SCENARIO";
    private static final String SCENARIO_REPORT = "SCENARIO_REPORT";
    private static final String UND_TENANT = "_tenant";
    private final MongoDbAccessReferential mongoDbAccess;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final FunctionalBackupService functionalBackupService;

    PreservationScenarioService(MongoDbAccessReferential mongoDbAccess, FunctionalBackupService functionalBackupService, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.mongoDbAccess = mongoDbAccess;
        this.functionalBackupService = functionalBackupService;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    public PreservationScenarioService(MongoDbAccessAdminImpl mongoAccess, FunctionalBackupService functionalBackupService) {
        this((MongoDbAccessReferential)mongoAccess, functionalBackupService, LogbookOperationsClientFactory.getInstance());
    }

    public RequestResponse<PreservationScenarioModel> importScenarios(@NotNull List<PreservationScenarioModel> listToImport) throws VitamException {
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID guid = GUIDReader.getGUID((String)operationId);
        LogbookGriffinHelper.createLogbook(this.logbookOperationsClientFactory, guid, SCENARIO_IMPORT_EVENT);
        try {
            SetUtils.SetView identifierToAdd;
            SetUtils.SetView identifierToDelete;
            this.validate(listToImport);
            ObjectNode finalSelect = new Select().getFinalSelect();
            DbRequestResult result = this.mongoDbAccess.findDocuments((JsonNode)finalSelect, FunctionalAdminCollections.PRESERVATION_SCENARIO);
            List allScenariosInDatabase = result.getDocuments(PreservationScenario.class, PreservationScenarioModel.class);
            Set newIdentifiers = listToImport.stream().map(PreservationScenarioModel::getIdentifier).collect(Collectors.toSet());
            Set oldIdentifiers = allScenariosInDatabase.stream().map(PreservationScenarioModel::getIdentifier).collect(Collectors.toSet());
            SetUtils.SetView updatedIdentifiers = SetUtils.intersection(newIdentifiers, oldIdentifiers);
            if (!updatedIdentifiers.isEmpty()) {
                this.updateScenarios(listToImport, (Set<String>)updatedIdentifiers);
            }
            if (!(identifierToDelete = SetUtils.difference(oldIdentifiers, newIdentifiers)).isEmpty()) {
                this.deleteScenarios((Set<String>)identifierToDelete);
            }
            if (!(identifierToAdd = SetUtils.difference(newIdentifiers, oldIdentifiers)).isEmpty()) {
                this.insertScenarios(listToImport, (Set<String>)identifierToAdd);
            }
            this.functionalBackupService.saveCollectionAndSequence(guid, SCENARIO_BACKUP_EVENT, FunctionalAdminCollections.PRESERVATION_SCENARIO, operationId);
            PreservationScenarioReport preservationScenarioReport = this.generateReport(allScenariosInDatabase, listToImport, (Set<String>)updatedIdentifiers, (Set<String>)identifierToDelete, (Set<String>)identifierToAdd);
            this.saveReport(guid, preservationScenarioReport);
        }
        catch (VitamException e) {
            LogbookGriffinHelper.createLogbookEventKo(this.logbookOperationsClientFactory, guid, SCENARIO_IMPORT_EVENT, e.getMessage());
            throw e;
        }
        LogbookGriffinHelper.createLogbookEventSuccess(this.logbookOperationsClientFactory, guid, SCENARIO_IMPORT_EVENT);
        return new RequestResponseOK().addAllResults(listToImport).setHttpCode(Response.Status.CREATED.getStatusCode());
    }

    private void checkGriffinByFormatIdentifier(PreservationScenarioModel scenario, List<String> griffinsIdentifiers) throws ReferentialException {
        boolean defaultGriffinDoesNotExists;
        for (GriffinByFormat griffinByFormat : scenario.getGriffinByFormat()) {
            if (griffinsIdentifiers.contains(griffinByFormat.getGriffinIdentifier())) continue;
            throw new ReferentialException("Griffin '" + griffinByFormat.getGriffinIdentifier() + "' is not in database");
        }
        boolean bl = defaultGriffinDoesNotExists = scenario.getDefaultGriffin() != null && !griffinsIdentifiers.contains(scenario.getDefaultGriffin().getGriffinIdentifier());
        if (defaultGriffinDoesNotExists) {
            throw new ReferentialException("Griffin '" + scenario.getDefaultGriffin().getGriffinIdentifier() + "' is not in database");
        }
    }

    private void saveReport(GUID guid, PreservationScenarioReport griffinReport) throws StorageException {
        try (InputStream reportInputStream = JsonHandler.writeToInpustream((Object)griffinReport);){
            String fileName = guid.getId() + ".json";
            this.functionalBackupService.saveFile(reportInputStream, guid, SCENARIO_REPORT, DataCategory.REPORT, fileName);
        }
        catch (VitamException | IOException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    private void validate(List<PreservationScenarioModel> listToImport) throws VitamException {
        this.entryValidation(listToImport);
        this.functionalGriffinIdentifierValidation(listToImport);
        this.formatValidation(listToImport);
    }

    private void entryValidation(List<PreservationScenarioModel> listToImport) throws ReferentialException {
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        ArrayList<String> identifiers = new ArrayList<String>();
        for (PreservationScenarioModel model : listToImport) {
            if (identifiers.contains(model.getIdentifier())) {
                throw new ReferentialException("Duplicate scenario : '" + model.getIdentifier() + "'");
            }
            if (model.getGriffinByFormat().isEmpty() && model.getDefaultGriffin() == null) {
                throw new ReferentialException("Invalid scenario for : '" + model.getIdentifier() + "' : at least one griffin must be defined (griffin by format or default griffin)");
            }
            Set constraints = validator.validate((Object)model, new Class[0]);
            if (!constraints.isEmpty()) {
                throw new ReferentialException("Invalid scenario  for  : '" + model.getIdentifier() + "' : " + this.getConstraintsStrings(constraints));
            }
            identifiers.add(model.getIdentifier());
        }
    }

    private void functionalGriffinIdentifierValidation(List<PreservationScenarioModel> listToImport) throws BadRequestException, ReferentialException, InvalidParseOperationException {
        ObjectNode finalSelect = new Select().getFinalSelect();
        DbRequestResult result = this.mongoDbAccess.findDocuments((JsonNode)finalSelect, FunctionalAdminCollections.GRIFFIN);
        List allGriffinInDatabase = result.getDocuments(Griffin.class, GriffinModel.class);
        List<String> griffinsIdentifier = allGriffinInDatabase.stream().map(GriffinModel::getIdentifier).collect(Collectors.toList());
        for (PreservationScenarioModel scenario : listToImport) {
            this.checkGriffinByFormatIdentifier(scenario, griffinsIdentifier);
        }
    }

    private void formatValidation(List<PreservationScenarioModel> listToImport) throws VitamException {
        ObjectNode finalSelect = new Select().getFinalSelect();
        DbRequestResult result = this.mongoDbAccess.findDocuments((JsonNode)finalSelect, FunctionalAdminCollections.FORMATS);
        Set referencePuids = result.getDocuments(FileFormat.class, FileFormatModel.class).stream().map(FileFormatModel::getPuid).collect(Collectors.toSet());
        Set puidsToCheck = listToImport.stream().flatMap(s -> s.getGriffinByFormat().stream().flatMap(g -> g.getFormatList().stream())).collect(Collectors.toSet());
        puidsToCheck.removeAll(referencePuids);
        if (!puidsToCheck.isEmpty()) {
            throw new ReferentialException(String.format("List: %s does not exist in the database.", puidsToCheck.toString()));
        }
    }

    private String getConstraintsStrings(Set<ConstraintViolation<PreservationScenarioModel>> constraints) {
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        for (ConstraintViolation<PreservationScenarioModel> constraintViolation : constraints) {
            result.add((CallSite)((Object)("'" + String.valueOf(constraintViolation.getPropertyPath()) + "' : " + constraintViolation.getMessage())));
        }
        return ((Object)result).toString();
    }

    private FunctionalOperationModel retrieveOperationModel() {
        try {
            JsonNode result = this.logbookOperationsClientFactory.getClient().selectOperationById(VitamThreadUtils.getVitamSession().getRequestId());
            return (FunctionalOperationModel)JsonHandler.getFromJsonNode((JsonNode)result.get("$results").get(0), FunctionalOperationModel.class);
        }
        catch (InvalidParseOperationException | LogbookClientException e) {
            throw new VitamRuntimeException("Could not load operation data", e);
        }
    }

    private PreservationScenarioReport generateReport(List<PreservationScenarioModel> currentScenariosModels, List<PreservationScenarioModel> newScenarioModels, Set<String> updatedIdentifiers, Set<String> removedIdentifiers, Set<String> addedIdentifiers) {
        PreservationScenarioReport report = new PreservationScenarioReport();
        FunctionalOperationModel operationModel = this.retrieveOperationModel();
        report.setOperation(operationModel);
        if (!currentScenariosModels.isEmpty()) {
            report.setPreviousScenariosCreationDate(currentScenariosModels.get(0).getCreationDate());
        }
        if (!newScenarioModels.isEmpty()) {
            report.setNewScenariosCreationDate(newScenarioModels.get(0).getCreationDate());
        }
        Map<String, PreservationScenarioModel> currentScenariosModelsByIdentifiers = newScenarioModels.stream().collect(Collectors.toMap(PreservationScenarioModel::getIdentifier, model -> model));
        Map<String, PreservationScenarioModel> newScenariosModelByIdentifiers = newScenarioModels.stream().collect(Collectors.toMap(PreservationScenarioModel::getIdentifier, model -> model));
        report.setRemovedIdentifiers(removedIdentifiers);
        report.setAddedIdentifiers(addedIdentifiers);
        this.reportUpdatedIdentifiers(updatedIdentifiers, report, currentScenariosModelsByIdentifiers, newScenariosModelByIdentifiers);
        this.reportVersioning(report);
        if (!removedIdentifiers.isEmpty()) {
            report.addWarning(removedIdentifiers.size() + " identifiers removed.");
        }
        if (report.getWarnings().isEmpty()) {
            return report.setStatusCode(StatusCode.OK);
        }
        return report.setStatusCode(StatusCode.WARNING);
    }

    private void reportVersioning(PreservationScenarioReport report) {
        if (report.getPreviousScenariosCreationDate() != null && report.getNewScenariosCreationDate() != null) {
            String newDate;
            String previousDate = LocalDateUtil.getFormattedDateTimeForMongo((String)report.getPreviousScenariosCreationDate());
            if (previousDate.equals(newDate = LocalDateUtil.getFormattedDateTimeForMongo((String)report.getNewScenariosCreationDate()))) {
                report.addWarning("Same referential date: " + report.getNewScenariosCreationDate());
            }
            if (previousDate.compareTo(newDate) > 0) {
                report.addWarning("New imported referential date " + report.getNewScenariosCreationDate() + " is older than previous report date " + report.getNewScenariosCreationDate());
            }
        }
    }

    private void reportUpdatedIdentifiers(Set<String> updatedIdentifiers, PreservationScenarioReport report, Map<String, PreservationScenarioModel> currentScenariosModelsByIdentifiers, Map<String, PreservationScenarioModel> newScenariosModelByIdentifiers) {
        for (String identifier : updatedIdentifiers) {
            PreservationScenarioModel currentScenarioModel = currentScenariosModelsByIdentifiers.get(identifier);
            PreservationScenarioModel newScenarioModel = newScenariosModelByIdentifiers.get(identifier);
            List<String> diff = this.diff(currentScenarioModel, newScenarioModel);
            report.addUpdatedIdentifiers(identifier, diff);
        }
    }

    private String toComparableString(PreservationScenarioModel scenarioModel) {
        try {
            ObjectNode currentJsonNode = (ObjectNode)JsonHandler.toJsonNode((Object)scenarioModel);
            currentJsonNode.remove("_id");
            currentJsonNode.remove("_v");
            currentJsonNode.remove("CreationDate");
            currentJsonNode.remove("LastUpdate");
            return JsonHandler.prettyPrint((Object)currentJsonNode);
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    private List<String> diff(PreservationScenarioModel currentScenarioModel, PreservationScenarioModel newScenarioModel) {
        String after = this.toComparableString(newScenarioModel);
        String before = this.toComparableString(currentScenarioModel);
        List concernedDiffLines = VitamDocument.getConcernedDiffLines((List)VitamDocument.getUnifiedDiff((String)before, (String)after));
        concernedDiffLines.sort(Comparator.naturalOrder());
        return concernedDiffLines;
    }

    private void insertScenarios(@NotNull List<PreservationScenarioModel> listToImport, Set<String> newIdentifiers) throws InvalidParseOperationException, ReferentialException, SchemaValidationException, DocumentAlreadyExistsException {
        if (listToImport.isEmpty()) {
            return;
        }
        ArrayNode treatmentToInsert = JsonHandler.createArrayNode();
        for (PreservationScenarioModel preservationScenarioModel : listToImport) {
            if (!newIdentifiers.contains(preservationScenarioModel.getIdentifier())) continue;
            preservationScenarioModel.setTenant(ParameterHelper.getTenantParameter());
            this.formatDateForMongo(preservationScenarioModel);
            treatmentToInsert.add(this.toJson(preservationScenarioModel));
        }
        this.mongoDbAccess.insertDocuments(treatmentToInsert, FunctionalAdminCollections.PRESERVATION_SCENARIO);
    }

    private JsonNode toJson(@NotNull PreservationScenarioModel model) throws InvalidParseOperationException {
        JsonNode hashTenant;
        ObjectNode modelNode = (ObjectNode)JsonHandler.toJsonNode((Object)model);
        JsonNode jsonNode = modelNode.remove(VitamFieldsHelper.id());
        if (jsonNode != null) {
            modelNode.set("_id", jsonNode);
        }
        if ((hashTenant = modelNode.remove(VitamFieldsHelper.tenant())) != null) {
            modelNode.set(UND_TENANT, hashTenant);
        }
        return modelNode;
    }

    private void deleteScenarios(@NotNull Set<String> listIdsToDelete) throws ReferentialException, BadRequestException, SchemaValidationException {
        try {
            for (String identifier : listIdsToDelete) {
                Select select = new Select();
                select.setQuery((Query)QueryHelper.eq((String)"Identifier", (String)identifier));
                this.mongoDbAccess.deleteDocument((JsonNode)select.getFinalSelect(), FunctionalAdminCollections.PRESERVATION_SCENARIO);
            }
        }
        catch (InvalidCreateOperationException e) {
            throw new IllegalStateException("cannot Create Dsl");
        }
    }

    private void updateScenarios(@NotNull List<PreservationScenarioModel> listToImport, Set<String> identifierToUpdate) throws InvalidParseOperationException, DatabaseException, ReferentialException {
        for (PreservationScenarioModel preservationScenarioModel : listToImport) {
            if (!identifierToUpdate.contains(preservationScenarioModel.getIdentifier())) continue;
            preservationScenarioModel.setLastUpdate(LocalDateUtil.nowFormatted());
            this.formatDateForMongo(preservationScenarioModel);
            preservationScenarioModel.setTenant(VitamThreadUtils.getVitamSession().getTenantId());
            ObjectNode scenario = (ObjectNode)JsonHandler.toJsonNode((Object)preservationScenarioModel);
            scenario.put(UND_TENANT, VitamThreadUtils.getVitamSession().getTenantId());
            this.mongoDbAccess.replaceDocument((JsonNode)scenario, preservationScenarioModel.getIdentifier(), "Identifier", FunctionalAdminCollections.PRESERVATION_SCENARIO);
        }
    }

    private void formatDateForMongo(PreservationScenarioModel preservationScenarioModel) throws ReferentialException {
        try {
            String lastUpdate = LocalDateUtil.nowFormatted();
            preservationScenarioModel.setLastUpdate(lastUpdate);
        }
        catch (DateTimeParseException e) {
            throw new ReferentialException("Error in scenario '" + preservationScenarioModel.getIdentifier() + "' : field 'LastUpdate' format is invalid", (Throwable)e);
        }
        if (preservationScenarioModel.getCreationDate() != null) {
            try {
                String creationDate = LocalDateUtil.getFormattedDateTimeForMongo((String)preservationScenarioModel.getCreationDate());
                preservationScenarioModel.setCreationDate(creationDate);
            }
            catch (DateTimeParseException e) {
                throw new ReferentialException("Error in scenario '" + preservationScenarioModel.getIdentifier() + "' : field 'CreationDate' format is invalid", (Throwable)e);
            }
        }
    }

    public RequestResponse<PreservationScenarioModel> findPreservationScenario(JsonNode queryDsl) throws ReferentialException, InvalidParseOperationException {
        DbRequestResult documents = this.mongoDbAccess.findDocuments(queryDsl, FunctionalAdminCollections.PRESERVATION_SCENARIO);
        return documents.getRequestResponseOK(queryDsl, PreservationScenario.class, PreservationScenarioModel.class);
    }
}

