/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.format;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.xml.SecureXMLFactoryUtils;
import fr.gouv.vitam.common.xml.XsdValidator;
import fr.gouv.vitam.functional.administration.common.exception.FileFormatException;
import fr.gouv.vitam.functional.administration.common.exception.InvalidFileFormatParseException;
import fr.gouv.vitam.functional.administration.core.format.model.FileFormatModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.xml.sax.SAXException;

public class PronomParser {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PronomParser.class);
    private static final String TAG_FFSIGNATUREFILE = "FFSignatureFile";
    private static final String TAG_FILEFORMAT = "FileFormat";
    private static final String TAG_EXTENSION = "Extension";
    private static final String TAG_HASPRIORITYOVERFILEFORMATID = "HasPriorityOverFileFormatID";
    private static final String ATTR_PUID = "PUID";
    private static final String ATTR_NAME = "Name";
    private static final String ATTR_ID = "ID";
    private static final String ATTR_VERSION = "Version";
    private static final String ATTR_CREATEDDATE = "DateCreated";
    private static final String EXTERNAL_MIME_TYPE = "MIMEType";
    private static final XsdValidator pronomXsdValidator;

    private PronomParser() {
    }

    public static List<FileFormatModel> getPronom(File xmlPronomFile) throws FileFormatException {
        boolean bExtension = false;
        boolean bFileFormat = false;
        boolean bPriorityOverId = false;
        PronomParser.validateSchema(xmlPronomFile);
        ArrayList<FileFormatModel> fileFormatModels = new ArrayList<FileFormatModel>();
        HashMap<String, String> idToPUID = new HashMap<String, String>();
        String creationDate = null;
        String pronomVersion = null;
        FileFormatModel fileFormatModel = new FileFormatModel();
        ArrayListValuedHashMap hasPriorityOverFileFormatIDByPuid = new ArrayListValuedHashMap();
        String updateDate = LocalDateUtil.nowFormatted();
        try (FileInputStream xmlPronom = new FileInputStream(xmlPronomFile);){
            XMLEventReader eventReader = SecureXMLFactoryUtils.createSecureXMLEventReader((InputStream)xmlPronom);
            block35: while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        Iterator<Attribute> attributes;
                        StartElement startElement = event.asStartElement();
                        String qName = startElement.getName().getLocalPart();
                        if (qName.equalsIgnoreCase(TAG_FFSIGNATUREFILE)) {
                            attributes = startElement.getAttributes();
                            while (attributes.hasNext()) {
                                Attribute attribute = attributes.next();
                                switch (attribute.getName().toString()) {
                                    case "DateCreated": {
                                        creationDate = LocalDateUtil.getFormattedDateTimeForMongo((String)attribute.getValue());
                                        break;
                                    }
                                    case "Version": {
                                        pronomVersion = attribute.getValue();
                                    }
                                }
                            }
                            continue block35;
                        }
                        if (qName.equalsIgnoreCase(TAG_FILEFORMAT)) {
                            fileFormatModel = new FileFormatModel().setVersionPronom(pronomVersion).setCreatedDate(creationDate).setUpdateDate(updateDate);
                            bFileFormat = true;
                            attributes = startElement.getAttributes();
                            String id = null;
                            while (attributes.hasNext()) {
                                Attribute attribute = attributes.next();
                                String value = attribute.getValue();
                                switch (attribute.getName().getLocalPart()) {
                                    case "MIMEType": {
                                        fileFormatModel.setMimeType(value.replace(",", ";"));
                                        break;
                                    }
                                    case "Version": {
                                        fileFormatModel.setVersion(value);
                                        break;
                                    }
                                    case "Name": {
                                        fileFormatModel.setName(value);
                                        break;
                                    }
                                    case "PUID": {
                                        fileFormatModel.setPuid(value);
                                        break;
                                    }
                                    case "ID": {
                                        id = value;
                                    }
                                }
                            }
                            idToPUID.put(id, fileFormatModel.getPuid());
                            break;
                        }
                        if (qName.equalsIgnoreCase(TAG_EXTENSION)) {
                            bExtension = true;
                            break;
                        }
                        if (!qName.equalsIgnoreCase(TAG_HASPRIORITYOVERFILEFORMATID)) break;
                        bPriorityOverId = true;
                        break;
                    }
                    case 4: {
                        Characters characters = event.asCharacters();
                        if (bExtension && bFileFormat) {
                            fileFormatModel.getExtension().add(characters.getData());
                            bExtension = false;
                        }
                        if (!bPriorityOverId || !bFileFormat) break;
                        hasPriorityOverFileFormatIDByPuid.put((Object)fileFormatModel.getPuid(), (Object)characters.getData());
                        bPriorityOverId = false;
                        break;
                    }
                    case 2: {
                        EndElement endElement = event.asEndElement();
                        String qName = endElement.getName().getLocalPart();
                        if (!qName.equalsIgnoreCase(TAG_FILEFORMAT)) break;
                        fileFormatModels.add(fileFormatModel);
                        fileFormatModel = null;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new InvalidFileFormatParseException("Invalid xml file format", (Throwable)e);
        }
        catch (IOException e) {
            throw new InvalidFileFormatParseException("Could not load xml file format", (Throwable)e);
        }
        for (FileFormatModel formatModel : fileFormatModels) {
            for (String id : hasPriorityOverFileFormatIDByPuid.get((Object)formatModel.getPuid())) {
                formatModel.getHasPriorityOverFileFormatID().add((String)idToPUID.get(id));
            }
        }
        return fileFormatModels;
    }

    private static void validateSchema(File xmlPronomFile) throws InvalidFileFormatParseException {
        try {
            pronomXsdValidator.validate(xmlPronomFile);
        }
        catch (SAXException e) {
            throw new InvalidFileFormatParseException("Invalid xml file format", (Throwable)e);
        }
        catch (IOException e) {
            throw new InvalidFileFormatParseException("Could not load xml file format", (Throwable)e);
        }
    }

    static {
        try {
            pronomXsdValidator = new XsdValidator("DROID_SignatureFile_Vitam.xsd");
        }
        catch (SAXException e) {
            throw new RuntimeException("Cannot initialize Pronom validator", e);
        }
    }
}

