/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.contract;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.administration.AbstractContractModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.functional.administration.common.counter.SequenceType;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessReferential;

public class ContractHelper {
    public static DbRequestResult findByIdentifier(String identifier, FunctionalAdminCollections collection, MongoDbAccessReferential mongoAccess) throws InvalidParseOperationException, ReferentialException {
        SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new SingleVarNameAdapter());
        parser.parse((JsonNode)new Select().getFinalSelect());
        try {
            parser.addCondition((Query)QueryHelper.eq((String)"Identifier", (String)identifier));
        }
        catch (InvalidCreateOperationException e) {
            throw new ReferentialException((Throwable)e);
        }
        return mongoAccess.findDocuments((JsonNode)parser.getRequest().getFinalSelect(), collection);
    }

    public static void setIdentifier(boolean slaveMode, AbstractContractModel cm, VitamCounterService vitamCounterService, SequenceType sequenceType) throws ReferentialException {
        if (!slaveMode) {
            String code = vitamCounterService.getNextSequenceAsString(ParameterHelper.getTenantParameter(), sequenceType);
            cm.setIdentifier(code);
        }
    }
}

