/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.context;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import java.util.List;

public interface ContextValidator {
    public List<ContextRejectionCause> validate(ContextModel var1) throws ReferentialException, InvalidParseOperationException;

    public static class ContextRejectionCause {
        private static final String ERR_ID_NOT_ALLOWED_IN_CREATE = "Id must be null when creating context (%s)";
        private static final String ERR_DUPLICATE_CONTEXT_ENTRY = "One or many contexts in the imported list have the same name : %s";
        private static final String ERR_MANDATORY_FIELD = "The field %s is mandatory";
        private static final String ERR_DUPLICATE_CONTEXT = "The context %s already exists in database";
        private static final String ERR_NO_EXISTANCE_INGEST = "The ingest contract %s of tenant %d does not exist";
        private static final String ERR_NO_EXISTANCE_ACCESS = "The access contract %s of tenant %d does not exist";
        private static final String ERR_INVALID_SECURITY_PROFILE = "The security profile %s does not exist";
        private static final String ERR_NO_EXISTANCE_TENANT = "The tenant %d does not exist";
        private static final String ERR_NULL_TENANT = "The tenant field for permissions should not be null";
        private String reason;

        public ContextRejectionCause(String error) {
            this.setReason(error);
        }

        public static ContextRejectionCause rejectIdNotAllowedInCreate(String contextIdentifier) {
            return new ContextRejectionCause(String.format(ERR_ID_NOT_ALLOWED_IN_CREATE, contextIdentifier));
        }

        public static ContextRejectionCause rejectMandatoryMissing(String fieldName) {
            return new ContextRejectionCause(String.format(ERR_MANDATORY_FIELD, fieldName));
        }

        public static ContextRejectionCause rejectDuplicatedInDatabase(String contextName) {
            return new ContextRejectionCause(String.format(ERR_DUPLICATE_CONTEXT, contextName));
        }

        public static ContextRejectionCause rejectNoExistanceOfTenant(Integer tenantId) {
            return new ContextRejectionCause(String.format(ERR_NO_EXISTANCE_TENANT, tenantId));
        }

        public static ContextRejectionCause rejectNullTenant() {
            return new ContextRejectionCause(ERR_NULL_TENANT);
        }

        public static ContextRejectionCause rejectNoExistanceOfIngestContract(String contextName, Integer tenant) {
            return new ContextRejectionCause(String.format(ERR_NO_EXISTANCE_INGEST, contextName, tenant));
        }

        public static ContextRejectionCause rejectNoExistanceOfAccessContract(String contextName, Integer tenant) {
            return new ContextRejectionCause(String.format(ERR_NO_EXISTANCE_ACCESS, contextName, tenant));
        }

        public static ContextRejectionCause invalidSecurityProfile(String securityProfileIdentifier) {
            return new ContextRejectionCause(String.format(ERR_INVALID_SECURITY_PROFILE, securityProfileIdentifier));
        }

        public String getReason() {
            return this.reason;
        }

        private void setReason(String reason) {
            this.reason = reason;
        }
    }
}

