/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.context;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Delete;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.adapter.SimpleVarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.DeleteParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.ContextStatus;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.PermissionModel;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.Context;
import fr.gouv.vitam.functional.administration.common.VitamErrorUtils;
import fr.gouv.vitam.functional.administration.common.counter.SequenceType;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.context.ContextService;
import fr.gouv.vitam.functional.administration.core.context.ContextValidator;
import fr.gouv.vitam.functional.administration.core.contract.AccessContractImpl;
import fr.gouv.vitam.functional.administration.core.contract.ContractService;
import fr.gouv.vitam.functional.administration.core.contract.IngestContractImpl;
import fr.gouv.vitam.functional.administration.core.security.profile.SecurityProfileService;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.security.internal.client.InternalSecurityClient;
import fr.gouv.vitam.security.internal.client.InternalSecurityClientFactory;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.conversions.Bson;

public class ContextServiceImpl
implements ContextService {
    public static final String CONTEXTS_BACKUP_EVENT = "STP_BACKUP_CONTEXT";
    private static final String INVALID_IDENTIFIER_OF_THE_ACCESS_CONTRACT = "Invalid identifier of the access contract:";
    private static final String INVALID_IDENTIFIER_OF_THE_INGEST_CONTRACT = "Invalid identifier of the ingest contract:";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ContextServiceImpl.class);
    private static final String CONTEXT_IS_MANDATORY_PARAMETER = "contexts parameter is mandatory";
    private static final String CONTEXTS_IMPORT_EVENT = "STP_IMPORT_CONTEXT";
    private static final String CONTEXTS_UPDATE_EVENT = "STP_UPDATE_CONTEXT";
    private static final String CONTEXTS_DELETE_EVENT = "STP_DELETE_CONTEXT";
    private static final String EMPTY_REQUIRED_FIELD = "STP_IMPORT_CONTEXT.EMPTY_REQUIRED_FIELD.KO";
    private static final String SECURITY_PROFILE_NOT_FOUND = "STP_IMPORT_CONTEXT.SECURITY_PROFILE_NOT_FOUND.KO";
    private static final String DUPLICATE_IN_DATABASE = "STP_IMPORT_CONTEXT.IDENTIFIER_DUPLICATION.KO";
    private static final String UNKNOWN_VALUE = "STP_IMPORT_CONTEXT.UNKNOWN_VALUE.KO";
    private static final String UPDATE_UNKNOWN_VALUE = "STP_UPDATE_CONTEXT.UNKNOWN_VALUE.KO";
    private static final String UPDATE_KO = "STP_UPDATE_CONTEXT.KO";
    private static final String DELETE_KO = "STP_DELETE_CONTEXT.KO";
    private static final String UPDATE_CONTEXT_MANDATORY_PARAMETER = "context is mandatory";
    private final MongoDbAccessAdminImpl mongoAccess;
    private final LogbookOperationsClient logbookClient;
    private final InternalSecurityClient internalSecurityClient;
    private final VitamCounterService vitamCounterService;
    private final FunctionalBackupService functionalBackupService;
    private final ContractService<IngestContractModel> ingestContract;
    private final ContractService<AccessContractModel> accessContract;
    private SecurityProfileService securityProfileService;

    public ContextServiceImpl(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService) {
        this.mongoAccess = mongoAccess;
        this.vitamCounterService = vitamCounterService;
        this.logbookClient = LogbookOperationsClientFactory.getInstance().getClient();
        this.internalSecurityClient = InternalSecurityClientFactory.getInstance().getClient();
        this.ingestContract = new IngestContractImpl(mongoAccess, vitamCounterService);
        this.accessContract = new AccessContractImpl(mongoAccess, vitamCounterService);
        this.functionalBackupService = new FunctionalBackupService(vitamCounterService);
    }

    @VisibleForTesting
    public ContextServiceImpl(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService, ContractService<IngestContractModel> ingestContract, ContractService<AccessContractModel> accessContract, SecurityProfileService securityProfileService, FunctionalBackupService functionalBackupService) {
        this.mongoAccess = mongoAccess;
        this.vitamCounterService = vitamCounterService;
        this.logbookClient = LogbookOperationsClientFactory.getInstance().getClient();
        this.internalSecurityClient = InternalSecurityClientFactory.getInstance().getClient();
        this.ingestContract = ingestContract;
        this.accessContract = accessContract;
        this.securityProfileService = securityProfileService;
        this.functionalBackupService = functionalBackupService;
    }

    @Override
    public RequestResponse<ContextModel> createContexts(List<ContextModel> contextModelList) throws VitamException {
        ParametersChecker.checkParameter((String)CONTEXT_IS_MANDATORY_PARAMETER, (Object[])new Object[]{contextModelList});
        if (contextModelList.isEmpty()) {
            return new RequestResponseOK();
        }
        boolean slaveMode = this.vitamCounterService.isSlaveFunctionnalCollectionOnTenant(SequenceType.CONTEXT_SEQUENCE.getCollection(), ParameterHelper.getTenantParameter());
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        ContextManager manager = new ContextManager(this.logbookClient, this.accessContract, this.ingestContract, this.securityProfileService, eip);
        manager.logStarted();
        ArrayList<ContextModel> contextsListToPersist = new ArrayList<ContextModel>();
        VitamError error = new VitamError(VitamCode.CONTEXT_VALIDATION_ERROR.getItem()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        ArrayNode contextsToPersist = JsonHandler.createArrayNode();
        try {
            for (ContextModel cm : contextModelList) {
                if (!slaveMode) {
                    String code = this.vitamCounterService.getNextSequenceAsString(ParameterHelper.getTenantParameter(), SequenceType.CONTEXT_SEQUENCE);
                    cm.setIdentifier(code);
                }
                if (cm.getId() != null) {
                    error.addToErrors(new VitamError(VitamCode.CONTEXT_VALIDATION_ERROR.getItem()).setMessage(ContextValidator.ContextRejectionCause.rejectIdNotAllowedInCreate(cm.getName()).getReason()));
                    continue;
                }
                if (manager.validateContext(cm, (VitamError<ContextModel>)error)) {
                    cm.setId(GUIDFactory.newContextGUID().getId());
                    cm.setCreationdate(LocalDateUtil.nowFormatted());
                    cm.setLastupdate(LocalDateUtil.nowFormatted());
                    ObjectNode contextNode = (ObjectNode)JsonHandler.toJsonNode((Object)cm);
                    JsonNode jsonNode = contextNode.remove(VitamFieldsHelper.id());
                    if (jsonNode != null) {
                        contextNode.set("_id", jsonNode);
                    }
                    SimpleVarNameAdapter.change((JsonNode)contextNode, (String)VitamFieldsHelper.tenant(), (String)"_tenant");
                    contextsToPersist.add((JsonNode)contextNode);
                    ContextModel ctxt = (ContextModel)JsonHandler.getFromJsonNode((JsonNode)contextNode, ContextModel.class);
                    contextsListToPersist.add(ctxt);
                }
                if (!slaveMode) continue;
                List<ContextValidator.ContextRejectionCause> results = manager.checkEmptyIdentifierSlaveModeValidator().validate(cm);
                for (ContextValidator.ContextRejectionCause result : results) {
                    error.addToErrors(new VitamError(VitamCode.CONTEXT_VALIDATION_ERROR.getItem()).setMessage(EMPTY_REQUIRED_FIELD).setDescription(result.getReason()).setState(StatusCode.KO.name()));
                }
            }
            if (null != error.getErrors() && !error.getErrors().isEmpty()) {
                String errorsDetails = error.getErrors().stream().map(VitamError::getDescription).collect(Collectors.joining(","));
                manager.logValidationError(errorsDetails, CONTEXTS_IMPORT_EVENT, ((VitamError)error.getErrors().get(0)).getMessage());
                return error;
            }
            this.mongoAccess.insertDocuments(contextsToPersist, FunctionalAdminCollections.CONTEXT).close();
            this.functionalBackupService.saveCollectionAndSequence(eip, CONTEXTS_BACKUP_EVENT, FunctionalAdminCollections.CONTEXT, eip.toString());
        }
        catch (Exception exp) {
            String err = "Import contexts error > " + exp.getMessage();
            manager.logFatalError(err);
            return error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        manager.logSuccess();
        return new RequestResponseOK().addAllResults(contextsListToPersist).setHttpCode(Response.Status.CREATED.getStatusCode());
    }

    @Override
    public DbRequestResult findContexts(JsonNode queryDsl) throws ReferentialException {
        return this.mongoAccess.findDocuments(queryDsl, FunctionalAdminCollections.CONTEXT);
    }

    @Override
    public ContextModel findOneContextById(String id) throws ReferentialException, InvalidParseOperationException {
        SanityChecker.checkParameter((String[])new String[]{id});
        SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new SingleVarNameAdapter());
        parser.parse((JsonNode)new Select().getFinalSelect());
        try {
            parser.addCondition((Query)QueryHelper.eq((String)"Identifier", (String)id));
        }
        catch (InvalidCreateOperationException e) {
            throw new ReferentialException((Throwable)e);
        }
        try (DbRequestResult result = this.mongoAccess.findDocuments((JsonNode)parser.getRequest().getFinalSelect(), FunctionalAdminCollections.CONTEXT);){
            List list = result.getDocuments(Context.class, ContextModel.class);
            if (list.isEmpty()) {
                throw new ReferentialNotFoundException("Context not found");
            }
            ContextModel contextModel = (ContextModel)list.get(0);
            return contextModel;
        }
    }

    @Override
    public RequestResponse<ContextModel> deleteContext(String contextId, boolean forceDelete) throws VitamException {
        SanityChecker.checkParameter((String[])new String[]{contextId});
        DeleteParserSingle parser = new DeleteParserSingle((VarNameAdapter)new SingleVarNameAdapter());
        parser.parse((JsonNode)new Delete().getFinalDelete());
        try {
            parser.addCondition((Query)QueryHelper.eq((String)"Identifier", (String)contextId));
        }
        catch (InvalidCreateOperationException e) {
            throw new ReferentialException((Throwable)e);
        }
        ObjectNode finalDelete = parser.getRequest().getFinalDelete();
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        ContextManager manager = new ContextManager(this.logbookClient, this.accessContract, this.ingestContract, this.securityProfileService, eip);
        try {
            manager.logDeleteStarted(contextId);
            if (!this.exist((JsonNode)finalDelete)) {
                manager.logValidationError("Context not found : " + contextId, CONTEXTS_DELETE_EVENT, DELETE_KO);
                return this.getVitamError(VitamCode.CONTEXT_VALIDATION_ERROR.getItem(), "Delete context error : " + contextId).setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
            }
            if (this.internalSecurityClient.contextIsUsed(contextId) && !forceDelete) {
                manager.logValidationError("Delete context error : " + contextId, CONTEXTS_DELETE_EVENT, DELETE_KO);
                return this.getVitamError(VitamCode.CONTEXT_VALIDATION_ERROR.getItem(), "Delete context error : " + contextId).setHttpCode(Response.Status.FORBIDDEN.getStatusCode()).setMessage(DELETE_KO);
            }
            RequestResponseOK response = new RequestResponseOK();
            DbRequestResult result = this.mongoAccess.deleteDocument((JsonNode)finalDelete, FunctionalAdminCollections.CONTEXT);
            response.addAllResults(result.getDocuments(Context.class, ContextModel.class)).setTotal(result.getTotal()).setHttpCode(Response.Status.NO_CONTENT.getStatusCode());
            result.close();
            this.functionalBackupService.saveCollectionAndSequence(eip, CONTEXTS_BACKUP_EVENT, FunctionalAdminCollections.CONTEXT, eip.toString());
            manager.logDeleteSuccess(contextId);
            return response;
        }
        catch (BadRequestException | SchemaValidationException e) {
            LOGGER.error(e);
            String err = "Delete context error > " + e.getMessage();
            manager.logValidationError(err, CONTEXTS_DELETE_EVENT, DELETE_KO);
            return this.getVitamError(VitamCode.CONTEXT_VALIDATION_ERROR.getItem(), e.getMessage()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage(DELETE_KO);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            VitamError error = this.getVitamError(VitamCode.CONTEXT_VALIDATION_ERROR.getItem(), "Context delete error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
            String err = "Delete context error > " + e.getMessage();
            error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            manager.logFatalError(err);
            return error;
        }
    }

    @Override
    public boolean securityProfileIsUsedInContexts(String securityProfileId) throws InvalidCreateOperationException, ReferentialException, InvalidParseOperationException {
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)"SecurityProfile", (String)securityProfileId));
        return this.exist((JsonNode)select.getFinalSelect());
    }

    private boolean exist(JsonNode finalSelect) throws InvalidParseOperationException, ReferentialException {
        DbRequestResult result = this.mongoAccess.findDocuments(finalSelect, FunctionalAdminCollections.CONTEXT);
        List list = result.getDocuments(Context.class, ContextModel.class);
        return !list.isEmpty();
    }

    @Override
    public RequestResponse<ContextModel> updateContext(String id, JsonNode queryDsl) throws VitamException {
        String err;
        ParametersChecker.checkParameter((String)UPDATE_CONTEXT_MANDATORY_PARAMETER, (Object[])new Object[]{queryDsl});
        SanityChecker.checkJsonAll((JsonNode)queryDsl);
        VitamError error = this.getVitamError(VitamCode.CONTEXT_VALIDATION_ERROR.getItem(), "Context update error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        ContextModel contextModel = this.findOneContextById(id);
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        ContextManager manager = new ContextManager(this.logbookClient, this.accessContract, this.ingestContract, this.securityProfileService, eip);
        manager.logUpdateStarted(contextModel.getId());
        JsonNode permissionsNode = queryDsl.findValue("Permissions");
        if (permissionsNode != null && permissionsNode.isArray()) {
            for (JsonNode permission : permissionsNode) {
                PermissionModel permissionModel = (PermissionModel)JsonHandler.getFromJsonNode((JsonNode)permission, PermissionModel.class);
                int tenantId = permissionModel.getTenant();
                for (String accessContractId : permissionModel.getAccessContract()) {
                    if (manager.checkIdentifierOfAccessContract(accessContractId, tenantId)) continue;
                    error.addToErrors(new VitamError(VitamCode.CONTEXT_VALIDATION_ERROR.getItem()).setDescription(INVALID_IDENTIFIER_OF_THE_ACCESS_CONTRACT + accessContractId).setMessage(UPDATE_UNKNOWN_VALUE));
                }
                for (String ingestContractId : permissionModel.getIngestContract()) {
                    if (manager.checkIdentifierOfIngestContract(ingestContractId, tenantId)) continue;
                    error.addToErrors(new VitamError(VitamCode.CONTEXT_VALIDATION_ERROR.getItem()).setDescription(INVALID_IDENTIFIER_OF_THE_INGEST_CONTRACT + ingestContractId).setMessage(UPDATE_UNKNOWN_VALUE));
                }
            }
        }
        if (error.getErrors() != null && error.getErrors().size() > 0) {
            String errorsDetails = error.getErrors().stream().map(VitamError::getDescription).collect(Collectors.joining(","));
            manager.logValidationError(errorsDetails, CONTEXTS_UPDATE_EVENT, ((VitamError)error.getErrors().get(0)).getMessage());
            return error.setState(StatusCode.KO.name());
        }
        String diff = null;
        RequestResponseOK response = new RequestResponseOK();
        JsonNode actionNode = queryDsl.get(BuilderToken.GLOBAL.ACTION.exactToken());
        for (JsonNode fieldToSet : actionNode) {
            JsonNode fieldName = fieldToSet.get(BuilderToken.UPDATEACTION.SET.exactToken());
            if (fieldName == null) continue;
            ((ObjectNode)fieldName).remove("CreationDate");
            ((ObjectNode)fieldName).put("LastUpdate", LocalDateUtil.nowFormatted());
        }
        try {
            DbRequestResult result = this.mongoAccess.updateData(queryDsl, FunctionalAdminCollections.CONTEXT);
            response.addAllResults(result.getDocuments(Context.class, ContextModel.class)).setTotal(result.getTotal()).setQuery(queryDsl).setHttpCode(Response.Status.OK.getStatusCode());
            List updates = null;
            if (result.getCount() > 0L) {
                updates = (List)result.getDiffs().values().stream().findFirst().orElseThrow(NoSuchElementException::new);
            }
            result.close();
            if (updates != null && updates.size() > 0) {
                String modifs = String.join((CharSequence)"\n", updates);
                ObjectNode diffObject = JsonHandler.createObjectNode();
                diffObject.put("diff", modifs);
                diffObject.put("version", VitamConfiguration.getDiffVersion());
                diff = SanityChecker.sanitizeJson((JsonNode)diffObject);
            }
            this.functionalBackupService.saveCollectionAndSequence(eip, CONTEXTS_BACKUP_EVENT, FunctionalAdminCollections.CONTEXT, contextModel.getId());
        }
        catch (BadRequestException | SchemaValidationException e) {
            LOGGER.error(e);
            err = "Update context error > " + e.getMessage();
            manager.logValidationError(err, CONTEXTS_UPDATE_EVENT, UPDATE_KO);
            return this.getVitamError(VitamCode.CONTEXT_VALIDATION_ERROR.getItem(), e.getMessage()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage(UPDATE_KO);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            err = "Update context error > " + e.getMessage();
            error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            manager.logFatalError(err);
            return error;
        }
        manager.logUpdateSuccess(contextModel.getId(), diff);
        return response;
    }

    private VitamError<ContextModel> getVitamError(String vitamCode, String error) {
        return VitamErrorUtils.getVitamError((String)vitamCode, (String)error, (String)"Context", (StatusCode)StatusCode.KO, ContextModel.class);
    }

    public void close() {
        this.logbookClient.close();
    }

    @Override
    public void setSecurityProfileService(SecurityProfileService securityProfileService) {
        this.securityProfileService = securityProfileService;
    }

    private static final class ContextManager {
        private final GUID eip;
        private final LogbookOperationsClient logbookClient;
        private final ContractService<AccessContractModel> accessContract;
        private final ContractService<IngestContractModel> ingestContract;
        private final SecurityProfileService securityProfileService;
        private final Map<ContextValidator, String> validators;

        public ContextManager(LogbookOperationsClient logbookClient, ContractService<AccessContractModel> accessContract, ContractService<IngestContractModel> ingestContract, SecurityProfileService securityProfileService, GUID eip) {
            this.eip = eip;
            this.logbookClient = logbookClient;
            this.accessContract = accessContract;
            this.ingestContract = ingestContract;
            this.securityProfileService = securityProfileService;
            this.validators = new HashMap<ContextValidator, String>(){
                {
                    this.put(this.createMandatoryParamsValidator(), ContextServiceImpl.EMPTY_REQUIRED_FIELD);
                    this.put(this.securityProfileIdentifierValidator(), ContextServiceImpl.SECURITY_PROFILE_NOT_FOUND);
                    this.put(this.createCheckDuplicateInDatabaseValidator(), ContextServiceImpl.DUPLICATE_IN_DATABASE);
                    this.put(this.checkTenant(), ContextServiceImpl.UNKNOWN_VALUE);
                    this.put(this.checkContract(), ContextServiceImpl.UNKNOWN_VALUE);
                }
            };
        }

        public boolean validateContext(ContextModel context, VitamError<ContextModel> error) throws ReferentialException, InvalidParseOperationException {
            for (ContextValidator validator : this.validators.keySet()) {
                List<ContextValidator.ContextRejectionCause> validatorErrors = validator.validate(context);
                if (validatorErrors.isEmpty()) continue;
                for (ContextValidator.ContextRejectionCause validatorError : validatorErrors) {
                    error.addToErrors(new VitamError(VitamCode.CONTEXT_VALIDATION_ERROR.getItem()).setMessage(this.validators.get(validator)).setDescription(validatorError.getReason()).setState(StatusCode.KO.name()));
                }
                return false;
            }
            return true;
        }

        private void logStarted() throws VitamException {
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.eip, (String)ContextServiceImpl.CONTEXTS_IMPORT_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)ContextServiceImpl.CONTEXTS_IMPORT_EVENT, (StatusCode)StatusCode.STARTED), (GUID)this.eip);
            this.logbookClient.create(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logSuccess() throws VitamException {
            GUID eipUsage = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipUsage, (String)ContextServiceImpl.CONTEXTS_IMPORT_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)ContextServiceImpl.CONTEXTS_IMPORT_EVENT, (StatusCode)StatusCode.OK), (GUID)this.eip);
            this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logUpdateStarted(String id) throws VitamException {
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.eip, (String)ContextServiceImpl.CONTEXTS_UPDATE_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)ContextServiceImpl.CONTEXTS_UPDATE_EVENT, (StatusCode)StatusCode.STARTED), (GUID)this.eip);
            logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, "STP_UPDATE_CONTEXT." + String.valueOf(StatusCode.STARTED));
            if (null != id && !id.isEmpty()) {
                logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, id);
            }
            this.logbookClient.create(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logUpdateSuccess(String id, String evDetData) throws VitamException {
            GUID eipUsage = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipUsage, (String)ContextServiceImpl.CONTEXTS_UPDATE_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)ContextServiceImpl.CONTEXTS_UPDATE_EVENT, (StatusCode)StatusCode.OK), (GUID)this.eip);
            if (null != id && !id.isEmpty()) {
                logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, id);
            }
            logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, evDetData);
            logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, "STP_UPDATE_CONTEXT." + String.valueOf(StatusCode.OK));
            this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logDeleteStarted(String id) throws VitamException {
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.eip, (String)ContextServiceImpl.CONTEXTS_DELETE_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)ContextServiceImpl.CONTEXTS_DELETE_EVENT, (StatusCode)StatusCode.STARTED), (GUID)this.eip);
            logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, "STP_DELETE_CONTEXT." + String.valueOf(StatusCode.STARTED));
            if (null != id && !id.isEmpty()) {
                logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, id);
            }
            this.logbookClient.create(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logDeleteSuccess(String id) throws VitamException {
            GUID eipUsage = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipUsage, (String)ContextServiceImpl.CONTEXTS_DELETE_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)ContextServiceImpl.CONTEXTS_DELETE_EVENT, (StatusCode)StatusCode.OK), (GUID)this.eip);
            if (null != id && !id.isEmpty()) {
                logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, id);
            }
            logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, "STP_DELETE_CONTEXT." + String.valueOf(StatusCode.OK));
            this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logFatalError(String errorsDetails) throws VitamException {
            LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
            GUID eipUsage = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipUsage, (String)ContextServiceImpl.CONTEXTS_IMPORT_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.FATAL, (String)VitamLogbookMessages.getCodeOp((String)ContextServiceImpl.CONTEXTS_IMPORT_EVENT, (StatusCode)StatusCode.FATAL), (GUID)this.eip);
            this.logbookMessageError(errorsDetails, logbookParameters);
            this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logValidationError(String errorsDetails, String action, String KOEventType) throws VitamException {
            LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
            GUID eipUsage = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipUsage, (String)action, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getFromFullCodeKey((String)KOEventType), (GUID)this.eip);
            logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, KOEventType);
            this.logbookMessageError(errorsDetails, logbookParameters, KOEventType);
            this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logbookMessageError(String errorsDetails, LogbookOperationParameters logbookParameters) {
            if (null != errorsDetails && !errorsDetails.isEmpty()) {
                try {
                    ObjectNode object = JsonHandler.createObjectNode();
                    object.put("contextCheck", errorsDetails);
                    String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
                    logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
                }
                catch (InvalidParseOperationException invalidParseOperationException) {
                    // empty catch block
                }
            }
        }

        private void logbookMessageError(String errorsDetails, LogbookOperationParameters logbookParameters, String KOEventType) {
            if (null != errorsDetails && !errorsDetails.isEmpty()) {
                try {
                    ObjectNode object = JsonHandler.createObjectNode();
                    String evDetDataKey = "contextCheck";
                    switch (KOEventType) {
                        case "STP_IMPORT_CONTEXT.EMPTY_REQUIRED_FIELD.KO": {
                            evDetDataKey = "Mandatory fields";
                            break;
                        }
                        case "STP_IMPORT_CONTEXT.SECURITY_PROFILE_NOT_FOUND.KO": {
                            evDetDataKey = "Security profile not found";
                            break;
                        }
                        case "STP_IMPORT_CONTEXT.IDENTIFIER_DUPLICATION.KO": {
                            evDetDataKey = "Duplicate field";
                            break;
                        }
                        case "STP_IMPORT_CONTEXT.UNKNOWN_VALUE.KO": {
                            evDetDataKey = "Incorrect field";
                        }
                    }
                    object.put(evDetDataKey, errorsDetails);
                    String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
                    logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
                }
                catch (InvalidParseOperationException invalidParseOperationException) {
                    // empty catch block
                }
            }
        }

        private ContextValidator createMandatoryParamsValidator() {
            return context -> {
                ArrayList<ContextValidator.ContextRejectionCause> validationErrors = new ArrayList<ContextValidator.ContextRejectionCause>();
                if (StringUtils.isBlank((CharSequence)context.getName())) {
                    validationErrors.add(ContextValidator.ContextRejectionCause.rejectMandatoryMissing("Name"));
                }
                if (StringUtils.isBlank((CharSequence)context.getSecurityProfileIdentifier())) {
                    validationErrors.add(ContextValidator.ContextRejectionCause.rejectMandatoryMissing("SecurityProfile"));
                }
                if (context.getStatus() == null) {
                    context.setStatus(ContextStatus.INACTIVE);
                }
                return validationErrors;
            };
        }

        private ContextValidator securityProfileIdentifierValidator() {
            return context -> {
                Optional<SecurityProfileModel> securityProfileModel = this.securityProfileService.findOneByIdentifier(context.getSecurityProfileIdentifier());
                if (securityProfileModel.isEmpty()) {
                    return Collections.singletonList(ContextValidator.ContextRejectionCause.invalidSecurityProfile(context.getSecurityProfileIdentifier()));
                }
                return Collections.emptyList();
            };
        }

        private ContextValidator createCheckDuplicateInDatabaseValidator() {
            return context -> {
                if (ParametersChecker.isNotEmpty((String[])new String[]{context.getIdentifier()})) {
                    boolean exist;
                    Bson clause = Filters.eq((String)"Identifier", (Object)context.getIdentifier());
                    boolean bl = exist = FunctionalAdminCollections.CONTEXT.getCollection().countDocuments(clause) > 0L;
                    if (exist) {
                        return Collections.singletonList(ContextValidator.ContextRejectionCause.rejectDuplicatedInDatabase(context.getIdentifier()));
                    }
                }
                return Collections.emptyList();
            };
        }

        private ContextValidator checkContract() {
            return context -> {
                ArrayList<ContextValidator.ContextRejectionCause> validationErrors = new ArrayList<ContextValidator.ContextRejectionCause>();
                List pmList = context.getPermissions();
                for (PermissionModel pm : pmList) {
                    if (pm.getTenant() == null) {
                        validationErrors.add(ContextValidator.ContextRejectionCause.rejectNullTenant());
                        continue;
                    }
                    int tenant = pm.getTenant();
                    Set icList = pm.getIngestContract();
                    for (String ic : icList) {
                        if (this.checkIdentifierOfIngestContract(ic, tenant)) continue;
                        validationErrors.add(ContextValidator.ContextRejectionCause.rejectNoExistanceOfIngestContract(ic, tenant));
                    }
                    Set acList = pm.getAccessContract();
                    for (String ac : acList) {
                        if (this.checkIdentifierOfAccessContract(ac, tenant)) continue;
                        validationErrors.add(ContextValidator.ContextRejectionCause.rejectNoExistanceOfAccessContract(ac, tenant));
                    }
                }
                return validationErrors;
            };
        }

        private ContextValidator checkTenant() {
            return context -> {
                ArrayList<ContextValidator.ContextRejectionCause> validationErrors = new ArrayList<ContextValidator.ContextRejectionCause>();
                List pmList = context.getPermissions();
                for (PermissionModel pm : pmList) {
                    if (pm.getTenant() == null) {
                        validationErrors.add(ContextValidator.ContextRejectionCause.rejectNullTenant());
                        continue;
                    }
                    int tenant = pm.getTenant();
                    List tenants = VitamConfiguration.getTenants();
                    if (tenants.contains(tenant)) continue;
                    validationErrors.add(ContextValidator.ContextRejectionCause.rejectNoExistanceOfTenant(tenant));
                }
                return validationErrors;
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkIdentifierOfIngestContract(String ic, int tenant) throws ReferentialException, InvalidParseOperationException {
            int initialTenant = VitamThreadUtils.getVitamSession().getTenantId();
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenant));
                boolean bl = null != this.ingestContract.findByIdentifier(ic);
                return bl;
            }
            finally {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(initialTenant));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkIdentifierOfAccessContract(String ac, int tenant) throws ReferentialException, InvalidParseOperationException {
            int initialTenant = VitamThreadUtils.getVitamSession().getTenantId();
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenant));
                boolean bl = null != this.accessContract.findByIdentifier(ac);
                return bl;
            }
            finally {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(initialTenant));
            }
        }

        private ContextValidator checkEmptyIdentifierSlaveModeValidator() {
            return context -> {
                if (context.getIdentifier() == null || context.getIdentifier().isEmpty()) {
                    return Collections.singletonList(ContextValidator.ContextRejectionCause.rejectMandatoryMissing("Identifier"));
                }
                return Collections.emptyList();
            };
        }
    }
}

