/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.backup;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.VitamSequence;
import fr.gouv.vitam.functional.administration.common.counter.SequenceType;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.BackupServiceException;
import fr.gouv.vitam.functional.administration.common.exception.FunctionalBackupServiceException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.core.backup.BackupLogbookManager;
import fr.gouv.vitam.functional.administration.core.backup.BackupService;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

public class FunctionalBackupService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FunctionalBackupService.class);
    public static final String FIELD_COLLECTION = "collection";
    public static final String FIELD_SEQUENCE = "sequence";
    public static final String FIELD_BACKUP_SEQUENCE = "backup_sequence";
    public static final String DEFAULT_EXTENSION = "json";
    private static final int DEFAULT_ADMIN_TENANT = VitamConfiguration.getAdminTenant();
    private final BackupService backupService;
    private final VitamCounterService vitamCounterService;
    private final BackupLogbookManager backupLogbookManager;

    public FunctionalBackupService(VitamCounterService vitamCounterService) {
        this.vitamCounterService = vitamCounterService;
        this.backupService = new BackupService();
        this.backupLogbookManager = new BackupLogbookManager();
    }

    @VisibleForTesting
    public FunctionalBackupService(BackupService backupService, VitamCounterService vitamCounterService, BackupLogbookManager backupLogbookManager) {
        this.backupService = backupService;
        this.vitamCounterService = vitamCounterService;
        this.backupLogbookManager = backupLogbookManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCollectionAndSequence(GUID eipMaster, String eventCode, FunctionalAdminCollections collection, String objectIdentifier) throws VitamException {
        try {
            String digestStr;
            int initialTenant = ParameterHelper.getTenantParameter();
            int storageTenant = this.getStorageTenant(collection, initialTenant);
            VitamSequence backupSequence = this.vitamCounterService.getNextBackupSequenceDocument(Integer.valueOf(storageTenant), SequenceType.fromFunctionalAdminCollections((FunctionalAdminCollections)collection));
            String fileName = FunctionalBackupService.getBackupFileName(collection, storageTenant, backupSequence.getCounter());
            File file = null;
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(storageTenant));
                file = this.saveFunctionalCollectionToTempFile(collection, storageTenant, backupSequence);
                digestStr = this.storeBackupFileInStorage(fileName, file);
            }
            catch (Throwable throwable) {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(initialTenant));
                this.deleteTmpFile(file);
                throw throwable;
            }
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(initialTenant));
            this.deleteTmpFile(file);
            this.backupLogbookManager.logEventSuccess(eipMaster, eventCode, digestStr, fileName, objectIdentifier);
        }
        catch (BackupServiceException | ReferentialException | IOException e) {
            try {
                this.backupLogbookManager.logError(eipMaster, eventCode, e.getMessage());
            }
            catch (VitamException | RuntimeException logbookErrorException) {
                LOGGER.error("Could not persist backup error in logbook operation", logbookErrorException);
            }
            throw new FunctionalBackupServiceException("Could not backup collection " + String.valueOf(collection), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveDocument(FunctionalAdminCollections collection, Document document) throws FunctionalBackupServiceException {
        try {
            int initialTenant = ParameterHelper.getTenantParameter();
            Integer storageTenant = document.getInteger((Object)"_tenant");
            String fileName = String.format("%d_%s.%s", storageTenant, document.get((Object)"_id"), DEFAULT_EXTENSION);
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(BsonHelper.stringify((Document)document).getBytes());
                VitamThreadUtils.getVitamSession().setTenantId(storageTenant);
                switch (collection) {
                    case ACCESSION_REGISTER_DETAIL: {
                        this.storeBackupFileInStorage(fileName, is, DataCategory.ACCESSION_REGISTER_DETAIL);
                        return;
                    }
                    case ACCESSION_REGISTER_SYMBOLIC: {
                        this.storeBackupFileInStorage(fileName, is, DataCategory.ACCESSION_REGISTER_SYMBOLIC);
                        return;
                    }
                    default: {
                        this.storeBackupFileInStorage(fileName, is, DataCategory.BACKUP);
                        return;
                    }
                }
            }
            finally {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(initialTenant));
                StreamUtils.closeSilently((InputStream)is);
            }
        }
        catch (BackupServiceException e) {
            throw new FunctionalBackupServiceException("Could not backup document " + String.valueOf(document.get((Object)"_id")), (Throwable)e);
        }
        catch (Exception e) {
            throw new FunctionalBackupServiceException("Could not backup collection " + collection.toString(), (Throwable)e);
        }
    }

    private void deleteTmpFile(File file) {
        if (file != null && !file.delete()) {
            LOGGER.warn("Could not delete temp file {0}", (Object)file.getAbsolutePath());
        }
    }

    private int getStorageTenant(FunctionalAdminCollections collection, int sessionTenant) {
        if (collection.isMultitenant()) {
            return sessionTenant;
        }
        return DEFAULT_ADMIN_TENANT;
    }

    public static String getBackupFileName(FunctionalAdminCollections functionalAdminCollections, int tenant, Integer sequence) {
        return String.format("%d_%s_%d.%s", tenant, functionalAdminCollections.getName(), sequence, DEFAULT_EXTENSION);
    }

    public void saveFile(InputStream inputStream, GUID eipMaster, String eventCode, DataCategory dataCategory, String fileName) throws VitamException {
        DigestType digestType = VitamConfiguration.getDefaultDigestType();
        Digest digest = new Digest(digestType);
        InputStream digestInputStream = digest.getDigestInputStream(inputStream);
        try {
            this.backupService.backup(digestInputStream, dataCategory, fileName);
            this.backupLogbookManager.logEventSuccess(eipMaster, eventCode, digest.digestHex(), fileName, null);
        }
        catch (BackupServiceException e) {
            LOGGER.error((Throwable)e);
            this.backupLogbookManager.logError(eipMaster, eventCode, e.getMessage());
            throw new VitamException(e.getMessage());
        }
    }

    private File saveFunctionalCollectionToTempFile(FunctionalAdminCollections collectionToSave, int tenant, VitamSequence backupSequence) throws ReferentialException, IOException {
        String uniqueFileId = GUIDFactory.newGUID().getId();
        File file = PropertiesUtils.fileFromTmpFolder((String)uniqueFileId);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream buffOut = new BufferedOutputStream(fileOutputStream);
             JsonGenerator jsonGenerator = JsonHandler.createJsonGenerator((OutputStream)buffOut);){
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(FIELD_COLLECTION);
            jsonGenerator.writeStartArray();
            MongoCursor<Document> mongoCursor = this.getCurrentCollection(collectionToSave, tenant);
            while (mongoCursor.hasNext()) {
                Document document = (Document)mongoCursor.next();
                jsonGenerator.writeRawValue(BsonHelper.stringify((Document)document));
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeFieldName(FIELD_SEQUENCE);
            VitamSequence sequence = this.vitamCounterService.getSequenceDocument(Integer.valueOf(tenant), SequenceType.fromFunctionalAdminCollections((FunctionalAdminCollections)collectionToSave));
            jsonGenerator.writeRawValue(BsonHelper.stringify((Document)sequence));
            jsonGenerator.writeFieldName(FIELD_BACKUP_SEQUENCE);
            jsonGenerator.writeRawValue(BsonHelper.stringify((Document)backupSequence));
            jsonGenerator.writeEndObject();
            jsonGenerator.flush();
        }
        return file;
    }

    private MongoCursor<Document> getCurrentCollection(FunctionalAdminCollections collections, int tenant) {
        return collections.getCollection().find(this.getMangoFilter(collections, tenant)).sort(Sorts.ascending((String[])new String[]{"_id"})).iterator();
    }

    public ArrayNode getCollectionInJson(MongoCursor<Document> mongoCursor) throws InvalidParseOperationException {
        ArrayNode arrayNode = JsonHandler.createArrayNode();
        while (mongoCursor.hasNext()) {
            Document document = (Document)mongoCursor.next();
            arrayNode.add(JsonHandler.toJsonNode((Object)document));
        }
        return arrayNode;
    }

    public ArrayNode getCollectionInJson(FunctionalAdminCollections collections, int tenant) throws InvalidParseOperationException {
        return this.getCollectionInJson(this.getCurrentCollection(collections, tenant));
    }

    private Bson getMangoFilter(FunctionalAdminCollections collectionToSave, int tenant) {
        if (collectionToSave.isMultitenant()) {
            return Filters.eq((String)"_tenant", (Object)tenant);
        }
        return new BsonDocument();
    }

    private String storeBackupFileInStorage(String fileName, File file) throws IOException, BackupServiceException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = this.storeBackupFileInStorage(fileName, fileInputStream, DataCategory.BACKUP);
            return string;
        }
    }

    private String storeBackupFileInStorage(String fileName, InputStream is, DataCategory dataCategory) throws BackupServiceException {
        if (null == dataCategory) {
            dataCategory = DataCategory.BACKUP;
        }
        DigestType digestType = VitamConfiguration.getDefaultDigestType();
        Digest digest = new Digest(digestType);
        InputStream digestInputStream = digest.getDigestInputStream(is);
        this.backupService.backup(digestInputStream, dataCategory, fileName);
        String digestStr = digest.digestHex();
        return digestStr;
    }
}

