/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.backup;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;

public class BackupLogbookManager {
    public static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BackupLogbookManager.class);
    public static final String ERROR_MESSAGE = "Message";
    public static final String FILE_NAME = "FileName";
    public static final String DIGEST = "Digest";
    public static final String DIGESTTYPE = "DigestType";
    private final LogbookOperationsClientFactory logbookClientFactory;

    public BackupLogbookManager() {
        this.logbookClientFactory = LogbookOperationsClientFactory.getInstance();
    }

    @VisibleForTesting
    public BackupLogbookManager(LogbookOperationsClientFactory logbookClientFactory) {
        this.logbookClientFactory = logbookClientFactory;
    }

    public void logEventSuccess(GUID logbookOperationMasterId, String eventType, String digestStr, String fileName, String objectIdentifier) throws VitamException {
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)logbookOperationMasterId, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.OK), (GUID)logbookOperationMasterId);
        if (objectIdentifier != null && !objectIdentifier.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, objectIdentifier);
        }
        ObjectNode evDetData = JsonHandler.createObjectNode();
        evDetData.put(FILE_NAME, fileName);
        evDetData.put(DIGEST, digestStr);
        evDetData.put(DIGESTTYPE, VitamConfiguration.getDefaultDigestType().getName());
        logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, JsonHandler.unprettyPrint((Object)evDetData));
        LogbookOperationsClient logbookClient = this.logbookClientFactory.getClient();
        logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    public void logError(GUID logbookOperationMasterId, String eventType, String errorsDetails) throws VitamException {
        LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)logbookOperationMasterId, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.KO), (GUID)logbookOperationMasterId);
        this.logbookMessageError(errorsDetails, logbookParameters);
        LogbookOperationsClient logbookClient = this.logbookClientFactory.getClient();
        logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    private void logbookMessageError(String errorsDetails, LogbookOperationParameters logbookParameters) {
        ParametersChecker.checkParameter((String)errorsDetails, (String[])new String[0]);
        ObjectNode object = JsonHandler.createObjectNode();
        object.put(ERROR_MESSAGE, errorsDetails);
        try {
            String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
            logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException("Could not sanitize json message: " + errorsDetails, e);
        }
    }
}

