/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.audit;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.CanonicalJsonFormatter;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.AuditVitamException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.iterators.ArrayIterator;

public class ReferentialAuditService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReferentialAuditService.class);
    private static final AlertService alertService = new AlertServiceImpl();
    private static final String DIGEST = "digest";
    private final StorageClientFactory storageClientFactory;
    private final FunctionalBackupService functionalBackupService;

    public ReferentialAuditService(StorageClientFactory storageClientFactory, VitamCounterService vitamCounterService) {
        this.storageClientFactory = storageClientFactory;
        this.functionalBackupService = new FunctionalBackupService(vitamCounterService);
    }

    @VisibleForTesting
    ReferentialAuditService(StorageClientFactory storageClientFactory, FunctionalBackupService functionalBackupService) {
        this.storageClientFactory = storageClientFactory;
        this.functionalBackupService = functionalBackupService;
    }

    private static <T> Iterable<T> iteratorToIterable(Iterator<T> iterator) {
        return () -> iterator;
    }

    public void runAudit(String collectionName, int tenant) throws StorageServerClientException, StorageNotFoundException, InvalidParseOperationException, StorageNotFoundClientException, BadRequestException, AuditVitamException, StorageUnavailableDataFromAsyncOfferClientException {
        FunctionalAdminCollections collection = FunctionalAdminCollections.getFromValue((String)collectionName);
        if (Objects.isNull(collection)) {
            throw new BadRequestException("collection not found");
        }
        if (!collection.isMultitenant() && tenant != VitamConfiguration.getAdminTenant()) {
            throw new BadRequestException("admin tenant required");
        }
        Optional<ObjectEntry> objectEntryToAudit = StreamSupport.stream(ReferentialAuditService.iteratorToIterable(this.listObjectEntry()).spliterator(), false).filter(e -> this.matcherFilter((ObjectEntry)e, collection)).reduce(this::getLastBackupFile);
        ArrayNode documentsInDB = this.findDocuments(tenant, collection);
        if (objectEntryToAudit.isPresent()) {
            ObjectEntry next = objectEntryToAudit.get();
            List<String> offersIds = this.getOffers(VitamConfiguration.getDefaultStrategy());
            Map<String, String> hashMap = this.isHashesEquals(offersIds, next);
            this.verifyCoherence(offersIds, documentsInDB, next, hashMap, collectionName, tenant);
        } else if (!documentsInDB.isEmpty()) {
            String message = String.format("[KO] collection=%s, tenant=%s file not present in default offer (referent offer)", collectionName, tenant);
            alertService.createAlert(VitamLogLevel.ERROR, message);
            throw new AuditVitamException(message);
        }
    }

    private void verifyCoherence(List<String> offerIds, ArrayNode documentsInDB, ObjectEntry next, Map<String, String> mapOfHashes, String collectionName, int tenant) throws StorageNotFoundException, StorageServerClientException, AuditVitamException, StorageUnavailableDataFromAsyncOfferClientException {
        block12: {
            try (StorageClient storageClient = this.storageClientFactory.getClient();){
                boolean hasUniqueHash;
                boolean bl = hasUniqueHash = new HashSet<String>(mapOfHashes.values()).size() == 1;
                if (hasUniqueHash && mapOfHashes.keySet().containsAll(offerIds)) {
                    Response response = storageClient.getContainerAsync(VitamConfiguration.getDefaultStrategy(), next.getObjectId(), DataCategory.BACKUP, AccessLogUtils.getNoLogAccessLog());
                    try {
                        InputStream is2 = (InputStream)response.readEntity(InputStream.class);
                        ArrayNode documentsInJson = (ArrayNode)JsonHandler.getFromJsonNode((JsonNode)JsonHandler.getFromInputStream((InputStream)is2).get("collection"), (TypeReference)new TypeReference<ArrayNode>(this){});
                        List<String> list = this.diff(documentsInDB, documentsInJson);
                        if (!list.isEmpty()) {
                            String message = String.format("[KO] collectionName=%s, tenant=%s all offers are incoherent with database", collectionName, tenant);
                            alertService.createAlert(VitamLogLevel.ERROR, message);
                            throw new AuditVitamException(message);
                        }
                        break block12;
                    }
                    catch (InvalidParseOperationException e2) {
                        String message = String.format("[KO] collectionName=%s, tenant=%s all offers are incoherent with database", collectionName, tenant);
                        alertService.createAlert(VitamLogLevel.ERROR, message);
                        throw new AuditVitamException(message);
                    }
                }
                HashMap<String, Response> offersData = new HashMap<String, Response>();
                for (String offer : mapOfHashes.keySet()) {
                    offersData.put(offer, storageClient.getContainerAsync(VitamConfiguration.getDefaultStrategy(), offer, next.getObjectId(), DataCategory.BACKUP, AccessLogUtils.getNoLogAccessLog()));
                }
                Map<String, InputStream> collect = offersData.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, InputStream>((String)e.getKey(), (InputStream)((Response)e.getValue()).readEntity(InputStream.class))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
                HashMap documentsByOffer = new HashMap();
                HashSet listOffersThatContainsCorruptedFile = new HashSet();
                collect.forEach((offerId, is) -> {
                    try {
                        JsonNode fileJson = JsonHandler.getFromInputStream((InputStream)is);
                        if (fileJson != null && !(fileJson instanceof NullNode) && fileJson.has("collection")) {
                            documentsByOffer.put(offerId, (ArrayNode)JsonHandler.getFromJsonNode((JsonNode)fileJson.get("collection"), (TypeReference)new TypeReference<ArrayNode>(this){}));
                        } else {
                            listOffersThatContainsCorruptedFile.add(offerId);
                        }
                    }
                    catch (InvalidParseOperationException e) {
                        listOffersThatContainsCorruptedFile.add(offerId);
                    }
                });
                Set offersWhichCoherentWithDB = documentsByOffer.entrySet().stream().filter(e -> !listOffersThatContainsCorruptedFile.contains(e.getKey())).filter(e -> this.diff(documentsInDB, (ArrayNode)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
                if (offersWhichCoherentWithDB.isEmpty()) {
                    String message = String.format("[KO] collectionName=%s, tenant=%s all offers are incoherent with database", collectionName, tenant);
                    alertService.createAlert(VitamLogLevel.ERROR, message);
                    throw new AuditVitamException(message);
                }
                String message = String.format("[KO] collectionName=%s, tenant=%s some offers are incoherent with database\n\rcoherent offers = %s\n\rincoherent offers = %s\n\r", collectionName, tenant, offersWhichCoherentWithDB, Sets.difference(new HashSet<String>(offerIds), offersWhichCoherentWithDB));
                alertService.createAlert(VitamLogLevel.ERROR, message);
                throw new AuditVitamException(message);
            }
        }
    }

    private ArrayNode findDocuments(int tenant, FunctionalAdminCollections collection) throws InvalidParseOperationException {
        return this.functionalBackupService.getCollectionInJson(collection, tenant);
    }

    private List<String> diff(ArrayNode source, ArrayNode target) {
        return VitamDocument.getUnifiedDiff((String)JsonHandler.prettyPrint((Object)new String(CanonicalJsonFormatter.serializeToByteArray((JsonNode)source))), (String)JsonHandler.prettyPrint((Object)new String(CanonicalJsonFormatter.serializeToByteArray((JsonNode)target))));
    }

    private List<String> getOffers(String strategyId) throws StorageNotFoundClientException, StorageServerClientException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            List list = storageClient.getOffers(strategyId);
            return list;
        }
    }

    private ObjectEntry getLastBackupFile(ObjectEntry objectEntry, ObjectEntry objectEntry1) {
        if (objectEntry.getObjectId().compareTo(objectEntry1.getObjectId()) > 0) {
            return objectEntry;
        }
        return objectEntry1;
    }

    private boolean matcherFilter(ObjectEntry next, FunctionalAdminCollections collection) {
        Pattern pattern = Pattern.compile("(\\d+)_([A-z0-9]+)_(\\d+)(\\.json)");
        Matcher matcher = pattern.matcher(next.getObjectId());
        return matcher.matches() && matcher.group(2).equals(collection.getName());
    }

    private Iterator<ObjectEntry> listObjectEntry() throws StorageServerClientException {
        CloseableIterator closeableIterator;
        block8: {
            StorageClient storageClient = this.storageClientFactory.getClient();
            try {
                closeableIterator = storageClient.listContainer(VitamConfiguration.getDefaultStrategy(), null, DataCategory.BACKUP);
                if (storageClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageNotFoundClientException e) {
                    return new ArrayIterator((Object)new ObjectEntry[0]);
                }
            }
            storageClient.close();
        }
        return closeableIterator;
    }

    private Map<String, String> isHashesEquals(List<String> offerIds, ObjectEntry next) throws StorageServerClientException, StorageNotFoundClientException {
        String strategyId = VitamConfiguration.getDefaultStrategy();
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            JsonNode information = storageClient.getInformation(strategyId, DataCategory.BACKUP, next.getObjectId(), offerIds, false);
            Map<String, String> map = offerIds.stream().map(e -> new AbstractMap.SimpleEntry<String, JsonNode>((String)e, information.get(e))).filter(e -> Objects.nonNull(e.getValue())).filter(e -> !((JsonNode)e.getValue()).isMissingNode()).filter(e -> !((JsonNode)e.getValue()).isNull()).filter(e -> ((JsonNode)e.getValue()).has(DIGEST)).map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), ((JsonNode)e.getValue()).get(DIGEST).textValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return map;
        }
    }
}

