/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.archiveunitprofilesSchema;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.model.administration.CombinedSchemaModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaCardinality;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.functional.administration.core.archiveunitprofilesSchema.CombinedSchemaProcessor;

public class EffectiveCardinalityProcessor
implements CombinedSchemaProcessor {
    private SchemaResponse schemaResponse;
    private JsonNode controlSchemaNode;

    public EffectiveCardinalityProcessor() {
    }

    public EffectiveCardinalityProcessor(SchemaResponse schemaResponse, JsonNode controlSchemaNode) {
        this.schemaResponse = schemaResponse;
        this.controlSchemaNode = controlSchemaNode;
    }

    @Override
    public void process(CombinedSchemaModel model) {
        SchemaCardinality cardinality = this.schemaResponse.getCardinality();
        boolean isForbidden = this.isFieldForbiddenDueToAdditionalProperties(this.controlSchemaNode, this.schemaResponse.getPath());
        boolean isRequired = this.isFieldRequired(this.controlSchemaNode, this.schemaResponse.getPath());
        SchemaCardinality effectiveCardinality = isForbidden ? SchemaCardinality.ZERO : this.determineEffectiveCardinality(cardinality, this.schemaResponse, isRequired, this.controlSchemaNode);
        model.setEffectiveCardinality(effectiveCardinality.toString());
    }

    private boolean isFieldRequired(JsonNode controlSchemaNode, String fieldPath) {
        String[] pathSegments = fieldPath.split("\\.");
        JsonNode currentNode = controlSchemaNode;
        for (int i = 0; i < pathSegments.length - 1; ++i) {
            if ((currentNode = currentNode.path("properties").path(pathSegments[i])).isMissingNode()) {
                return false;
            }
            if (!currentNode.path("type").asText().equals("array")) continue;
            currentNode = currentNode.path("items");
        }
        String fieldName = pathSegments[pathSegments.length - 1];
        JsonNode requiredNode = currentNode.path("required");
        if (requiredNode.isArray()) {
            for (JsonNode requiredField : requiredNode) {
                if (!requiredField.asText().equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    private SchemaCardinality determineEffectiveCardinality(SchemaCardinality cardinality, SchemaResponse schema, Boolean isRequired, JsonNode controlSchemaNode) {
        boolean isArray = controlSchemaNode.path("properties").path(schema.getFieldName()).path("type").asText().equals("array");
        JsonNode fieldNode = controlSchemaNode.path("properties").path(schema.getFieldName());
        if (isArray) {
            int minItems = fieldNode.path("minItems").asInt(0);
            int maxItems = fieldNode.path("maxItems").asInt(Integer.MAX_VALUE);
            if (minItems == 0 && maxItems == 1) {
                return SchemaCardinality.ONE;
            }
            if (minItems == 1 && maxItems == 1) {
                return SchemaCardinality.ONE_REQUIRED;
            }
        }
        switch (cardinality) {
            case MANY_REQUIRED: {
                return isArray ? SchemaCardinality.MANY_REQUIRED : SchemaCardinality.ONE_REQUIRED;
            }
            case MANY: {
                return isArray ? (isRequired.booleanValue() ? SchemaCardinality.MANY_REQUIRED : SchemaCardinality.MANY) : (isRequired != false ? SchemaCardinality.ONE_REQUIRED : SchemaCardinality.ONE);
            }
            case ONE_REQUIRED: {
                return SchemaCardinality.ONE_REQUIRED;
            }
            case ONE: {
                return isRequired != false ? SchemaCardinality.ONE_REQUIRED : SchemaCardinality.ONE;
            }
        }
        return cardinality;
    }

    private boolean isFieldForbiddenDueToAdditionalProperties(JsonNode controlSchemaNode, String fieldPath) {
        String[] pathSegments = fieldPath.split("\\.");
        JsonNode currentNode = controlSchemaNode;
        for (String segment : pathSegments) {
            if (currentNode.has("additionalProperties") && !currentNode.get("additionalProperties").asBoolean() && !currentNode.path("properties").has(segment)) {
                return true;
            }
            if ((currentNode = currentNode.path("properties").path(segment)).isMissingNode()) break;
        }
        return false;
    }
}

