/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.archiveunitprofilesSchema;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.model.administration.CombinedSchemaModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.core.archiveunitprofiles.ArchiveUnitProfileService;
import fr.gouv.vitam.functional.administration.core.archiveunitprofilesSchema.ArchiveUnitProfileSchemaService;
import fr.gouv.vitam.functional.administration.core.archiveunitprofilesSchema.CombinedSchemaProcessor;
import fr.gouv.vitam.functional.administration.core.archiveunitprofilesSchema.ControlProcessor;
import fr.gouv.vitam.functional.administration.core.archiveunitprofilesSchema.EffectiveCardinalityProcessor;
import fr.gouv.vitam.functional.administration.core.archiveunitprofilesSchema.SchemaFillerProcessor;
import fr.gouv.vitam.functional.administration.core.schema.SchemaService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ArchiveUnitProfileSchemaServiceImpl
implements ArchiveUnitProfileSchemaService {
    private final ArchiveUnitProfileService archiveUnitProfileService;
    private final SchemaService schemaService;

    public ArchiveUnitProfileSchemaServiceImpl(ArchiveUnitProfileService archiveUnitProfileService, SchemaService schemaService) {
        this.archiveUnitProfileService = archiveUnitProfileService;
        this.schemaService = schemaService;
    }

    public List<CombinedSchemaModel> getCombinedSchemaModels(ArchiveUnitProfileModel profile, List<SchemaResponse> schemas) throws InvalidParseOperationException {
        ArrayList<CombinedSchemaModel> combinedSchemaModels = new ArrayList<CombinedSchemaModel>();
        JsonNode controlSchemaNode = JsonHandler.getFromString((String)profile.getControlSchema());
        for (SchemaResponse schema : schemas) {
            CombinedSchemaModel model = this.build(schema, controlSchemaNode);
            combinedSchemaModels.add(model);
        }
        return combinedSchemaModels;
    }

    public CombinedSchemaModel build(SchemaResponse schema, JsonNode controlSchemaNode) {
        ArrayList<CombinedSchemaProcessor> processors = new ArrayList<CombinedSchemaProcessor>();
        processors.add(new SchemaFillerProcessor(schema));
        processors.add(new ControlProcessor(controlSchemaNode, schema));
        processors.add(new EffectiveCardinalityProcessor(schema, controlSchemaNode));
        CombinedSchemaModel model = new CombinedSchemaModel();
        for (CombinedSchemaProcessor processor : processors) {
            processor.process(model);
        }
        return model;
    }

    @Override
    public List<CombinedSchemaModel> getCombinedSchemaModelsById(String identifier) throws ReferentialException, InvalidParseOperationException, IOException, InvalidCreateOperationException {
        RequestResponseOK<ArchiveUnitProfileModel> profileResponse = this.archiveUnitProfileService.findArchiveUnitProfiles(this.buildQueryByIdentifier(identifier));
        if (!profileResponse.isOk() || profileResponse.getResults().isEmpty()) {
            throw new ReferentialException("Archive unit profile not found for identifier: " + identifier);
        }
        ArchiveUnitProfileModel profile = (ArchiveUnitProfileModel)profileResponse.getResults().get(0);
        List<SchemaResponse> schemas = this.schemaService.findUnitSchema();
        return this.getCombinedSchemaModels(profile, schemas);
    }

    private JsonNode buildQueryByIdentifier(String identifier) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new SingleVarNameAdapter());
        parser.parse((JsonNode)new Select().getFinalSelect());
        parser.addCondition((Query)QueryHelper.eq((String)"Identifier", (String)identifier));
        return parser.getRequest().getFinalSelect();
    }
}

