/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.archiveunitprofiles;

import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import java.util.Optional;

@FunctionalInterface
public interface ArchiveUnitProfileValidator {
    public Optional<RejectionCause> validate(ArchiveUnitProfileModel var1);

    public static class RejectionCause {
        private static final String ERR_ID_NOT_ALLOWED_IN_CREATE = "Id must be null when creating archive unit profile (%s)";
        private static final String ERR_DUPLICATE_IDENTIFIER_ARCHIVE_PROFILE = "The archive unit profile identifier %s already exists in database";
        private static final String ERR_DUPLICATE_NAME_ARCHIVE_PROFILE = "The archive unit profile name %s already exists in database";
        private static final String ERR_MANDATORY_FIELD = "The field %s is mandatory";
        private static final String ERR_JSON_SHEMA = "The field %s is not a json schema";
        private static final String ERR_JSON_SCHEMA_IN_USE = "The field %s is used by an archiveUnit";
        private static final String ERR_MISSING_ONTOLOGY_FIELD = "The field %s specified in the schema is not declared in ontology";
        private static final String ERR_INCORRECT_ONTOLOGY_FIELD = "The field %s specified in the schema is not compatible with the one declared in ontology";
        private String reason;

        public RejectionCause(String error) {
            this.setReason(error);
        }

        public static RejectionCause rejectIdNotAllowedInCreate(String archiveUnitProfileIdentifier) {
            return new RejectionCause(String.format(ERR_ID_NOT_ALLOWED_IN_CREATE, archiveUnitProfileIdentifier));
        }

        public static RejectionCause rejectDuplicateIdentifierInDatabase(String identifier) {
            return new RejectionCause(String.format(ERR_DUPLICATE_IDENTIFIER_ARCHIVE_PROFILE, identifier));
        }

        public static RejectionCause rejectDuplicateNameInDatabase(String identifier) {
            return new RejectionCause(String.format(ERR_DUPLICATE_NAME_ARCHIVE_PROFILE, identifier));
        }

        public static RejectionCause rejectJsonSchemaModificationIfInUse(String fieldName) {
            return new RejectionCause(String.format(ERR_JSON_SCHEMA_IN_USE, fieldName));
        }

        public static RejectionCause rejectJsonShema(String fieldName) {
            return new RejectionCause(String.format(ERR_JSON_SHEMA, fieldName));
        }

        public static RejectionCause rejectMandatoryMissing(String fieldName) {
            return new RejectionCause(String.format(ERR_MANDATORY_FIELD, fieldName));
        }

        public static RejectionCause rejectMissingFieldInOntology(String fieldName) {
            return new RejectionCause(String.format(ERR_MISSING_ONTOLOGY_FIELD, fieldName));
        }

        public static RejectionCause rejectIncorrectFieldInOntology(String fieldName) {
            return new RejectionCause(String.format(ERR_INCORRECT_ONTOLOGY_FIELD, fieldName));
        }

        public String getReason() {
            return this.reason;
        }

        private void setReason(String reason) {
            this.reason = reason;
        }
    }
}

