/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.archiveunitprofiles;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.json.SchemaValidationUtils;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileSedaVersion;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileStatus;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.ArchiveUnitProfile;
import fr.gouv.vitam.functional.administration.common.Ontology;
import fr.gouv.vitam.functional.administration.common.VitamErrorUtils;
import fr.gouv.vitam.functional.administration.common.counter.SequenceType;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.archiveunitprofiles.ArchiveUnitProfileManager;
import fr.gouv.vitam.functional.administration.core.archiveunitprofiles.ArchiveUnitProfileService;
import fr.gouv.vitam.functional.administration.core.archiveunitprofiles.ArchiveUnitProfileValidator;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import jakarta.ws.rs.core.Response;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ArchiveUnitProfileServiceImpl
implements ArchiveUnitProfileService {
    public static final String ARCHIVE_UNIT_PROFILE_IDENTIFIER_ALREADY_EXISTS_IN_DATABASE = "Archive unit profile identifier already exists in database ";
    public static final String ARCHIVE_UNIT_PROFILE_IDENTIFIER_MUST_BE_STRING = "Archive unit profile identifier must be a string ";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ArchiveUnitProfileServiceImpl.class);
    private static final String ARCHIVE_UNIT_PROFILE_IMPORT_EVENT = "IMPORT_ARCHIVEUNITPROFILE";
    private static final String ARCHIVE_UNIT_PROFILE_BACKUP_EVENT = "BACKUP_ARCHIVEUNITPROFILE";
    private static final String ARCHIVE_UNIT_PROFILES_UPDATE_EVENT = "UPDATE_ARCHIVEUNITPROFILE";
    private static final String UPDATED_DIFFS = "updatedDiffs";
    private static final String ARCHIVE_UNIT_PROFILE_IS_MANDATORY_PARAMETER = "archive unit profiles parameter is mandatory";
    private static final String ARCHIVE_UNIT_PROFILE_NOT_FOUND = "Update a not found archive unit profile";
    private static final String ARCHIVE_UNIT_PROFILE_STATUS_MUST_BE_ACTIVE_OR_INACTIVE = "The archive unit profile status must be ACTIVE or INACTIVE but not ";
    private static final String ARCHIVE_UNIT_PROFILE_SEDA_VERSION_SHOULD_BE_VALID = "The archive unit profile seda version has an invalid value : ";
    private static final String UND_TENANT = "_tenant";
    private static final String UND_ID = "_id";
    private final MongoDbAccessAdminImpl mongoAccess;
    private final LogbookOperationsClient logbookClient;
    private final MetaDataClient metaDataClient;
    private final VitamCounterService vitamCounterService;
    private final FunctionalBackupService functionalBackupService;
    private boolean checkOntology = true;

    public ArchiveUnitProfileServiceImpl(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService, FunctionalBackupService functionalBackupService) {
        this.mongoAccess = mongoAccess;
        this.vitamCounterService = vitamCounterService;
        this.logbookClient = LogbookOperationsClientFactory.getInstance().getClient();
        this.metaDataClient = MetaDataClientFactory.getInstance().getClient();
        this.functionalBackupService = functionalBackupService;
    }

    @VisibleForTesting
    public ArchiveUnitProfileServiceImpl(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService, FunctionalBackupService functionalBackupService, boolean checkOntology) {
        this.mongoAccess = mongoAccess;
        this.vitamCounterService = vitamCounterService;
        this.logbookClient = LogbookOperationsClientFactory.getInstance().getClient();
        this.metaDataClient = MetaDataClientFactory.getInstance().getClient();
        this.functionalBackupService = functionalBackupService;
        this.checkOntology = checkOntology;
    }

    @Override
    public RequestResponse<ArchiveUnitProfileModel> createArchiveUnitProfiles(List<ArchiveUnitProfileModel> profileModelList) throws VitamException {
        ParametersChecker.checkParameter((String)ARCHIVE_UNIT_PROFILE_IS_MANDATORY_PARAMETER, (Object[])new Object[]{profileModelList});
        if (profileModelList.isEmpty()) {
            return new RequestResponseOK();
        }
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        boolean slaveMode = this.vitamCounterService.isSlaveFunctionnalCollectionOnTenant(SequenceType.ARCHIVE_UNIT_PROFILE_SEQUENCE.getCollection(), ParameterHelper.getTenantParameter());
        ArchiveUnitProfileManager manager = new ArchiveUnitProfileManager(this.logbookClient, this.metaDataClient, eip);
        manager.logStarted(ARCHIVE_UNIT_PROFILE_IMPORT_EVENT, null);
        HashSet<String> profileIdentifiers = new HashSet<String>();
        VitamError error = this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_FILE_IMPORT_ERROR.getItem(), "Global create archive unit profile error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        try {
            for (ArchiveUnitProfileModel archiveUnitProfileModel : profileModelList) {
                if (null != archiveUnitProfileModel.getId()) {
                    error.addToErrors(this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem(), ArchiveUnitProfileValidator.RejectionCause.rejectIdNotAllowedInCreate(archiveUnitProfileModel.getName()).getReason()));
                    continue;
                }
                if (ParametersChecker.isNotEmpty((String[])new String[]{archiveUnitProfileModel.getIdentifier()})) {
                    if (profileIdentifiers.contains(archiveUnitProfileModel.getIdentifier())) {
                        error.addToErrors(this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem(), "Duplicate archive unit profiles (ID)").setMessage("Archive unit profile identifier " + archiveUnitProfileModel.getIdentifier() + " already exists in the json"));
                        continue;
                    }
                    profileIdentifiers.add(archiveUnitProfileModel.getIdentifier());
                }
                if (manager.validateArchiveUnitProfile(archiveUnitProfileModel, error)) {
                    archiveUnitProfileModel.setId(GUIDFactory.newProfileGUID((int)ParameterHelper.getTenantParameter()).getId());
                }
                if (archiveUnitProfileModel.getTenant() == null) {
                    archiveUnitProfileModel.setTenant(ParameterHelper.getTenantParameter());
                }
                Optional<ArchiveUnitProfileValidator.RejectionCause> checkSchema = manager.createJsonSchemaValidator().validate(archiveUnitProfileModel);
                checkSchema.ifPresent(t -> {
                    VitamError vitamError = new VitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem()).setDescription(((ArchiveUnitProfileValidator.RejectionCause)checkSchema.get()).getReason()).setMessage("IMPORT_ARCHIVEUNITPROFILE.INVALID_JSON_SCHEMA.KO").setState(StatusCode.KO.name());
                    vitamError.setContext("FunctionalModule-ArchiveUnitProfile");
                    error.addToErrors(vitamError);
                });
                if (!slaveMode) continue;
                Optional<ArchiveUnitProfileValidator.RejectionCause> result = manager.checkEmptyIdentifierSlaveModeValidator().validate(archiveUnitProfileModel);
                result.ifPresent(t -> {
                    VitamError vitamError = new VitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem()).setMessage("IMPORT_ARCHIVEUNITPROFILE.EMPTY_REQUIRED_FIELD.KO").setDescription(((ArchiveUnitProfileValidator.RejectionCause)result.get()).getReason()).setState(StatusCode.KO.name());
                    vitamError.setContext("FunctionalModule-ArchiveUnitProfile");
                    error.addToErrors(vitamError);
                });
            }
            if (null != error.getErrors() && !error.getErrors().isEmpty()) {
                String errorsDetails = error.getErrors().stream().map(VitamError::getDescription).collect(Collectors.joining(","));
                manager.logValidationError(ARCHIVE_UNIT_PROFILE_IMPORT_EVENT, null, errorsDetails, ((VitamError)error.getErrors().get(0)).getMessage());
                return error;
            }
            ArrayNode archiveProfilesToPersist = JsonHandler.createArrayNode();
            Map<String, OntologyModel> ontologyModelMap = this.getOntologyModelMap();
            for (ArchiveUnitProfileModel aupm : profileModelList) {
                JsonNode hashTenant;
                ObjectNode archiveProfileNode;
                JsonNode jsonNode;
                this.setIdentifier(slaveMode, aupm);
                if (aupm.getControlSchema() != null) {
                    List schemaFields = SchemaValidationUtils.extractFieldsFromSchema((String)aupm.getControlSchema());
                    if (this.checkOntology) {
                        schemaFields.forEach(k -> this.validateFieldInSchemaAgainstOntology(ontologyModelMap, (String)k, (VitamError<ArchiveUnitProfileModel>)error));
                    }
                    aupm.setFields(schemaFields);
                }
                if ((jsonNode = (archiveProfileNode = (ObjectNode)JsonHandler.toJsonNode((Object)aupm)).remove(VitamFieldsHelper.id())) != null) {
                    archiveProfileNode.set(UND_ID, jsonNode);
                }
                if ((hashTenant = archiveProfileNode.remove(VitamFieldsHelper.tenant())) != null) {
                    archiveProfileNode.set(UND_TENANT, hashTenant);
                }
                archiveProfilesToPersist.add((JsonNode)archiveProfileNode);
            }
            if (null != error.getErrors() && !error.getErrors().isEmpty()) {
                String string = error.getErrors().stream().map(VitamError::getDescription).collect(Collectors.joining(","));
                manager.logValidationError(ARCHIVE_UNIT_PROFILE_IMPORT_EVENT, null, string, ((VitamError)error.getErrors().get(0)).getMessage());
                return error;
            }
            this.mongoAccess.insertDocuments(archiveProfilesToPersist, FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE).close();
            this.functionalBackupService.saveCollectionAndSequence(eip, ARCHIVE_UNIT_PROFILE_BACKUP_EVENT, FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE, eip.toString());
        }
        catch (SchemaValidationException e) {
            LOGGER.error((Throwable)e);
            String string = "Import archive unit profile error > " + e.getMessage();
            manager.logValidationError(ARCHIVE_UNIT_PROFILE_IMPORT_EVENT, null, string, "IMPORT_ARCHIVEUNITPROFILE.KO");
            return this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem(), e.getMessage()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (Exception e) {
            String string = "Import archive unit profiles error : " + e.getMessage();
            manager.logFatalError(ARCHIVE_UNIT_PROFILE_IMPORT_EVENT, null, string);
            return this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_FILE_IMPORT_ERROR.getItem(), string).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        manager.logSuccess(ARCHIVE_UNIT_PROFILE_IMPORT_EVENT, null, null);
        return new RequestResponseOK().addAllResults(profileModelList).setHttpCode(Response.Status.CREATED.getStatusCode());
    }

    @Override
    public RequestResponseOK<ArchiveUnitProfileModel> findArchiveUnitProfiles(JsonNode queryDsl) throws ReferentialException, InvalidParseOperationException {
        try (DbRequestResult result = this.mongoAccess.findDocuments(queryDsl, FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(queryDsl, ArchiveUnitProfile.class, ArchiveUnitProfileModel.class);
            return requestResponseOK;
        }
    }

    @Override
    public RequestResponse<ArchiveUnitProfileModel> updateArchiveUnitProfile(String id, JsonNode queryDsl) throws VitamException {
        String err;
        ArchiveUnitProfileModel profileModel = this.findByIdentifier(id);
        if (profileModel == null) {
            return this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem(), ARCHIVE_UNIT_PROFILE_NOT_FOUND).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).setMessage("UPDATE_ARCHIVEUNITPROFILE.AUP_NOT_FOUND.KO");
        }
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        ArchiveUnitProfileManager manager = new ArchiveUnitProfileManager(this.logbookClient, this.metaDataClient, eip);
        manager.logStarted(ARCHIVE_UNIT_PROFILES_UPDATE_EVENT, profileModel.getId());
        if (queryDsl == null || !queryDsl.isObject()) {
            manager.logValidationError(ARCHIVE_UNIT_PROFILES_UPDATE_EVENT, profileModel.getId(), "Update query dsl must be an object and not null", "UPDATE_ARCHIVEUNITPROFILE.KO");
            return this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem(), "Update query dsl must be an object and not null : " + profileModel.getIdentifier()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage("UPDATE_ARCHIVEUNITPROFILE.KO");
        }
        VitamError error = this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem(), "Update archive unit profile error : " + profileModel.getIdentifier()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        JsonNode actionNode = queryDsl.get(BuilderToken.GLOBAL.ACTION.exactToken());
        boolean schemaUpdate = false;
        String newSchema = null;
        ArchiveUnitProfileSedaVersion sedaVersion = ArchiveUnitProfileSedaVersion.VERSION_2_3;
        if (profileModel.getSedaVersion() != null) {
            sedaVersion = profileModel.getSedaVersion();
        }
        for (JsonNode fieldToSet : actionNode) {
            JsonNode fieldName = fieldToSet.get(BuilderToken.UPDATEACTION.SET.exactToken());
            if (fieldName == null) continue;
            Iterator it = fieldName.fieldNames();
            while (it.hasNext()) {
                String field = (String)it.next();
                JsonNode value = fieldName.findValue(field);
                if ("ControlSchema".equals(field)) {
                    schemaUpdate = true;
                    newSchema = value.asText();
                }
                this.validateUpdateAction(profileModel, (VitamError<ArchiveUnitProfileModel>)error, field, value, manager);
                if (!"SedaVersion".equals(field)) continue;
                sedaVersion = ArchiveUnitProfileSedaVersion.forVersion((String)value.asText());
            }
            ((ObjectNode)fieldName).remove("CreationDate");
            ((ObjectNode)fieldName).put("LastUpdate", LocalDateUtil.nowFormatted());
            ((ObjectNode)fieldName).put("SedaVersion", sedaVersion.getVersion());
        }
        if (schemaUpdate) {
            try {
                if (newSchema != null) {
                    Map<String, OntologyModel> ontologyModelMap = this.getOntologyModelMap();
                    ObjectNode fieldsObjectNode = JsonHandler.createObjectNode();
                    ArrayNode fieldsNode = JsonHandler.createArrayNode();
                    List schemaFields = SchemaValidationUtils.extractFieldsFromSchema(newSchema);
                    if (this.checkOntology) {
                        schemaFields.forEach(k -> {
                            this.validateFieldInSchemaAgainstOntology(ontologyModelMap, (String)k, (VitamError<ArchiveUnitProfileModel>)error);
                            fieldsNode.add(k);
                        });
                    }
                    fieldsObjectNode.set("Fields", (JsonNode)fieldsNode);
                    ObjectNode setFields = JsonHandler.createObjectNode();
                    setFields.set(BuilderToken.UPDATEACTION.SET.exactToken(), (JsonNode)fieldsObjectNode);
                    ((ArrayNode)actionNode).add((JsonNode)setFields);
                }
            }
            catch (InvalidParseOperationException e) {
                LOGGER.error((Throwable)e);
                error.addToErrors(new VitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem()).setDescription("The archive unit profile name contains bad fields in its schema").setMessage("UPDATE_ARCHIVEUNITPROFILE.KO"));
            }
        }
        if (error.getErrors() != null && error.getErrors().size() > 0) {
            String errorsDetails = error.getErrors().stream().map(VitamError::getDescription).collect(Collectors.joining(","));
            manager.logValidationError(ARCHIVE_UNIT_PROFILES_UPDATE_EVENT, profileModel.getId(), errorsDetails, ((VitamError)error.getErrors().get(0)).getMessage());
            return error;
        }
        String wellFormedJson = null;
        try {
            Map updateDiffs;
            try (DbRequestResult result = this.mongoAccess.updateData(queryDsl, FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE);){
                updateDiffs = result.getDiffs();
            }
            catch (BadRequestException | SchemaValidationException e) {
                LOGGER.error(e);
                err = "Update archive unit profile error > " + e.getMessage();
                manager.logValidationError(ARCHIVE_UNIT_PROFILES_UPDATE_EVENT, profileModel.getId(), err, "UPDATE_ARCHIVEUNITPROFILE.KO");
                return this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem(), e.getMessage()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
            }
            List diff = (List)updateDiffs.get(profileModel.getId());
            try {
                ObjectNode object = JsonHandler.createObjectNode();
                object.put(UPDATED_DIFFS, Joiner.on((String)" ").join((Iterable)diff));
                wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.info("Invalid parse Exception while sanitize updated diffs");
            }
            this.functionalBackupService.saveCollectionAndSequence(eip, ARCHIVE_UNIT_PROFILE_BACKUP_EVENT, FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE, profileModel.getId());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            err = "Update archive unit profile error : " + e.getMessage();
            manager.logFatalError(ARCHIVE_UNIT_PROFILES_UPDATE_EVENT, profileModel.getId(), err);
            error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            return error;
        }
        manager.logSuccess(ARCHIVE_UNIT_PROFILES_UPDATE_EVENT, profileModel.getId(), wellFormedJson);
        return new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode());
    }

    public void close() {
        if (null != this.logbookClient) {
            this.logbookClient.close();
        }
    }

    @VisibleForTesting
    public ArchiveUnitProfileModel findByIdentifier(String id) throws ReferentialException, InvalidParseOperationException {
        SanityChecker.checkParameter((String[])new String[]{id});
        SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new SingleVarNameAdapter());
        parser.parse((JsonNode)new Select().getFinalSelect());
        try {
            parser.addCondition((Query)QueryHelper.eq((String)"Identifier", (String)id));
        }
        catch (InvalidCreateOperationException e) {
            throw new ReferentialException((Throwable)e);
        }
        try (DbRequestResult result = this.mongoAccess.findDocuments((JsonNode)parser.getRequest().getFinalSelect(), FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE);){
            List list = result.getDocuments(ArchiveUnitProfile.class, ArchiveUnitProfileModel.class);
            if (list.isEmpty()) {
                ArchiveUnitProfileModel archiveUnitProfileModel = null;
                return archiveUnitProfileModel;
            }
            ArchiveUnitProfileModel archiveUnitProfileModel = (ArchiveUnitProfileModel)list.get(0);
            return archiveUnitProfileModel;
        }
    }

    private void validateUpdateAction(ArchiveUnitProfileModel profileModel, VitamError<ArchiveUnitProfileModel> error, String field, JsonNode value, ArchiveUnitProfileManager manager) {
        Optional<ArchiveUnitProfileValidator.RejectionCause> checkSchema;
        if ("Status".equals(field) && !ArchiveUnitProfileStatus.ACTIVE.name().equals(value.asText()) && !ArchiveUnitProfileStatus.INACTIVE.name().equals(value.asText())) {
            error.addToErrors(this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem(), ARCHIVE_UNIT_PROFILE_STATUS_MUST_BE_ACTIVE_OR_INACTIVE + value.asText()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage("UPDATE_ARCHIVEUNITPROFILE.NOT_IN_ENUM.KO"));
        }
        if ("SedaVersion".equals(field)) {
            try {
                ArchiveUnitProfileSedaVersion.forVersion((String)value.asText());
            }
            catch (IllegalArgumentException e) {
                error.addToErrors(this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem(), ARCHIVE_UNIT_PROFILE_SEDA_VERSION_SHOULD_BE_VALID + value.asText()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage("UPDATE_ARCHIVEUNITPROFILE.NOT_IN_ENUM.KO"));
            }
        }
        if ("ControlSchema".equals(field)) {
            checkSchema = manager.createJsonSchemaValidator().validate(new ArchiveUnitProfileModel().setControlSchema(value.asText()));
            checkSchema.ifPresent(t -> error.addToErrors(new VitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem()).setDescription(((ArchiveUnitProfileValidator.RejectionCause)checkSchema.get()).getReason()).setMessage("UPDATE_ARCHIVEUNITPROFILE.KO")));
        }
        if ("Identifier".equals(field)) {
            Optional<ArchiveUnitProfileValidator.RejectionCause> validateIdentifier;
            if (!value.isTextual()) {
                error.addToErrors(this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem(), "Archive unit profile identifier must be a string  : " + value.asText()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage("UPDATE_ARCHIVEUNITPROFILE.KO"));
            } else if (!profileModel.getIdentifier().equals(value.asText()) && (validateIdentifier = manager.createCheckDuplicateInDatabaseValidator().validate(new ArchiveUnitProfileModel().setIdentifier(value.asText()))).isPresent()) {
                error.addToErrors(this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem(), "Archive unit profile identifier already exists in database  : " + value.asText()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage("UPDATE_ARCHIVEUNITPROFILE.IDENTIFIER_DUPLICATION.KO"));
            }
        }
        if ("ControlSchema".equals(field)) {
            checkSchema = manager.createJsonSchemaValidator().validate(profileModel);
            checkSchema.ifPresent(t -> error.addToErrors(new VitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem()).setDescription(((ArchiveUnitProfileValidator.RejectionCause)checkSchema.get()).getReason()).setMessage("UPDATE_ARCHIVEUNITPROFILE.KO")));
            Optional<ArchiveUnitProfileValidator.RejectionCause> checkUsedJsonSchema = manager.createCheckUsedJsonSchema().validate(profileModel);
            checkUsedJsonSchema.ifPresent(t -> error.addToErrors(new VitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem()).setDescription(((ArchiveUnitProfileValidator.RejectionCause)checkUsedJsonSchema.get()).getReason()).setMessage("UPDATE_ARCHIVEUNITPROFILE.KO")));
        }
    }

    private void setIdentifier(boolean slaveMode, ArchiveUnitProfileModel archiveUnitProfilModel) throws ReferentialException {
        if (!slaveMode) {
            String code = this.vitamCounterService.getNextSequenceAsString(ParameterHelper.getTenantParameter(), SequenceType.ARCHIVE_UNIT_PROFILE_SEQUENCE);
            archiveUnitProfilModel.setIdentifier(code);
        }
    }

    private VitamError<ArchiveUnitProfileModel> getVitamError(String vitamCode, String error) {
        return VitamErrorUtils.getVitamError((String)vitamCode, (String)error, (String)"ArchiveUnitProfile", (StatusCode)StatusCode.KO, ArchiveUnitProfileModel.class);
    }

    private Map<String, OntologyModel> getOntologyModelMap() throws ReferentialException, InvalidParseOperationException {
        Select select = new Select();
        ObjectNode queryDsl = select.getFinalSelect();
        try (DbRequestResult result = this.mongoAccess.findDocuments((JsonNode)queryDsl, FunctionalAdminCollections.ONTOLOGY);){
            RequestResponseOK ontologyModelResponse = result.getRequestResponseOK((JsonNode)queryDsl, Ontology.class, OntologyModel.class);
            List ontologyModelList = ontologyModelResponse.getResults();
            Map<String, OntologyModel> map = ontologyModelList.stream().collect(Collectors.toMap(OntologyModel::getIdentifier, c -> c));
            return map;
        }
    }

    private void validateFieldInSchemaAgainstOntology(Map<String, OntologyModel> ontologyMap, String field, VitamError<ArchiveUnitProfileModel> error) {
        if (!ontologyMap.containsKey(field)) {
            error.addToErrors(this.getVitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem(), ArchiveUnitProfileValidator.RejectionCause.rejectMissingFieldInOntology(field).getReason()));
        }
    }
}

