/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.archiveunitprofiles;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.InvalidJsonSchemaException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.json.JsonSchemaValidator;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileSedaVersion;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileStatus;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.core.archiveunitprofiles.ArchiveUnitProfileValidator;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import java.util.HashMap;
import java.util.Optional;
import org.bson.conversions.Bson;

public class ArchiveUnitProfileManager {
    public static final String EMPTY_REQUIRED_FIELD = "IMPORT_ARCHIVEUNITPROFILE.EMPTY_REQUIRED_FIELD.KO";
    public static final String WRONG_FIELD_FORMAT = "IMPORT_ARCHIVEUNITPROFILE.TO_BE_DEFINED.KO";
    public static final String DUPLICATE_IN_DATABASE = "IMPORT_ARCHIVEUNITPROFILE.IDENTIFIER_DUPLICATION.KO";
    public static final String INVALID_JSON_SCHEMA = "IMPORT_ARCHIVEUNITPROFILE.INVALID_JSON_SCHEMA.KO";
    public static final String IMPORT_KO = "IMPORT_ARCHIVEUNITPROFILE.KO";
    public static final String UPDATE_AUP_NOT_FOUND = "UPDATE_ARCHIVEUNITPROFILE.AUP_NOT_FOUND.KO";
    public static final String UPDATE_VALUE_NOT_IN_ENUM = "UPDATE_ARCHIVEUNITPROFILE.NOT_IN_ENUM.KO";
    public static final String UPDATE_DUPLICATE_IN_DATABASE = "UPDATE_ARCHIVEUNITPROFILE.IDENTIFIER_DUPLICATION.KO";
    public static final String UPDATE_KO = "UPDATE_ARCHIVEUNITPROFILE.KO";
    private static final String FUNCTIONAL_MODULE_ARCHIVE_UNIT_PROFILE = "FunctionalModule-ArchiveUnitProfile";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ArchiveUnitProfileManager.class);
    private final HashMap<ArchiveUnitProfileValidator, String> validators;
    private final GUID eip;
    private final LogbookOperationsClient logbookClient;
    private final MetaDataClient metaDataClient;

    public ArchiveUnitProfileManager(LogbookOperationsClient logbookClient, MetaDataClient metaDataClient, GUID eip) {
        this.logbookClient = logbookClient;
        this.metaDataClient = metaDataClient;
        this.eip = eip;
        this.validators = new HashMap<ArchiveUnitProfileValidator, String>(){
            {
                this.put(ArchiveUnitProfileManager.this.createMandatoryParamsValidator(), ArchiveUnitProfileManager.EMPTY_REQUIRED_FIELD);
                this.put(ArchiveUnitProfileManager.this.createWrongFieldFormatValidator(), ArchiveUnitProfileManager.WRONG_FIELD_FORMAT);
                this.put(ArchiveUnitProfileManager.this.createCheckDuplicateInDatabaseValidator(), ArchiveUnitProfileManager.DUPLICATE_IN_DATABASE);
            }
        };
    }

    public boolean validateArchiveUnitProfile(ArchiveUnitProfileModel profile, VitamError error) {
        for (ArchiveUnitProfileValidator validator : this.validators.keySet()) {
            Optional<ArchiveUnitProfileValidator.RejectionCause> result = validator.validate(profile);
            if (!result.isPresent()) continue;
            error.addToErrors(this.getVitamError(this.validators.get(validator), result.get().getReason()));
            return false;
        }
        return true;
    }

    private VitamError getVitamError(String message, String description) {
        return new VitamError(VitamCode.ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR.getItem()).setMessage(message).setContext(FUNCTIONAL_MODULE_ARCHIVE_UNIT_PROFILE).setDescription(description).setState(StatusCode.KO.name());
    }

    public void logValidationError(String eventType, String objectId, String errorsDetails, String KOEventType) throws VitamException {
        LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getFromFullCodeKey((String)KOEventType), (GUID)this.eip);
        logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, KOEventType);
        this.logbookMessageError(objectId, errorsDetails, logbookParameters, KOEventType);
        this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    private void logbookMessageError(String objectId, String errorsDetails, LogbookOperationParameters logbookParameters) {
        if (null != errorsDetails && !errorsDetails.isEmpty()) {
            try {
                ObjectNode object = JsonHandler.createObjectNode();
                object.put("archiveUnitProfileCheck", errorsDetails);
                String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
                logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            }
            catch (InvalidParseOperationException invalidParseOperationException) {
                // empty catch block
            }
        }
        if (null != objectId && !objectId.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, objectId);
        }
    }

    private void logbookMessageError(String objectId, String errorsDetails, LogbookOperationParameters logbookParameters, String KOEventType) {
        if (null != errorsDetails && !errorsDetails.isEmpty()) {
            try {
                ObjectNode object = JsonHandler.createObjectNode();
                String evDetDataKey = "archiveUnitProfileCheck";
                switch (KOEventType) {
                    case "IMPORT_ARCHIVEUNITPROFILE.EMPTY_REQUIRED_FIELD.KO": {
                        evDetDataKey = "Mandatory Fields";
                        break;
                    }
                    case "IMPORT_ARCHIVEUNITPROFILE.TO_BE_DEFINED.KO": {
                        evDetDataKey = "Incorrect Field and value";
                        break;
                    }
                    case "IMPORT_ARCHIVEUNITPROFILE.IDENTIFIER_DUPLICATION.KO": 
                    case "UPDATE_ARCHIVEUNITPROFILE.IDENTIFIER_DUPLICATION.KO": {
                        evDetDataKey = "Duplicate Field";
                        break;
                    }
                    case "IMPORT_ARCHIVEUNITPROFILE.INVALID_JSON_SCHEMA.KO": {
                        evDetDataKey = "Invalid JSON schema";
                        break;
                    }
                    case "UPDATE_ARCHIVEUNITPROFILE.AUP_NOT_FOUND.KO": {
                        evDetDataKey = "Archive unit profile not found";
                        break;
                    }
                    case "UPDATE_ARCHIVEUNITPROFILE.NOT_IN_ENUM.KO": {
                        evDetDataKey = "Not in Enum";
                    }
                }
                object.put(evDetDataKey, errorsDetails);
                String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
                logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            }
            catch (InvalidParseOperationException invalidParseOperationException) {
                // empty catch block
            }
        }
        if (null != objectId && !objectId.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, objectId);
        }
    }

    public void logFatalError(String eventType, String objectId, String errorsDetails) throws VitamException {
        LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.FATAL, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.FATAL), (GUID)this.eip);
        this.logbookMessageError(objectId, errorsDetails, logbookParameters);
        this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    public void logStarted(String eventType, String objectId) throws VitamException {
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.eip, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.STARTED), (GUID)this.eip);
        this.logbookMessageError(objectId, null, logbookParameters);
        this.logbookClient.create(new LogbookOperationParameters[]{logbookParameters});
    }

    public void logSuccess(String eventType, String objectId, String message) throws VitamException {
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.OK), (GUID)this.eip);
        if (null != objectId && !objectId.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, objectId);
        }
        if (null != message && !message.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, message);
        }
        this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    public ArchiveUnitProfileValidator createMandatoryParamsValidator() {
        return profile -> {
            ArchiveUnitProfileValidator.RejectionCause rejection = null;
            if (profile.getName() == null || profile.getName().length() == 0) {
                rejection = ArchiveUnitProfileValidator.RejectionCause.rejectMandatoryMissing("Name");
            }
            return rejection == null ? Optional.empty() : Optional.of(rejection);
        };
    }

    public ArchiveUnitProfileValidator createWrongFieldFormatValidator() {
        return archiveUnitProfile -> {
            ArchiveUnitProfileValidator.RejectionCause rejection = null;
            String now = LocalDateUtil.nowFormatted();
            if (archiveUnitProfile.getStatus() == null) {
                archiveUnitProfile.setStatus(ArchiveUnitProfileStatus.INACTIVE);
            }
            if (archiveUnitProfile.getSedaVersion() == null) {
                archiveUnitProfile.setSedaVersion(ArchiveUnitProfileSedaVersion.VERSION_2_3);
            }
            try {
                if (archiveUnitProfile.getCreationdate() == null || archiveUnitProfile.getCreationdate().trim().isEmpty()) {
                    archiveUnitProfile.setCreationdate(now);
                } else {
                    archiveUnitProfile.setCreationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)archiveUnitProfile.getCreationdate()));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error profile parse dates", (Throwable)e);
                rejection = ArchiveUnitProfileValidator.RejectionCause.rejectMandatoryMissing("CreationDate");
            }
            try {
                if (archiveUnitProfile.getActivationdate() == null || archiveUnitProfile.getActivationdate().trim().isEmpty()) {
                    archiveUnitProfile.setActivationdate(now);
                } else {
                    archiveUnitProfile.setActivationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)archiveUnitProfile.getActivationdate()));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error profile parse dates", (Throwable)e);
                rejection = ArchiveUnitProfileValidator.RejectionCause.rejectMandatoryMissing("ActivationDate");
            }
            try {
                if (archiveUnitProfile.getDeactivationdate() == null || archiveUnitProfile.getDeactivationdate().trim().isEmpty()) {
                    archiveUnitProfile.setDeactivationdate(now);
                } else {
                    archiveUnitProfile.setDeactivationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)archiveUnitProfile.getDeactivationdate()));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error profile parse dates", (Throwable)e);
                rejection = ArchiveUnitProfileValidator.RejectionCause.rejectMandatoryMissing("DeactivationDate");
            }
            archiveUnitProfile.setLastupdate(now);
            return rejection == null ? Optional.empty() : Optional.of(rejection);
        };
    }

    public ArchiveUnitProfileValidator checkEmptyIdentifierSlaveModeValidator() {
        return archiveUnitProfile -> {
            if (archiveUnitProfile.getIdentifier() == null || archiveUnitProfile.getIdentifier().isEmpty()) {
                return Optional.of(ArchiveUnitProfileValidator.RejectionCause.rejectMandatoryMissing("Identifier"));
            }
            return Optional.empty();
        };
    }

    public ArchiveUnitProfileValidator createCheckDuplicateInDatabaseValidator() {
        return profile -> {
            if (ParametersChecker.isNotEmpty((String[])new String[]{profile.getIdentifier()})) {
                boolean exist;
                int tenant = ParameterHelper.getTenantParameter();
                Bson clause = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_tenant", (Object)tenant), Filters.eq((String)"Identifier", (Object)profile.getIdentifier())});
                boolean bl = exist = FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE.getCollection().countDocuments(clause) > 0L;
                if (exist) {
                    return Optional.of(ArchiveUnitProfileValidator.RejectionCause.rejectDuplicateIdentifierInDatabase(profile.getIdentifier()));
                }
            }
            return Optional.empty();
        };
    }

    public ArchiveUnitProfileValidator createJsonSchemaValidator() {
        return profile -> {
            if (profile.getControlSchema() != null) {
                try {
                    JsonSchemaValidator.forUserSchema((String)profile.getControlSchema());
                    return Optional.empty();
                }
                catch (InvalidJsonSchemaException e) {
                    return Optional.of(ArchiveUnitProfileValidator.RejectionCause.rejectJsonShema("ControlSchema"));
                }
            }
            return Optional.of(ArchiveUnitProfileValidator.RejectionCause.rejectMandatoryMissing("ControlSchema"));
        };
    }

    public ArchiveUnitProfileValidator createCheckUsedJsonSchema() {
        return profile -> {
            if (ParametersChecker.isNotEmpty((String[])new String[]{profile.getIdentifier()})) {
                SelectMultiQuery selectMultiple = new SelectMultiQuery();
                try {
                    selectMultiple.setQuery((Query)QueryHelper.eq((String)"ArchiveUnitProfile", (String)profile.getIdentifier()));
                    JsonNode jsonNode = this.metaDataClient.selectUnits((JsonNode)selectMultiple.getFinalSelect());
                    if (jsonNode != null && jsonNode.get("$results").size() > 0) {
                        return Optional.of(ArchiveUnitProfileValidator.RejectionCause.rejectJsonSchemaModificationIfInUse(profile.getName()));
                    }
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    return Optional.of(ArchiveUnitProfileValidator.RejectionCause.rejectJsonSchemaModificationIfInUse(profile.getName()));
                }
            }
            return Optional.empty();
        };
    }
}

