/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.server;

import fr.gouv.vitam.common.database.server.DocumentValidator;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.json.JsonSchemaValidationException;
import fr.gouv.vitam.common.json.JsonSchemaValidator;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;

public final class ReferentialDocumentValidators {
    public static final String ACCESS_CONTRACT_SCHEMA_JSON = "/json-schema/access-contract-schema.json";
    public static final String ACCESSION_REGISTER_DETAIL_SCHEMA_JSON = "/json-schema/accession-register-detail-schema.json";
    public static final String ACCESSION_REGISTER_SUMMARY_SCHEMA_JSON = "/json-schema/accession-register-summary-schema.json";
    public static final String ACCESSION_REGISTER_SYMBOLIC_SCHEMA_JSON = "/json-schema/accession-register-symbolic-schema.json";
    public static final String AGENCIES_SCHEMA_JSON = "/json-schema/agencies-schema.json";
    public static final String ARCHIVE_UNIT_PROFILE_SCHEMA_JSON = "/json-schema/archive-unit-profile-schema.json";
    public static final String CONTEXT_SCHEMA_JSON = "/json-schema/context-schema.json";
    public static final String FILE_FORMAT_SCHEMA_JSON = "/json-schema/file-format-schema.json";
    public static final String FILE_RULES_SCHEMA_JSON = "/json-schema/file-rules-schema.json";
    public static final String INGEST_CONTRACT_SCHEMA_JSON = "/json-schema/ingest-contract-schema.json";
    public static final String MANAGEMENT_CONTRACT_SCHEMA_JSON = "/json-schema/management-contract-schema.json";
    public static final String PROFILE_SCHEMA_JSON = "/json-schema/profile-schema.json";
    public static final String SECURITY_PROFILE_SCHEMA_JSON = "/json-schema/security-profile-schema.json";
    public static final String ONTOLOGY_SCHEMA_JSON = "/json-schema/ontology-schema.json";
    public static final String GRIFFIN_SCHEMA_JSON = "/json-schema/griffin-schema-schema.json";
    public static final String PRESERVATION_SCENARIO_SCHEMA_JSON = "/json-schema/preservation-scenario-schema.json";
    public static final String SCHEMA_SCHEMA_JSON = "/json-schema/schema-schema.json";
    private static final DocumentValidator ACCESS_CONTRACT_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/access-contract-schema.json");
    private static final DocumentValidator ACCESSION_REGISTER_DETAIL_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/accession-register-detail-schema.json");
    private static final DocumentValidator ACCESSION_REGISTER_SUMMARY_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/accession-register-summary-schema.json");
    private static final DocumentValidator ACCESSION_REGISTER_SYMBOLIC_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/accession-register-symbolic-schema.json");
    private static final DocumentValidator AGENCIES_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/agencies-schema.json");
    private static final DocumentValidator ARCHIVE_UNIT_PROFILE_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/archive-unit-profile-schema.json");
    private static final DocumentValidator CONTEXT_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/context-schema.json");
    private static final DocumentValidator FILE_FORMAT_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/file-format-schema.json");
    private static final DocumentValidator FILE_RULES_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/file-rules-schema.json");
    private static final DocumentValidator INGEST_CONTRACT_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/ingest-contract-schema.json");
    private static final DocumentValidator MANAGEMENT_CONTRACT_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/management-contract-schema.json");
    private static final DocumentValidator PROFILE_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/profile-schema.json");
    private static final DocumentValidator SECURITY_PROFILE_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/security-profile-schema.json");
    private static final DocumentValidator ONTOLOGY_SCHEMA_VALIDATOR = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/ontology-schema.json");
    private static final DocumentValidator GRIFFIN_SCHEMA = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/griffin-schema-schema.json");
    private static final DocumentValidator PRESERVATION_SCENARIO_SCHEMA = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/preservation-scenario-schema.json");
    private static final DocumentValidator SCHEMA_SCHEMA = ReferentialDocumentValidators.forBuiltInSchema("/json-schema/schema-schema.json");
    private static final DocumentValidator NULL_SCHEMA_VALIDATOR = jsonNode -> {};

    private static DocumentValidator forBuiltInSchema(String schemaFilename) {
        JsonSchemaValidator schemaValidator = JsonSchemaValidator.forBuiltInSchema((String)schemaFilename);
        return jsonNode -> {
            try {
                schemaValidator.validateJson(jsonNode);
            }
            catch (JsonSchemaValidationException e) {
                throw new SchemaValidationException((Throwable)e);
            }
        };
    }

    public static DocumentValidator getValidator(FunctionalAdminCollections collection) {
        switch (collection) {
            case RULES: {
                return FILE_RULES_SCHEMA_VALIDATOR;
            }
            case INGEST_CONTRACT: {
                return INGEST_CONTRACT_SCHEMA_VALIDATOR;
            }
            case MANAGEMENT_CONTRACT: {
                return MANAGEMENT_CONTRACT_SCHEMA_VALIDATOR;
            }
            case ACCESS_CONTRACT: {
                return ACCESS_CONTRACT_SCHEMA_VALIDATOR;
            }
            case PROFILE: {
                return PROFILE_SCHEMA_VALIDATOR;
            }
            case ARCHIVE_UNIT_PROFILE: {
                return ARCHIVE_UNIT_PROFILE_SCHEMA_VALIDATOR;
            }
            case AGENCIES: {
                return AGENCIES_SCHEMA_VALIDATOR;
            }
            case CONTEXT: {
                return CONTEXT_SCHEMA_VALIDATOR;
            }
            case SECURITY_PROFILE: {
                return SECURITY_PROFILE_SCHEMA_VALIDATOR;
            }
            case GRIFFIN: {
                return GRIFFIN_SCHEMA;
            }
            case PRESERVATION_SCENARIO: {
                return PRESERVATION_SCENARIO_SCHEMA;
            }
            case ONTOLOGY: {
                return ONTOLOGY_SCHEMA_VALIDATOR;
            }
            case FORMATS: {
                return FILE_FORMAT_SCHEMA_VALIDATOR;
            }
            case ACCESSION_REGISTER_SUMMARY: {
                return ACCESSION_REGISTER_SUMMARY_SCHEMA_VALIDATOR;
            }
            case ACCESSION_REGISTER_DETAIL: {
                return ACCESSION_REGISTER_DETAIL_SCHEMA_VALIDATOR;
            }
            case ACCESSION_REGISTER_SYMBOLIC: {
                return ACCESSION_REGISTER_SYMBOLIC_SCHEMA_VALIDATOR;
            }
            case SCHEMA: {
                return SCHEMA_SCHEMA;
            }
            case VITAM_SEQUENCE: {
                return NULL_SCHEMA_VALIDATOR;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)collection));
    }
}

