/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.server;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import fr.gouv.vitam.common.database.collections.VitamCollection;
import fr.gouv.vitam.common.database.collections.VitamCollectionHelper;
import fr.gouv.vitam.common.database.collections.VitamDescriptionLoader;
import fr.gouv.vitam.common.database.collections.VitamDescriptionResolver;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchAccess;
import fr.gouv.vitam.common.database.server.elasticsearch.model.ElasticsearchCollections;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.functional.administration.common.AccessContract;
import fr.gouv.vitam.functional.administration.common.AccessionRegisterDetail;
import fr.gouv.vitam.functional.administration.common.AccessionRegisterSummary;
import fr.gouv.vitam.functional.administration.common.Agencies;
import fr.gouv.vitam.functional.administration.common.ArchiveUnitProfile;
import fr.gouv.vitam.functional.administration.common.Context;
import fr.gouv.vitam.functional.administration.common.FileFormat;
import fr.gouv.vitam.functional.administration.common.FileRules;
import fr.gouv.vitam.functional.administration.common.Griffin;
import fr.gouv.vitam.functional.administration.common.IngestContract;
import fr.gouv.vitam.functional.administration.common.ManagementContract;
import fr.gouv.vitam.functional.administration.common.Ontology;
import fr.gouv.vitam.functional.administration.common.PreservationScenario;
import fr.gouv.vitam.functional.administration.common.Profile;
import fr.gouv.vitam.functional.administration.common.SecurityProfile;
import fr.gouv.vitam.functional.administration.common.VitamSequence;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.schema.Schema;
import fr.gouv.vitam.functional.administration.common.server.AccessionRegisterSymbolic;
import fr.gouv.vitam.functional.administration.common.server.ElasticsearchAccessFunctionalAdmin;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

public enum FunctionalAdminCollections {
    FORMATS(FileFormat.class, false, false),
    RULES(FileRules.class, true, true),
    ACCESSION_REGISTER_SUMMARY(AccessionRegisterSummary.class, true, false),
    ACCESSION_REGISTER_DETAIL(AccessionRegisterDetail.class, true, false),
    ACCESSION_REGISTER_SYMBOLIC(AccessionRegisterSymbolic.class, true, false),
    INGEST_CONTRACT(IngestContract.class, true, true),
    ACCESS_CONTRACT(AccessContract.class, true, true),
    MANAGEMENT_CONTRACT(ManagementContract.class, true, true),
    VITAM_SEQUENCE(VitamSequence.class, false, false),
    PROFILE(Profile.class, true, false),
    ARCHIVE_UNIT_PROFILE(ArchiveUnitProfile.class, true, false),
    AGENCIES(Agencies.class, true, false),
    CONTEXT(Context.class, false, false),
    SECURITY_PROFILE(SecurityProfile.class, false, false),
    GRIFFIN(Griffin.class, false, false),
    PRESERVATION_SCENARIO(PreservationScenario.class, true, false),
    ONTOLOGY(Ontology.class, false, false),
    SCHEMA(Schema.class, true, false);

    private final VitamDescriptionResolver vitamDescriptionResolver;
    private final VitamCollection<? extends VitamDocument<?>> vitamCollection;
    private final boolean multitenant;

    private FunctionalAdminCollections(Class<? extends VitamDocument<?>> clasz, boolean multiTenant, boolean usingScore) {
        this.multitenant = multiTenant;
        VitamDescriptionLoader vitamDescriptionLoader = new VitamDescriptionLoader(clasz.getSimpleName());
        this.vitamDescriptionResolver = vitamDescriptionLoader.getVitamDescriptionResolver();
        this.vitamCollection = VitamCollectionHelper.getCollection(clasz, (boolean)multiTenant, (boolean)usingScore, (String)"", (VitamDescriptionResolver)this.vitamDescriptionResolver);
    }

    public static List<Class<?>> getClasses() {
        ArrayList classes = new ArrayList();
        for (FunctionalAdminCollections collection : FunctionalAdminCollections.values()) {
            classes.add(collection.getClasz());
        }
        return classes;
    }

    public boolean isMultitenant() {
        return this.multitenant;
    }

    void initialize(MongoDatabase db, boolean recreate) {
        this.vitamCollection.initialize(db, recreate);
    }

    void initialize(ElasticsearchAccessFunctionalAdmin esClient) {
        this.vitamCollection.initialize((ElasticsearchAccess)esClient);
        try {
            esClient.addIndex(this);
        }
        catch (ReferentialException e) {
            throw new RuntimeException("Index not created for the collection " + this.getName(), (Throwable)((Object)e));
        }
    }

    public String getName() {
        return this.vitamCollection.getName();
    }

    public <T extends Document> MongoCollection<T> getCollection() {
        return this.vitamCollection.getCollection();
    }

    public <T extends VitamDocument<?>> VitamCollection<T> getVitamCollection() {
        return this.vitamCollection;
    }

    Class<? extends VitamDocument<?>> getClasz() {
        return this.vitamCollection.getClasz();
    }

    public long getCount() {
        return this.vitamCollection.getCollection().countDocuments();
    }

    public VarNameAdapter getVarNameAdapater() {
        return new SingleVarNameAdapter();
    }

    public ElasticsearchAccessFunctionalAdmin getEsClient() {
        return (ElasticsearchAccessFunctionalAdmin)this.vitamCollection.getEsClient();
    }

    public static FunctionalAdminCollections getFromValue(String collection) {
        for (FunctionalAdminCollections coll : FunctionalAdminCollections.values()) {
            if (!coll.name().equalsIgnoreCase(collection)) continue;
            return coll;
        }
        return null;
    }

    public VitamDescriptionResolver getVitamDescriptionResolver() {
        return this.vitamDescriptionResolver;
    }

    public ElasticsearchCollections getElasticsearchCollection() {
        switch (this.ordinal()) {
            case 2: {
                return ElasticsearchCollections.ACCESSION_REGISTER_SUMMARY;
            }
            case 3: {
                return ElasticsearchCollections.ACCESSION_REGISTER_DETAIL;
            }
            case 10: {
                return ElasticsearchCollections.ARCHIVE_UNIT_PROFILE;
            }
            case 16: {
                return ElasticsearchCollections.ONTOLOGY;
            }
            case 4: {
                return ElasticsearchCollections.ACCESSION_REGISTER_SYMBOLIC;
            }
            case 0: {
                return ElasticsearchCollections.FORMATS;
            }
            case 1: {
                return ElasticsearchCollections.RULES;
            }
            case 5: {
                return ElasticsearchCollections.INGEST_CONTRACT;
            }
            case 7: {
                return ElasticsearchCollections.MANAGEMENT_CONTRACT;
            }
            case 6: {
                return ElasticsearchCollections.ACCESS_CONTRACT;
            }
            case 9: {
                return ElasticsearchCollections.PROFILE;
            }
            case 12: {
                return ElasticsearchCollections.CONTEXT;
            }
            case 11: {
                return ElasticsearchCollections.AGENCIES;
            }
            case 13: {
                return ElasticsearchCollections.SECURITY_PROFILE;
            }
            case 14: {
                return ElasticsearchCollections.GRIFFIN;
            }
            case 15: {
                return ElasticsearchCollections.PRESERVATION_SCENARIO;
            }
            case 17: {
                return ElasticsearchCollections.SCHEMA;
            }
            case 8: {
                throw new IllegalStateException("No ES index for collection " + String.valueOf((Object)this));
            }
        }
        throw new IllegalStateException("Unknown collection " + String.valueOf((Object)this));
    }
}

