/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.server;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.IndexOptions;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchAccess;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchNode;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import java.util.List;
import org.bson.conversions.Bson;

public class ElasticsearchAccessFunctionalAdmin
extends ElasticsearchAccess {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ElasticsearchAccessFunctionalAdmin.class);
    private final ElasticsearchFunctionalAdminIndexManager indexManager;
    private static final BasicDBObject[] accessionRegisterSummaryIndexes = new BasicDBObject[]{new BasicDBObject("OriginatingAgency", (Object)1).append("_tenant", (Object)1)};
    private static final BasicDBObject[] accessionRegisterDetailIndexes = new BasicDBObject[]{new BasicDBObject("OriginatingAgency", (Object)1).append("Opi", (Object)1).append("_tenant", (Object)1)};

    public ElasticsearchAccessFunctionalAdmin(String clusterName, List<ElasticsearchNode> nodes, ElasticsearchFunctionalAdminIndexManager indexManager) throws VitamException {
        super(clusterName, nodes);
        this.indexManager = indexManager;
    }

    public final void addIndex(FunctionalAdminCollections collection) throws ReferentialException {
        try {
            super.createIndexAndAliasIfAliasNotExists(this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(null), this.indexManager.getElasticsearchIndexSettings(collection), this.indexManager.getElasticSearchConfigurationFile());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new ReferentialException(e);
        }
    }

    protected final ResponseBody<ObjectNode> search(FunctionalAdminCollections collection, Query query) throws ReferentialException, BadRequestException {
        try {
            return super.search(this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(null), query, VitamDocument.ES_FILTER_OUT, null, 0, Integer.valueOf(10000), null, null, null, false);
        }
        catch (DatabaseException e) {
            throw new ReferentialException(e);
        }
    }

    public static void ensureIndex() {
        FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY.getCollection().dropIndexes();
        for (BasicDBObject index : accessionRegisterSummaryIndexes) {
            FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY.getCollection().createIndex((Bson)index, new IndexOptions().unique(true));
        }
        FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL.getCollection().dropIndexes();
        for (BasicDBObject index : accessionRegisterDetailIndexes) {
            FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL.getCollection().createIndex((Bson)index, new IndexOptions().unique(true));
        }
    }
}

