/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.counter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Sorts;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.VitamSequence;
import fr.gouv.vitam.functional.administration.common.counter.SequenceType;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bson.conversions.Bson;

public class VitamCounterService {
    private static final String ARGUMENT_MUST_NOT_BE_NULL = "Argument must not be null";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamCounterService.class);
    private final MongoDbAccessAdminImpl mongoAccess;
    private final Set<Integer> tenants;
    private final Map<SequenceType, FunctionalAdminCollections> collections = new HashMap<SequenceType, FunctionalAdminCollections>();
    private final Map<Integer, List<FunctionalAdminCollections>> externalIdentifiers;

    public VitamCounterService(MongoDbAccessAdminImpl dbConfiguration, List<Integer> tenants, Map<Integer, List<String>> externalIdentifiers) throws VitamException {
        ParametersChecker.checkParameter((String)ARGUMENT_MUST_NOT_BE_NULL, (Object[])new Object[]{tenants});
        ArrayList<SequenceType> sequences = new ArrayList<SequenceType>();
        this.externalIdentifiers = new HashMap<Integer, List<FunctionalAdminCollections>>();
        this.mongoAccess = dbConfiguration;
        Collections.addAll(sequences, SequenceType.values());
        sequences.forEach(i -> this.collections.put((SequenceType)((Object)i), i.getCollection()));
        this.tenants = new HashSet<Integer>(tenants);
        this.initSequences();
        this.initExternalIds(externalIdentifiers);
    }

    private void initExternalIds(Map<Integer, List<String>> externalIdentifiers) {
        if (externalIdentifiers != null) {
            for (Map.Entry<Integer, List<String>> identifiers : externalIdentifiers.entrySet()) {
                ArrayList<FunctionalAdminCollections> functionalAdminCollections = new ArrayList<FunctionalAdminCollections>();
                for (String collection : identifiers.getValue()) {
                    functionalAdminCollections.add(FunctionalAdminCollections.valueOf(collection));
                }
                this.externalIdentifiers.put(identifiers.getKey(), functionalAdminCollections);
            }
        }
    }

    private void initSequences() throws VitamException {
        try {
            for (Integer tenantId : this.tenants) {
                this.runInVitamThread(() -> {
                    VitamThreadUtils.getVitamSession().setTenantId(tenantId);
                    try {
                        for (Map.Entry<SequenceType, FunctionalAdminCollections> entry : this.collections.entrySet()) {
                            SequenceType sequenceType = entry.getKey();
                            if (!this.canCreateSequenceForTenant(tenantId, sequenceType)) continue;
                            this.createSequenceIfNotExists(tenantId, sequenceType.getName());
                            this.createSequenceIfNotExists(tenantId, sequenceType.getBackupSequenceName());
                        }
                    }
                    catch (InvalidCreateOperationException | VitamException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new VitamException((Throwable)e);
        }
    }

    private boolean canCreateSequenceForTenant(Integer tenantId, SequenceType sequenceType) {
        if (sequenceType.getCollection().isMultitenant()) {
            return true;
        }
        return Objects.equals(tenantId, VitamConfiguration.getAdminTenant());
    }

    private void createSequenceIfNotExists(Integer tenantId, String sequenceName) throws InvalidCreateOperationException, VitamException {
        JsonNode query = this.generateQuery(tenantId, sequenceName);
        try (DbRequestResult result = this.mongoAccess.findDocuments(query, FunctionalAdminCollections.VITAM_SEQUENCE);){
            if (!result.hasResult()) {
                this.createSequence(tenantId, sequenceName);
            }
        }
    }

    private JsonNode generateQuery(Integer tenantId, String sequenceName) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new SingleVarNameAdapter());
        parser.parse((JsonNode)new Select().getFinalSelect());
        parser.addCondition((Query)QueryHelper.eq((String)"Name", (String)sequenceName));
        parser.addCondition((Query)QueryHelper.eq((String)VitamFieldsHelper.tenant(), (long)tenantId.intValue()));
        return parser.getRequest().getFinalSelect();
    }

    private void createSequence(Integer tenant, String sequenceNAme) throws VitamException {
        ObjectNode node = JsonHandler.createObjectNode();
        node.put("Name", sequenceNAme);
        node.put("Counter", 0);
        node.put("_tenant", tenant);
        JsonNode firstSequence = JsonHandler.getFromString((String)node.toString());
        this.mongoAccess.insertDocument(firstSequence, FunctionalAdminCollections.VITAM_SEQUENCE).close();
    }

    public String getNextSequenceAsString(Integer tenant, SequenceType sequenceType) throws ReferentialException {
        Integer sequence = this.getNextSequence(tenant, sequenceType);
        return sequenceType.getName() + "-" + String.format("%06d", sequence);
    }

    public Integer getNextSequence(Integer tenant, SequenceType sequenceType) throws ReferentialException {
        return this.getNextSequenceDocument(tenant, sequenceType, sequenceType.getName()).getCounter();
    }

    public VitamSequence getNextBackupSequenceDocument(Integer tenant, SequenceType sequenceType) throws ReferentialException {
        return this.getNextSequenceDocument(tenant, sequenceType, sequenceType.getBackupSequenceName());
    }

    private VitamSequence getNextSequenceDocument(Integer tenant, SequenceType sequenceType, String name) throws ReferentialException {
        BasicDBObject incQuery = new BasicDBObject();
        incQuery.append("$inc", (Object)new BasicDBObject("Counter", (Object)1));
        Bson query = sequenceType.getCollection().isMultitenant() ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"Name", (Object)name), Filters.eq((String)"_tenant", (Object)tenant)}) : Filters.eq((String)"Name", (Object)name);
        FindOneAndUpdateOptions findOneAndUpdateOptions = new FindOneAndUpdateOptions();
        findOneAndUpdateOptions.returnDocument(ReturnDocument.AFTER);
        try {
            Object result = FunctionalAdminCollections.VITAM_SEQUENCE.getCollection().findOneAndUpdate(query, (Bson)incQuery, findOneAndUpdateOptions);
            if (result == null) {
                throw new ReferentialException(String.format("Not sequence for tenant= %d and sequence= %s", tenant, name));
            }
            return (VitamSequence)((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("find Document Exception", (Throwable)e);
            throw new ReferentialException(e);
        }
    }

    private void runInVitamThread(Runnable r) {
        Thread thread = VitamThreadFactory.getInstance().newThread(r);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getSequence(Integer tenant, SequenceType sequenceType) throws ReferentialException {
        return this.getSequenceDocument(tenant, sequenceType).getCounter();
    }

    public VitamSequence getSequenceDocument(Integer tenant, SequenceType sequenceType) throws ReferentialException {
        Bson query = sequenceType.getCollection().isMultitenant() ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"Name", (Object)sequenceType.getName()), Filters.eq((String)"_tenant", (Object)tenant)}) : Filters.eq((String)"Name", (Object)sequenceType.getName());
        try {
            Collection result = FunctionalAdminCollections.VITAM_SEQUENCE.getCollection().find(query).sort(Sorts.descending((String[])new String[]{"Counter"})).limit(1).into(new ArrayList());
            if (result.isEmpty()) {
                throw new ReferentialException("Document not found collection : " + FunctionalAdminCollections.VITAM_SEQUENCE.getName() + " sequence: " + sequenceType.getName());
            }
            return (VitamSequence)((Object)result.iterator().next());
        }
        catch (Exception e) {
            if (e instanceof ReferentialException) {
                throw e;
            }
            LOGGER.error("find Document Exception: ", (Throwable)e);
            throw new ReferentialException(e);
        }
    }

    public boolean isSlaveFunctionnalCollectionOnTenant(FunctionalAdminCollections collection, Integer tenant) {
        return this.externalIdentifiers.containsKey(tenant) && this.externalIdentifiers.get(tenant).contains((Object)collection);
    }
}

