/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.counter;

import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import java.util.Arrays;

public enum SequenceType {
    AGENCIES_SEQUENCE(FunctionalAdminCollections.AGENCIES, "AG"),
    RULES_SEQUENCE(FunctionalAdminCollections.RULES, "RULE"),
    INGEST_CONTRACT_SEQUENCE(FunctionalAdminCollections.INGEST_CONTRACT, "IC"),
    ACCESS_CONTRACT_SEQUENCE(FunctionalAdminCollections.ACCESS_CONTRACT, "AC"),
    MANAGEMENT_CONTRACT_SEQUENCE(FunctionalAdminCollections.MANAGEMENT_CONTRACT, "MC"),
    PROFILE_SEQUENCE(FunctionalAdminCollections.PROFILE, "PR"),
    ARCHIVE_UNIT_PROFILE_SEQUENCE(FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE, "AUP"),
    ONTOLOGY_SEQUENCE(FunctionalAdminCollections.ONTOLOGY, "ON"),
    CONTEXT_SEQUENCE(FunctionalAdminCollections.CONTEXT, "CT"),
    SECURITY_PROFILE_SEQUENCE(FunctionalAdminCollections.SECURITY_PROFILE, "SEC_PROFILE"),
    FORMATS(FunctionalAdminCollections.FORMATS, "FORMATS"),
    ACCESSION_REGISTER_SYMBOLIC(FunctionalAdminCollections.ACCESSION_REGISTER_SYMBOLIC, "REGISTER_SYMBOLIC"),
    GRIFFIN(FunctionalAdminCollections.GRIFFIN, "GR"),
    PRESERVATION_SCENARIO(FunctionalAdminCollections.PRESERVATION_SCENARIO, "PSC"),
    ACCESSION_REGISTER_DETAIL(FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL, "REGISTER_DETAIL"),
    SCHEMA_SEQUENCE(FunctionalAdminCollections.SCHEMA, "SCHEMA");

    public static final String BACK_UP_SEQUENCE_PREFIX = "BACKUP_";
    private String name;
    private FunctionalAdminCollections collection;

    private SequenceType(FunctionalAdminCollections collection, String prefix) {
        this.collection = collection;
        this.name = prefix;
    }

    public String getName() {
        return this.name;
    }

    public String getBackupSequenceName() {
        return BACK_UP_SEQUENCE_PREFIX + this.name;
    }

    public FunctionalAdminCollections getCollection() {
        return this.collection;
    }

    public static SequenceType fromFunctionalAdminCollections(FunctionalAdminCollections functionalAdminCollection) {
        return Arrays.stream(SequenceType.values()).filter(i -> i.getCollection().equals((Object)functionalAdminCollection)).findFirst().orElseThrow(IllegalArgumentException::new);
    }
}

