/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.config;

import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAliasResolver;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexSettings;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchUtil;
import fr.gouv.vitam.common.exception.VitamFatalRuntimeException;
import fr.gouv.vitam.common.model.config.CollectionConfiguration;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.FunctionalAdminIndexationConfiguration;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ElasticsearchFunctionalAdminIndexManager {
    private final Map<FunctionalAdminCollections, ElasticsearchIndexSettings> elasticsearchIndexSettingsMap;
    private final String elasticSearchConfigurationFile;

    public ElasticsearchFunctionalAdminIndexManager(AdminManagementConfiguration configuration) {
        FunctionalAdminIndexationConfiguration indexationConfiguration = configuration.getIndexationConfiguration();
        Map<FunctionalAdminCollections, CollectionConfiguration> collectionConfigurationMap = Arrays.stream(FunctionalAdminCollections.values()).collect(Collectors.toMap(functionalAdminCollection -> functionalAdminCollection, functionalAdminCollection -> new CollectionConfiguration().setNumberOfShards(indexationConfiguration.getCollectionConfiguration((FunctionalAdminCollections)((Object)functionalAdminCollection)) != null && indexationConfiguration.getCollectionConfiguration((FunctionalAdminCollections)((Object)functionalAdminCollection)).getNumberOfShards() != null ? indexationConfiguration.getCollectionConfiguration((FunctionalAdminCollections)((Object)functionalAdminCollection)).getNumberOfShards() : indexationConfiguration.getDefaultConfiguration().getNumberOfShards()).setNumberOfReplicas(indexationConfiguration.getCollectionConfiguration((FunctionalAdminCollections)((Object)functionalAdminCollection)) != null && indexationConfiguration.getCollectionConfiguration((FunctionalAdminCollections)((Object)functionalAdminCollection)).getNumberOfReplicas() != null ? indexationConfiguration.getCollectionConfiguration((FunctionalAdminCollections)((Object)functionalAdminCollection)).getNumberOfReplicas() : indexationConfiguration.getDefaultConfiguration().getNumberOfReplicas())));
        this.elasticsearchIndexSettingsMap = ElasticsearchFunctionalAdminIndexManager.buildElasticsearchIndexSettingsMap(collectionConfigurationMap);
        this.elasticSearchConfigurationFile = configuration.getElasticsearchConfigurationFile();
    }

    private static Map<FunctionalAdminCollections, ElasticsearchIndexSettings> buildElasticsearchIndexSettingsMap(Map<FunctionalAdminCollections, CollectionConfiguration> collectionConfigurationMap) {
        HashMap<FunctionalAdminCollections, ElasticsearchIndexSettings> elasticsearchIndexSettingsMap = new HashMap<FunctionalAdminCollections, ElasticsearchIndexSettings>();
        for (FunctionalAdminCollections functionalAdminCollection : FunctionalAdminCollections.values()) {
            if (functionalAdminCollection == FunctionalAdminCollections.VITAM_SEQUENCE) continue;
            ElasticsearchIndexSettings elasticsearchIndexSettings = new ElasticsearchIndexSettings(collectionConfigurationMap.get((Object)functionalAdminCollection).getNumberOfShards().intValue(), collectionConfigurationMap.get((Object)functionalAdminCollection).getNumberOfReplicas().intValue(), ElasticsearchFunctionalAdminIndexManager.getMappingLoader(functionalAdminCollection));
            elasticsearchIndexSettingsMap.put(functionalAdminCollection, elasticsearchIndexSettings);
        }
        return elasticsearchIndexSettingsMap;
    }

    public ElasticsearchIndexAliasResolver getElasticsearchIndexAliasResolver(FunctionalAdminCollections collection) {
        return tenant -> ElasticsearchIndexAlias.ofCrossTenantCollection((String)collection.getVitamCollection().getName());
    }

    public ElasticsearchIndexSettings getElasticsearchIndexSettings(FunctionalAdminCollections collection) {
        return this.elasticsearchIndexSettingsMap.get((Object)collection);
    }

    public String getElasticSearchConfigurationFile() {
        return this.elasticSearchConfigurationFile;
    }

    private static Supplier<String> getMappingLoader(FunctionalAdminCollections collection) {
        return () -> {
            try {
                return ElasticsearchUtil.transferJsonToMapping((InputStream)collection.getElasticsearchCollection().getMappingAsInputStream());
            }
            catch (IOException e) {
                throw new VitamFatalRuntimeException("Could not load mapping file for collection " + String.valueOf((Object)collection));
            }
        };
    }
}

