/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.config;

import fr.gouv.vitam.common.model.config.TenantRange;
import fr.gouv.vitam.common.model.config.TenantRangeParser;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.CollectionCustomSearchConfiguration;
import fr.gouv.vitam.functional.administration.common.config.CollectionSearchConfiguration;
import fr.gouv.vitam.functional.administration.common.config.CollectionSearchConfigurationUtils;
import fr.gouv.vitam.functional.administration.common.config.DedicatedTenantCustomSearchConfiguration;
import fr.gouv.vitam.functional.administration.common.config.GroupedTenantCustomSearchConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.tuple.Pair;

public class ElasticsearchCustomSearchManager {
    private final ListValuedMap<String, Integer> tenantGroupToTenantMap = new ArrayListValuedHashMap();
    private final Map<Pair<Integer, String>, List<String>> unitCustomSearchsTypesByTenantAndFieldMap = new HashMap<Pair<Integer, String>, List<String>>();
    private final Map<Pair<Integer, String>, List<String>> objectGroupCustomSearchsTypesByTenantAndFieldMap = new HashMap<Pair<Integer, String>, List<String>>();

    public ElasticsearchCustomSearchManager(AdminManagementConfiguration configuration, List<Integer> tenantIds) {
        if (configuration == null || configuration.getCustomSearchOnFieldsConfiguration() == null) {
            return;
        }
        Optional<CollectionCustomSearchConfiguration> defaultUnitConfiguration = this.getDefaultUnitConfiguration(configuration);
        Optional<CollectionCustomSearchConfiguration> defaultObjectGroupConfiguration = this.getDefaultObjectGroupConfiguration(configuration);
        if (defaultUnitConfiguration.isEmpty() && defaultObjectGroupConfiguration.isEmpty()) {
            return;
        }
        this.handleDedicatedTenantsConfigurations(configuration, tenantIds, defaultUnitConfiguration.orElseGet(null), defaultObjectGroupConfiguration.orElseGet(null));
        this.handleTenantsGroupsConfiguration(configuration, tenantIds, defaultUnitConfiguration.orElseGet(null), defaultObjectGroupConfiguration.orElseGet(null));
    }

    private Optional<CollectionCustomSearchConfiguration> getDefaultObjectGroupConfiguration(AdminManagementConfiguration configuration) {
        Optional<CollectionCustomSearchConfiguration> defaultObjectGroupConfigurationOpt = Optional.empty();
        if (configuration.getCustomSearchOnFieldsConfiguration().getDefaultCustomSearchCollectionConfiguration() != null) {
            defaultObjectGroupConfigurationOpt = Optional.of(configuration.getCustomSearchOnFieldsConfiguration().getDefaultCustomSearchCollectionConfiguration().getObjectgroupFields());
        }
        return defaultObjectGroupConfigurationOpt;
    }

    private Optional<CollectionCustomSearchConfiguration> getDefaultUnitConfiguration(AdminManagementConfiguration configuration) {
        Optional<CollectionCustomSearchConfiguration> defaultUnitConfigurationOpt = Optional.empty();
        if (configuration.getCustomSearchOnFieldsConfiguration().getDefaultCustomSearchCollectionConfiguration() != null) {
            defaultUnitConfigurationOpt = Optional.of(configuration.getCustomSearchOnFieldsConfiguration().getDefaultCustomSearchCollectionConfiguration().getUnitFields());
        }
        return defaultUnitConfigurationOpt;
    }

    private void handleTenantsGroupsConfiguration(AdminManagementConfiguration configuration, List<Integer> tenantIds, CollectionCustomSearchConfiguration defaultUnitConfiguration, CollectionCustomSearchConfiguration defaultObjectGroupConfiguration) {
        HashMap<String, CollectionCustomSearchConfiguration> groupedTenantUnitConfiguration = new HashMap<String, CollectionCustomSearchConfiguration>();
        HashMap<String, CollectionCustomSearchConfiguration> groupedTenantObjectGroupConfiguration = new HashMap<String, CollectionCustomSearchConfiguration>();
        if (CollectionUtils.isNotEmpty(configuration.getCustomSearchOnFieldsConfiguration().getGroupedTenantConfiguration())) {
            for (GroupedTenantCustomSearchConfiguration groupedTenantConfiguration : configuration.getCustomSearchOnFieldsConfiguration().getGroupedTenantConfiguration()) {
                List tenantRanges = TenantRangeParser.parseTenantRanges((String)groupedTenantConfiguration.getTenants());
                CollectionCustomSearchConfiguration unitConfiguration = CollectionSearchConfigurationUtils.merge(groupedTenantConfiguration.getUnitFields(), defaultUnitConfiguration);
                groupedTenantUnitConfiguration.put(groupedTenantConfiguration.getName(), unitConfiguration);
                CollectionCustomSearchConfiguration objectGroupConfiguration = CollectionSearchConfigurationUtils.merge(groupedTenantConfiguration.getObjectgroupFields(), defaultObjectGroupConfiguration);
                groupedTenantObjectGroupConfiguration.put(groupedTenantConfiguration.getName(), objectGroupConfiguration);
                for (TenantRange tenantRange : tenantRanges) {
                    for (int tenantId : tenantIds) {
                        if (!tenantRange.isInRange(tenantId)) continue;
                        this.tenantGroupToTenantMap.get((Object)groupedTenantConfiguration.getName()).add(tenantId);
                    }
                }
            }
        }
        this.tenantGroupToTenantMap.keySet().forEach(tenantGroupName -> {
            CollectionCustomSearchConfiguration unitConfiguration = (CollectionCustomSearchConfiguration)groupedTenantUnitConfiguration.get(tenantGroupName);
            CollectionCustomSearchConfiguration objectGroupConfiguration = (CollectionCustomSearchConfiguration)groupedTenantObjectGroupConfiguration.get(tenantGroupName);
            for (Integer tenantId : this.tenantGroupToTenantMap.get(tenantGroupName)) {
                if (CollectionUtils.isNotEmpty(unitConfiguration.getCollectionSearchConfigurations())) {
                    for (CollectionSearchConfiguration customSearchConfiguration : unitConfiguration.getCollectionSearchConfigurations()) {
                        this.unitCustomSearchsTypesByTenantAndFieldMap.put((Pair<Integer, String>)Pair.of((Object)tenantId, (Object)customSearchConfiguration.getFieldPath()), customSearchConfiguration.getTypes());
                    }
                }
                if (!CollectionUtils.isNotEmpty(objectGroupConfiguration.getCollectionSearchConfigurations())) continue;
                for (CollectionSearchConfiguration customSearchConfiguration : objectGroupConfiguration.getCollectionSearchConfigurations()) {
                    this.objectGroupCustomSearchsTypesByTenantAndFieldMap.put((Pair<Integer, String>)Pair.of((Object)tenantId, (Object)customSearchConfiguration.getFieldPath()), customSearchConfiguration.getTypes());
                }
            }
        });
    }

    private void handleDedicatedTenantsConfigurations(AdminManagementConfiguration configuration, List<Integer> tenantIds, CollectionCustomSearchConfiguration defaultUnitConfiguration, CollectionCustomSearchConfiguration defaultObjectGroupConfiguration) {
        HashMap<Integer, CollectionCustomSearchConfiguration> customTenantUnitConfiguration = new HashMap<Integer, CollectionCustomSearchConfiguration>();
        HashMap<Integer, CollectionCustomSearchConfiguration> customTenantObjectGroupConfiguration = new HashMap<Integer, CollectionCustomSearchConfiguration>();
        if (CollectionUtils.isNotEmpty(configuration.getCustomSearchOnFieldsConfiguration().getDedicatedTenantCustomSearchConfiguration())) {
            for (DedicatedTenantCustomSearchConfiguration dedicatedTenantConfiguration : configuration.getCustomSearchOnFieldsConfiguration().getDedicatedTenantCustomSearchConfiguration()) {
                List tenantRanges = TenantRangeParser.parseTenantRanges((String)dedicatedTenantConfiguration.getTenants());
                CollectionCustomSearchConfiguration unitConfiguration = CollectionSearchConfigurationUtils.merge(dedicatedTenantConfiguration.getUnitFields(), defaultUnitConfiguration);
                CollectionCustomSearchConfiguration objectGroupConfiguration = CollectionSearchConfigurationUtils.merge(dedicatedTenantConfiguration.getObjectgroupFields(), defaultObjectGroupConfiguration);
                for (TenantRange tenantRange : tenantRanges) {
                    for (int tenantId2 : tenantIds) {
                        if (!tenantRange.isInRange(tenantId2)) continue;
                        customTenantUnitConfiguration.put(tenantId2, unitConfiguration);
                        customTenantObjectGroupConfiguration.put(tenantId2, objectGroupConfiguration);
                    }
                }
            }
        }
        tenantIds.stream().forEach(tenantId -> {
            CollectionCustomSearchConfiguration objectGroupConfiguration;
            CollectionCustomSearchConfiguration unitConfiguration = customTenantUnitConfiguration.getOrDefault(tenantId, defaultUnitConfiguration);
            if (CollectionUtils.isNotEmpty(unitConfiguration.getCollectionSearchConfigurations())) {
                for (CollectionSearchConfiguration customSearchConfiguration : unitConfiguration.getCollectionSearchConfigurations()) {
                    this.unitCustomSearchsTypesByTenantAndFieldMap.put((Pair<Integer, String>)Pair.of((Object)tenantId, (Object)customSearchConfiguration.getFieldPath()), customSearchConfiguration.getTypes());
                }
            }
            if (CollectionUtils.isNotEmpty((objectGroupConfiguration = customTenantObjectGroupConfiguration.getOrDefault(tenantId, defaultObjectGroupConfiguration)).getCollectionSearchConfigurations())) {
                for (CollectionSearchConfiguration customSearchConfiguration : objectGroupConfiguration.getCollectionSearchConfigurations()) {
                    this.objectGroupCustomSearchsTypesByTenantAndFieldMap.put((Pair<Integer, String>)Pair.of((Object)tenantId, (Object)customSearchConfiguration.getFieldPath()), customSearchConfiguration.getTypes());
                }
            }
        });
    }

    public List<String> getCustomSearchTypes(String collection, int tenantId, String path) {
        switch (collection) {
            case "Unit": {
                return this.unitCustomSearchsTypesByTenantAndFieldMap.get(Pair.of((Object)tenantId, (Object)path));
            }
            case "ObjectGroup": {
                return this.objectGroupCustomSearchsTypesByTenantAndFieldMap.get(Pair.of((Object)tenantId, (Object)path));
            }
        }
        throw new IllegalStateException("Unknown collection " + collection);
    }
}

