/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.config;

import fr.gouv.vitam.functional.administration.common.config.CollectionCustomSearchConfiguration;
import fr.gouv.vitam.functional.administration.common.config.CollectionSearchConfiguration;
import org.apache.commons.collections4.CollectionUtils;

public final class CollectionSearchConfigurationUtils {
    private CollectionSearchConfigurationUtils() {
    }

    public static void validate(CollectionCustomSearchConfiguration collectionCustomSearchConfiguration, boolean allowNulls) throws IllegalStateException {
        if (collectionCustomSearchConfiguration == null) {
            return;
        }
        if (!allowNulls && CollectionUtils.isEmpty(collectionCustomSearchConfiguration.getCollectionSearchConfigurations())) {
            throw new IllegalStateException("Invalid configuration. Missing fields ");
        }
        if (CollectionUtils.isNotEmpty(collectionCustomSearchConfiguration.getCollectionSearchConfigurations())) {
            collectionCustomSearchConfiguration.getCollectionSearchConfigurations().forEach(fieldConf -> CollectionSearchConfigurationUtils.validate(fieldConf, true));
        }
    }

    public static void validate(CollectionSearchConfiguration searchConfiguration, boolean allowNulls) throws IllegalStateException {
        if (!allowNulls && (searchConfiguration.getFieldPath() == null || CollectionUtils.isEmpty(searchConfiguration.getTypes()))) {
            throw new IllegalStateException("Invalid configuration. Missing fieldPath or Search Types ");
        }
    }

    public static CollectionCustomSearchConfiguration merge(CollectionCustomSearchConfiguration customConfig, CollectionCustomSearchConfiguration defaultConfig) {
        if (customConfig == null || customConfig.getCollectionSearchConfigurations() == null || CollectionUtils.isEmpty(customConfig.getCollectionSearchConfigurations())) {
            return defaultConfig;
        }
        return customConfig;
    }
}

