/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.config;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.config.CollectionConfiguration;
import fr.gouv.vitam.common.model.config.CollectionConfigurationUtils;
import fr.gouv.vitam.common.model.config.DedicatedVirtualPathsTenantConfiguration;
import fr.gouv.vitam.common.model.config.TenantRangeValidator;
import fr.gouv.vitam.common.model.config.VirtualPathsConfiguration;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.CollectionSearchConfigurationUtils;
import fr.gouv.vitam.functional.administration.common.config.CustomSearchOnFieldsConfiguration;
import fr.gouv.vitam.functional.administration.common.config.FunctionalAdminIndexationConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AdminManagementConfigurationValidator {
    public static void validateConfiguration(AdminManagementConfiguration adminManagementConfiguration) {
        if (adminManagementConfiguration == null) {
            throw new IllegalStateException("Invalid configuration. Null config");
        }
        AdminManagementConfigurationValidator.validateIndexationConfiguration(adminManagementConfiguration.getIndexationConfiguration());
        try {
            AdminManagementConfigurationValidator.validateElasticsearchSettings(adminManagementConfiguration.getElasticsearchConfigurationFile());
        }
        catch (InvalidParseOperationException | IOException e) {
            throw new IllegalStateException("Invalid configuration.");
        }
        AdminManagementConfigurationValidator.validateCustomSearchOnFieldsConfiguration(adminManagementConfiguration.getCustomSearchOnFieldsConfiguration());
        AdminManagementConfigurationValidator.validateVirtualPathsConfiguration(adminManagementConfiguration.getVirtualPathsConfiguration());
    }

    private static void validateElasticsearchSettings(String elasticsearchConfigurationFilePath) throws IOException, InvalidParseOperationException {
        if (elasticsearchConfigurationFilePath == null) {
            throw new IllegalStateException("Invalid path of elasticsearch Configuration File. Null config");
        }
        File elasticsearchConfigurationFile = new File(elasticsearchConfigurationFilePath);
        SanityChecker.checkJsonFile((File)elasticsearchConfigurationFile);
        if (!elasticsearchConfigurationFile.exists() || !elasticsearchConfigurationFile.isFile()) {
            throw new IllegalStateException("Not found elasticsearch Configuration File in the provided path");
        }
    }

    private static void validateIndexationConfiguration(FunctionalAdminIndexationConfiguration indexationConfiguration) {
        CollectionConfigurationUtils.validate((CollectionConfiguration)indexationConfiguration.getDefaultConfiguration(), (boolean)false);
        for (CollectionConfiguration collectionConfiguration : indexationConfiguration.getCollectionConfigurationMap().values()) {
            CollectionConfigurationUtils.validate((CollectionConfiguration)collectionConfiguration, (boolean)true);
        }
    }

    private static void validateCustomSearchOnFieldsConfiguration(CustomSearchOnFieldsConfiguration customSearchOnFieldsConfiguration) {
        if (customSearchOnFieldsConfiguration == null) {
            return;
        }
        if (customSearchOnFieldsConfiguration.getDefaultCustomSearchCollectionConfiguration() == null) {
            throw new IllegalStateException("Invalid configuration. Missing default configuration");
        }
        if (customSearchOnFieldsConfiguration.getDefaultCustomSearchCollectionConfiguration() != null) {
            CollectionSearchConfigurationUtils.validate(customSearchOnFieldsConfiguration.getDefaultCustomSearchCollectionConfiguration().getUnitFields(), false);
            CollectionSearchConfigurationUtils.validate(customSearchOnFieldsConfiguration.getDefaultCustomSearchCollectionConfiguration().getObjectgroupFields(), false);
        }
        if (CollectionUtils.isNotEmpty(customSearchOnFieldsConfiguration.getDedicatedTenantCustomSearchConfiguration())) {
            customSearchOnFieldsConfiguration.getDedicatedTenantCustomSearchConfiguration().stream().forEach(dedicatedConf -> {
                CollectionSearchConfigurationUtils.validate(dedicatedConf.getUnitFields(), true);
                CollectionSearchConfigurationUtils.validate(dedicatedConf.getObjectgroupFields(), true);
            });
        }
        if (CollectionUtils.isNotEmpty(customSearchOnFieldsConfiguration.getGroupedTenantConfiguration())) {
            customSearchOnFieldsConfiguration.getGroupedTenantConfiguration().stream().forEach(groupsConf -> {
                if (StringUtils.isEmpty((CharSequence)groupsConf.getTenants())) {
                    throw new IllegalStateException("Invalid configuration. tenants list is empty");
                }
                if (StringUtils.isEmpty((CharSequence)groupsConf.getName())) {
                    throw new IllegalStateException("Invalid configuration. group name should not be empty");
                }
                CollectionSearchConfigurationUtils.validate(groupsConf.getUnitFields(), true);
                CollectionSearchConfigurationUtils.validate(groupsConf.getObjectgroupFields(), true);
            });
        }
    }

    private static void validateVirtualPathsConfiguration(VirtualPathsConfiguration virtualPathsConfiguration) {
        if (virtualPathsConfiguration == null) {
            return;
        }
        ArrayList tenantRangeStrings = new ArrayList();
        if (virtualPathsConfiguration.getDefaultConfiguration() == null) {
            throw new IllegalStateException("Invalid configuration. Missing default virtual paths configuration");
        }
        if (CollectionUtils.isNotEmpty((Collection)virtualPathsConfiguration.getDedicatedTenantConfiguration())) {
            virtualPathsConfiguration.getDedicatedTenantConfiguration().stream().map(DedicatedVirtualPathsTenantConfiguration::getTenants).forEach(tenantRangeStrings::add);
        }
        TenantRangeValidator.validate(tenantRangeStrings);
    }
}

