/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.model.administration.OntologyOrigin;
import fr.gouv.vitam.common.model.administration.OntologyType;
import fr.gouv.vitam.common.model.administration.StringSize;
import fr.gouv.vitam.common.model.administration.TypeDetail;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bson.Document;

public class Ontology
extends VitamDocument<Ontology> {
    private static final long serialVersionUID = -5804983955259018611L;
    public static final String IDENTIFIER = "Identifier";
    public static final String SEDAFIELD = "SedaField";
    public static final String APIFIELD = "ApiField";
    public static final String DESCRIPTION = "Description";
    public static final String TYPE = "Type";
    public static final String ORIGIN = "Origin";
    public static final String SHORT_NAME = "ShortName";
    public static final String COLLECTIONS = "Collections";
    public static final String CREATIONDATE = "CreationDate";
    public static final String LAST_UPDATE = "LastUpdate";
    public static final String TYPE_DETAIL = "TypeDetail";
    public static final String STRING_SIZE = "StringSize";

    public Ontology() {
    }

    public Ontology(Document document) {
        super(document);
    }

    public Ontology(JsonNode content) {
        super(content);
    }

    public Ontology(String content) {
        super(content);
    }

    public Ontology(Integer tenantId) {
        this.append("_tenant", tenantId);
    }

    public VitamDocument<Ontology> newInstance(JsonNode content) {
        return new Ontology(content);
    }

    public Ontology setId(String id) {
        this.append("_id", id);
        return this;
    }

    public String getIdentifier() {
        return this.getString(IDENTIFIER);
    }

    public Ontology setIdentifier(String identifier) {
        this.append(IDENTIFIER, identifier);
        return this;
    }

    public String getSedaField() {
        return this.getString(SEDAFIELD);
    }

    public Ontology setSedaField(String sedaField) {
        this.append(SEDAFIELD, sedaField);
        return this;
    }

    public String getApiField() {
        return this.getString(APIFIELD);
    }

    public Ontology setApiField(String apiField) {
        this.append(APIFIELD, apiField);
        return this;
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public Ontology setDescription(String description) {
        this.append(DESCRIPTION, description);
        return this;
    }

    public OntologyType getType() {
        return Optional.ofNullable(this.getString(TYPE)).map(OntologyType::valueOf).orElse(null);
    }

    public Ontology setType(OntologyType type) {
        this.append(TYPE, type.getType());
        return this;
    }

    public OntologyOrigin getOrigin() {
        return Optional.ofNullable(this.getString(ORIGIN)).map(OntologyOrigin::valueOf).orElse(null);
    }

    public Ontology setOrigin(OntologyOrigin origin) {
        this.append(ORIGIN, origin.name());
        return this;
    }

    public String getShortName() {
        return this.getString(SHORT_NAME);
    }

    public Ontology setShortName(String shortName) {
        this.append(SHORT_NAME, shortName);
        return this;
    }

    public List<String> getCollections() {
        return (List)this.get(COLLECTIONS);
    }

    public Ontology setCollections(List<String> collections) {
        if (!collections.isEmpty()) {
            ArrayList<String> col = new ArrayList<String>();
            col.addAll(collections);
            this.append(COLLECTIONS, col);
        }
        return this;
    }

    public String getCreationdate() {
        return this.getString(CREATIONDATE);
    }

    public Ontology setCreationdate(String creationdate) {
        this.append(CREATIONDATE, creationdate);
        return this;
    }

    public String getLastupdate() {
        return this.getString(LAST_UPDATE);
    }

    public Ontology setLastupdate(String lastupdate) {
        this.append(LAST_UPDATE, lastupdate);
        return this;
    }

    public TypeDetail getTypeDetail() {
        return Optional.ofNullable(this.getString(TYPE_DETAIL)).map(TypeDetail::valueOf).orElse(null);
    }

    public Ontology setTypeDetail(TypeDetail typeDetail) {
        this.append(TYPE_DETAIL, typeDetail);
        return this;
    }

    public StringSize getStringSize() {
        return Optional.ofNullable(this.getString(STRING_SIZE)).map(StringSize::valueOf).orElse(null);
    }

    public Ontology setStringSize(StringSize stringSize) {
        this.append(STRING_SIZE, stringSize.getSize());
        return this;
    }
}

