/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.IngestContractCheckState;
import java.util.Set;
import org.bson.Document;

public class IngestContract
extends VitamDocument<IngestContract> {
    private static final long serialVersionUID = -3547871388720359674L;
    public static final String IDENTIFIER = "Identifier";
    public static final String NAME = "Name";
    public static final String DESCRIPTION = "Description";
    public static final String STATUS = "Status";
    public static final String CHECKPARENTLINK = "CheckParentLink";
    public static final String ARCHIVEPROFILES = "ArchiveProfiles";
    public static final String CREATIONDATE = "CreationDate";
    public static final String LAST_UPDATE = "LastUpdate";
    public static final String ACTIVATIONDATE = "ActivationDate";
    public static final String DEACTIVATIONDATE = "DeactivationDate";
    public static final String EVERYDATAOBJECTVERSION = "EveryDataObjectVersion";
    public static final String MASTERMANDATORY = "MasterMandatory";
    public static final String FORMATUNIDENTIFIEDAUTHORIZED = "FormatUnidentifiedAuthorized";
    public static final String EVERYFORMATTYPE = "EveryFormatType";
    public static final String MANAGEMENTCONTRACTID = "ManagementContractId";

    public IngestContract() {
    }

    public IngestContract(Document document) {
        super(document);
    }

    public IngestContract(JsonNode content) {
        super(content);
    }

    public IngestContract(String content) {
        super(content);
    }

    public IngestContract(Integer tenantId) {
        this.append("_tenant", tenantId);
    }

    public IngestContract setId(String id) {
        this.append("_id", id);
        return this;
    }

    public VitamDocument<IngestContract> newInstance(JsonNode content) {
        return new IngestContract(content);
    }

    public String getName() {
        return this.getString(NAME);
    }

    public IngestContract setName(String name) {
        this.append(NAME, name);
        return this;
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public IngestContract setDescription(String description) {
        this.append(DESCRIPTION, description);
        return this;
    }

    public ActivationStatus getStatus() {
        String status = this.getString(STATUS);
        if (status == null) {
            return null;
        }
        try {
            return ActivationStatus.valueOf((String)status);
        }
        catch (IllegalArgumentException exp) {
            throw new IllegalStateException("invalid STATUS value " + status);
        }
    }

    public IngestContract setStatus(ActivationStatus status) {
        this.append(STATUS, status.name());
        return this;
    }

    public IngestContract setCheckParentLink(IngestContractCheckState checkParentLink) {
        this.append(CHECKPARENTLINK, checkParentLink.name());
        return this;
    }

    public IngestContractCheckState getCheckParentLink() {
        String checkParentLink = this.getString(CHECKPARENTLINK);
        if (checkParentLink == null) {
            return null;
        }
        try {
            return IngestContractCheckState.valueOf((String)checkParentLink);
        }
        catch (IllegalArgumentException exp) {
            throw new IllegalStateException("invalid CHECKPARENTLINK value " + checkParentLink);
        }
    }

    public Set<String> getArchiveProfiles() {
        return (Set)this.get(ARCHIVEPROFILES);
    }

    public IngestContract setArchiveProfiles(Set<String> archiveProfiles) {
        this.append(ARCHIVEPROFILES, archiveProfiles);
        return this;
    }

    public String getCreationdate() {
        return this.getString(CREATIONDATE);
    }

    public IngestContract setCreationdate(String creationdate) {
        this.append(CREATIONDATE, creationdate);
        return this;
    }

    public String getLastupdate() {
        return this.getString(LAST_UPDATE);
    }

    public IngestContract setLastupdate(String lastupdate) {
        this.append(LAST_UPDATE, lastupdate);
        return this;
    }

    public String getActivationdate() {
        return this.getString(ACTIVATIONDATE);
    }

    public IngestContract setActivationdate(String activationdate) {
        this.append(ACTIVATIONDATE, activationdate);
        return this;
    }

    public String getDeactivationdate() {
        return this.getString(DEACTIVATIONDATE);
    }

    public IngestContract setDeactivationdate(String deactivationdate) {
        this.append(DEACTIVATIONDATE, deactivationdate);
        return this;
    }

    public Boolean getEveryDataObjectVersion() {
        return this.getBoolean(EVERYDATAOBJECTVERSION);
    }

    public IngestContract setEveryDataObjectVersion(boolean everyDataObjectVersion) {
        this.append(EVERYDATAOBJECTVERSION, everyDataObjectVersion);
        return this;
    }

    public Boolean getMasterMandatory() {
        return this.getBoolean(MASTERMANDATORY);
    }

    public IngestContract setMasterMandatory(boolean masterMandatory) {
        this.append(MASTERMANDATORY, masterMandatory);
        return this;
    }

    public Boolean getEveryFormatType() {
        return this.getBoolean(EVERYFORMATTYPE);
    }

    public IngestContract setEveryFormatType(boolean everyFormatType) {
        this.append(EVERYFORMATTYPE, everyFormatType);
        return this;
    }

    public Boolean getFormatUnidentifiedAuthorized() {
        return this.getBoolean(FORMATUNIDENTIFIEDAUTHORIZED);
    }

    public IngestContract setFormatUnidentifiedAuthorized(boolean formatUnidentifiedAuthorized) {
        this.append(FORMATUNIDENTIFIEDAUTHORIZED, formatUnidentifiedAuthorized);
        return this;
    }

    public IngestContract setManagementContractId(String managementContractId) {
        this.append(MANAGEMENTCONTRACTID, managementContractId);
        return this;
    }

    public String getManagementContractId() {
        return this.getString(MANAGEMENTCONTRACTID);
    }
}

