/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

public class FileFormat
extends VitamDocument<FileFormat> {
    public static final String PUID = "PUID";
    public static final String VERSION_PRONOM = "VersionPronom";
    public static final String VERSION = "Version";
    public static final String CREATED_DATE = "CreatedDate";
    public static final String UPDATE_DATE = "UpdateDate";
    public static final String HAS_PRIORITY_OVER_FILE_FORMAT_ID = "HasPriorityOverFileFormatID";
    public static final String MIME_TYPE = "MimeType";
    public static final String NAME = "Name";
    public static final String GROUP = "Group";
    public static final String ALERT = "Alert";
    public static final String COMMENT = "Comment";
    public static final String EXTENSION = "Extension";
    private static final long serialVersionUID = 7794456688851515535L;

    public FileFormat() {
    }

    public FileFormat(Document document) {
        super(document);
    }

    public FileFormat(JsonNode content) {
        super(content);
    }

    public FileFormat(String content) {
        super(content);
    }

    public VitamDocument<FileFormat> newInstance(JsonNode content) {
        return new FileFormat(content);
    }

    public FileFormat setPUID(String puid) {
        this.append(PUID, puid);
        return this;
    }

    public FileFormat setExtension(List<String> extension) {
        if (!extension.isEmpty()) {
            ArrayList<String> ext = new ArrayList<String>();
            ext.addAll(extension);
            this.append(EXTENSION, ext);
        }
        return this;
    }

    public FileFormat setName(String name) {
        this.append(NAME, name);
        return this;
    }

    public FileFormat setMimeType(String mimeType) {
        this.append(MIME_TYPE, mimeType);
        return this;
    }

    public FileFormat setVersion(String version) {
        this.append(VERSION, version);
        return this;
    }

    public FileFormat setPriorityOverIdList(List<String> priorityOverIdList) {
        if (!priorityOverIdList.isEmpty()) {
            ArrayList<String> priorityList = new ArrayList<String>();
            priorityList.addAll(priorityOverIdList);
            this.append(HAS_PRIORITY_OVER_FILE_FORMAT_ID, priorityList);
        }
        return this;
    }

    public FileFormat setCreatedDate(String createdDate) {
        this.append(CREATED_DATE, createdDate);
        return this;
    }

    public FileFormat setPronomVersion(String pronomVersion) {
        this.append(VERSION_PRONOM, pronomVersion);
        return this;
    }

    public FileFormat setComment(String comment) {
        this.append(COMMENT, comment);
        return this;
    }

    public FileFormat setAlert(boolean alert) {
        this.append(ALERT, alert);
        return this;
    }

    public FileFormat setGroup(String group) {
        this.append(GROUP, group);
        return this;
    }
}

