/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import java.util.List;
import org.bson.Document;

public class Agencies
extends VitamDocument<Agencies> {
    private static final long serialVersionUID = 4196706995314270224L;
    public static final String IDENTIFIER = "Identifier";
    public static final String NAME = "Name";
    public static final String DESCRIPTION = "Description";
    private static final String TENANT = "_tenant";
    public static final String ENTITY_TYPE = "EntityType";
    public static final String NAME_ENTRY_PARALLEL = "NameEntryParallel";
    public static final String AUTHORIZED_FORM = "AuthorizedForm";
    public static final String ALTERNATIVE_FORM = "AlternativeForm";
    public static final String ENTITY_ID = "EntityId";
    public static final String FROM_DATE = "FromDate";
    public static final String TO_DATE = "ToDate";
    public static final String FUNCTIONS = "Functions";
    public static final String BIOG_HIST = "BiogHist";
    public static final String PLACES = "Places";
    public static final String LEGAL_STATUSES = "LegalStatuses";
    public static final String MANDATES = "Mandates";
    public static final String STRUCTURE_OR_GENEALOGY = "StructureOrGenealogy";
    public static final String GENERAL_CONTEXT = "GeneralContext";
    public static final String CREATION_DATE = "CreationDate";
    public static final String UPDATE_DATE = "UpdateDate";
    public static final String MAINTENANCE_STATUS = "MaintenanceStatus";
    public static final String LOCAL_STATUS = "LocalStatus";
    public static final String SOURCES = "Sources";
    public static final String EVENT_DESCRIPTION = "EventDescription";

    public Agencies() {
    }

    public Agencies(Integer tenantId) {
        this.append(TENANT, tenantId);
    }

    public Agencies(Document document) {
        super(document);
    }

    public Agencies(JsonNode content) {
        super(content);
    }

    public Agencies(String content) {
        super(content);
    }

    public VitamDocument<Agencies> newInstance(JsonNode content) {
        return new Agencies(content);
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public Agencies setDescription(String description) {
        this.append(DESCRIPTION, description);
        return this;
    }

    public String getIdentifier() {
        return this.getString(IDENTIFIER);
    }

    public Agencies setIdentifier(String identifier) {
        this.append(IDENTIFIER, identifier);
        return this;
    }

    public String getName() {
        return this.getString(NAME);
    }

    public Agencies setName(String name) {
        this.append(NAME, name);
        return this;
    }

    public String getEntityType() {
        return this.getString(ENTITY_TYPE);
    }

    public List<String> getNameEntryParallel() {
        return this.getList(NAME_ENTRY_PARALLEL, String.class);
    }

    public List<String> getAuthorizedForm() {
        return this.getList(AUTHORIZED_FORM, String.class);
    }

    public List<String> getAlternativeForm() {
        return this.getList(ALTERNATIVE_FORM, String.class);
    }

    public String getEntityId() {
        return this.getString(ENTITY_ID);
    }

    public String getFromDate() {
        return this.getString(FROM_DATE);
    }

    public String getToDate() {
        return this.getString(TO_DATE);
    }

    public List<String> getFunctions() {
        return this.getList(FUNCTIONS, String.class);
    }

    public String getBiogHist() {
        return this.getString(BIOG_HIST);
    }

    public List<String> getPlaces() {
        return this.getList(PLACES, String.class);
    }

    public List<String> getLegalStatuses() {
        return this.getList(LEGAL_STATUSES, String.class);
    }

    public List<String> getMandates() {
        return this.getList(MANDATES, String.class);
    }

    public String getStructureOrGenealogy() {
        return this.getString(STRUCTURE_OR_GENEALOGY);
    }

    public String getGeneralContext() {
        return this.getString(GENERAL_CONTEXT);
    }

    public String getCreationDate() {
        return this.getString(CREATION_DATE);
    }

    public String getUpdateDate() {
        return this.getString(UPDATE_DATE);
    }

    public String getMaintenanceStatus() {
        return this.getString(MAINTENANCE_STATUS);
    }

    public String getLocalStatus() {
        return this.getString(LOCAL_STATUS);
    }

    public List<String> getSources() {
        return this.getList(SOURCES, String.class);
    }

    public String getEventDescription() {
        return this.getString(EVENT_DESCRIPTION);
    }

    public Agencies setEntityType(String entityType) {
        this.append(ENTITY_TYPE, entityType);
        return this;
    }

    public Agencies setNameEntryParallel(List<String> nameEntryParallel) {
        this.append(NAME_ENTRY_PARALLEL, nameEntryParallel);
        return this;
    }

    public Agencies setAuthorizedForm(List<String> authorizedForm) {
        this.append(AUTHORIZED_FORM, authorizedForm);
        return this;
    }

    public Agencies setAlternativeForm(List<String> alternativeForm) {
        this.append(ALTERNATIVE_FORM, alternativeForm);
        return this;
    }

    public Agencies setEntityId(String entityId) {
        this.append(ENTITY_ID, entityId);
        return this;
    }

    public Agencies setFromDate(String fromDate) {
        this.append(FROM_DATE, fromDate);
        return this;
    }

    public Agencies setToDate(String toDate) {
        this.append(TO_DATE, toDate);
        return this;
    }

    public Agencies setFunctions(List<String> functions) {
        this.append(FUNCTIONS, functions);
        return this;
    }

    public Agencies setBiogHist(String biogHist) {
        this.append(BIOG_HIST, biogHist);
        return this;
    }

    public Agencies setPlaces(List<String> places) {
        this.append(PLACES, places);
        return this;
    }

    public Agencies setLegalStatuses(List<String> legalStatuses) {
        this.append(LEGAL_STATUSES, legalStatuses);
        return this;
    }

    public Agencies setMandates(List<String> mandates) {
        this.append(MANDATES, mandates);
        return this;
    }

    public Agencies setStructureOrGenealogy(String structureOrGenealogy) {
        this.append(STRUCTURE_OR_GENEALOGY, structureOrGenealogy);
        return this;
    }

    public Agencies setGeneralContext(String generalContext) {
        this.append(GENERAL_CONTEXT, generalContext);
        return this;
    }

    public Agencies setCreationDate(String creationDate) {
        this.append(CREATION_DATE, creationDate);
        return this;
    }

    public Agencies setUpdateDate(String updateDate) {
        this.append(UPDATE_DATE, updateDate);
        return this;
    }

    public Agencies setMaintenanceStatus(String maintenanceStatus) {
        this.append(MAINTENANCE_STATUS, maintenanceStatus);
        return this;
    }

    public Agencies setLocalStatus(String localStatus) {
        this.append(LOCAL_STATUS, localStatus);
        return this;
    }

    public Agencies setSources(List<String> sources) {
        this.append(SOURCES, sources);
        return this;
    }

    public Agencies setEventDescription(String eventDescription) {
        this.append(EVENT_DESCRIPTION, eventDescription);
        return this;
    }

    public AgenciesModel wrap() {
        return new AgenciesModel(this.getIdentifier(), this.getName(), this.getDescription(), ((Integer)this.get("#tenant", Integer.class)).intValue()).setToDate(this.getToDate()).setFromDate(this.getFromDate()).setUpdateDate(this.getUpdateDate()).setEntityType(this.getEntityType()).setEntityId(this.getEntityId()).setNameEntryParallel(this.getNameEntryParallel()).setAuthorizedForm(this.getAuthorizedForm()).setAlternativeForm(this.getAlternativeForm()).setFunctions(this.getFunctions()).setBiogHist(this.getBiogHist()).setPlaces(this.getPlaces()).setLegalStatuses(this.getLegalStatuses()).setMandates(this.getMandates()).setStructureOrGenealogy(this.getStructureOrGenealogy()).setGeneralContext(this.getGeneralContext()).setCreationDate(this.getCreationDate()).setMaintenanceStatus(this.getMaintenanceStatus()).setLocalStatus(this.getLocalStatus()).setEventDescription(this.getEventDescription()).setSources(this.getSources());
    }
}

