/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.administration.AccessionRegisterStatus;
import fr.gouv.vitam.common.model.administration.RegisterValueDetailModel;
import fr.gouv.vitam.common.model.administration.RegisterValueEventModel;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

public class AccessionRegisterDetail
extends VitamDocument<AccessionRegisterDetail> {
    private static final long serialVersionUID = 3439757375656161919L;
    public static final String ACQUISITION_INFORMATION = "AcquisitionInformation";
    public static final String LEGAL_STATUS = "LegalStatus";
    public static final String ORIGINATING_AGENCY = "OriginatingAgency";
    public static final String SUBMISSION_AGENCY = "SubmissionAgency";
    public static final String ARCHIVALAGREEMENT = "ArchivalAgreement";
    public static final String START_DATE = "StartDate";
    public static final String END_DATE = "EndDate";
    public static final String LAST_UPDATE = "LastUpdate";
    public static final String TOTAL_UNITS = "TotalUnits";
    public static final String TOTAL_OBJECTGROUPS = "TotalObjectGroups";
    public static final String TOTAL_OBJECTS = "TotalObjects";
    public static final String OBJECT_SIZE = "ObjectSize";
    public static final String STATUS = "Status";
    public static final String OPC = "Opc";
    public static final String OPI = "Opi";
    public static final String ARCHIVAL_PROFILE = "ArchivalProfile";
    public static final String OPERATION_IDS = "OperationIds";
    public static final String EVENTS = "Events";
    public static final String TENANT = "_tenant";
    public static final String OB_ID_IN = "obIdIn";
    public static final String COMMENT = "Comment";
    public static final List<String> AUTHORIZED_FIELDS_TO_UPDATE = List.of("Comment", "obIdIn");

    public AccessionRegisterDetail() {
    }

    public AccessionRegisterDetail(Document document) {
        super(document);
    }

    public AccessionRegisterDetail(JsonNode content) {
        super(content);
    }

    public AccessionRegisterDetail(String content) {
        super(content);
    }

    public AccessionRegisterDetail(Integer tenantId) {
        this.append(TENANT, tenantId);
    }

    public AccessionRegisterDetail setId(String id) {
        this.append("_id", id);
        return this;
    }

    public VitamDocument<AccessionRegisterDetail> newInstance(JsonNode content) {
        return new AccessionRegisterDetail(content);
    }

    public String getAcquisitionInformation() {
        return this.getString(ACQUISITION_INFORMATION);
    }

    public AccessionRegisterDetail setAcquisitionInformation(String acquisitionInformation) {
        this.append(ACQUISITION_INFORMATION, acquisitionInformation);
        return this;
    }

    public String getLegalStatus() {
        return this.getString(LEGAL_STATUS);
    }

    public AccessionRegisterDetail setLegalStatus(String legalStatus) {
        this.append(LEGAL_STATUS, legalStatus);
        return this;
    }

    public AccessionRegisterDetail setArchivalProfile(String ArchivalProfile) {
        this.append(ARCHIVAL_PROFILE, ArchivalProfile);
        return this;
    }

    public String getArchivalProfile() {
        return this.getString(ARCHIVAL_PROFILE);
    }

    public String getOriginatingAgency() {
        return this.getString(ORIGINATING_AGENCY);
    }

    public AccessionRegisterDetail setOriginatingAgency(String orgAgency) {
        this.append(ORIGINATING_AGENCY, orgAgency);
        return this;
    }

    public AccessionRegisterDetail setSubmissionAgency(String subAgency) {
        this.append(SUBMISSION_AGENCY, subAgency);
        return this;
    }

    public AccessionRegisterDetail setArchivalAgreement(String archivalAgreement) {
        this.append(ARCHIVALAGREEMENT, archivalAgreement);
        return this;
    }

    public AccessionRegisterDetail setStartDate(String startDate) {
        this.append(START_DATE, LocalDateUtil.getFormattedDateTimeForMongo((String)startDate));
        return this;
    }

    public String getEndDate() {
        return this.getString(END_DATE);
    }

    public AccessionRegisterDetail setEndDate(String endDate) {
        this.append(END_DATE, LocalDateUtil.getFormattedDateTimeForMongo((String)endDate));
        return this;
    }

    public AccessionRegisterDetail setLastUpdate(String lastUpdate) {
        this.append(LAST_UPDATE, LocalDateUtil.getFormattedDateTimeForMongo((String)lastUpdate));
        return this;
    }

    public AccessionRegisterDetail setObIdIn(String obIdIn) {
        this.append(OB_ID_IN, obIdIn);
        return this;
    }

    public AccessionRegisterDetail setComment(List<String> comment) {
        this.append(COMMENT, comment);
        return this;
    }

    public RegisterValueDetailModel getTotalUnits() {
        try {
            return (RegisterValueDetailModel)JsonHandler.getFromJsonNode((JsonNode)JsonHandler.toJsonNode((Object)this.get(TOTAL_UNITS)), RegisterValueDetailModel.class);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public AccessionRegisterDetail setTotalUnits(RegisterValueDetailModel totalUnits) {
        this.append(TOTAL_UNITS, totalUnits);
        return this;
    }

    public RegisterValueDetailModel getTotalObjectGroups() {
        try {
            return (RegisterValueDetailModel)JsonHandler.getFromJsonNode((JsonNode)JsonHandler.toJsonNode((Object)this.get(TOTAL_OBJECTGROUPS)), RegisterValueDetailModel.class);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public AccessionRegisterDetail setTotalObjectGroups(RegisterValueDetailModel totalObjectGroups) {
        this.append(TOTAL_OBJECTGROUPS, totalObjectGroups);
        return this;
    }

    public RegisterValueDetailModel getTotalObjects() {
        try {
            return (RegisterValueDetailModel)JsonHandler.getFromJsonNode((JsonNode)JsonHandler.toJsonNode((Object)this.get(TOTAL_OBJECTS)), RegisterValueDetailModel.class);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public AccessionRegisterDetail setTotalObjects(RegisterValueDetailModel total) {
        this.append(TOTAL_OBJECTS, total);
        return this;
    }

    public AccessionRegisterDetail setObjectSize(RegisterValueDetailModel objectSize) {
        this.append(OBJECT_SIZE, objectSize);
        return this;
    }

    public RegisterValueDetailModel getTotalObjectSize() {
        try {
            return (RegisterValueDetailModel)JsonHandler.getFromJsonNode((JsonNode)JsonHandler.toJsonNode((Object)this.get(OBJECT_SIZE)), RegisterValueDetailModel.class);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public AccessionRegisterDetail setStatus(AccessionRegisterStatus status) {
        this.append(STATUS, status.name());
        return this;
    }

    public AccessionRegisterStatus getStatus() {
        try {
            return (AccessionRegisterStatus)JsonHandler.getFromJsonNode((JsonNode)JsonHandler.toJsonNode((Object)this.get(STATUS)), AccessionRegisterStatus.class);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public AccessionRegisterDetail setOpc(String opc) {
        this.append(OPC, opc);
        return this;
    }

    public String getOpc() {
        return (String)this.get(OPC);
    }

    public AccessionRegisterDetail setOpi(String opi) {
        this.append(OPI, opi);
        return this;
    }

    public String getOpi() {
        return this.getString(OPI);
    }

    public AccessionRegisterDetail setOperationIds(List<String> operationIds) {
        if (!operationIds.isEmpty()) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.addAll(operationIds);
            this.append(OPERATION_IDS, ids);
        }
        return this;
    }

    public AccessionRegisterDetail setEvents(List<RegisterValueEventModel> events) {
        if (!events.isEmpty()) {
            ArrayList<RegisterValueEventModel> ids = new ArrayList<RegisterValueEventModel>();
            ids.addAll(events);
            this.append(EVENTS, ids);
        }
        return this;
    }

    public List<RegisterValueEventModel> getEvents() {
        try {
            return (List)JsonHandler.getFromJsonNode((JsonNode)JsonHandler.toJsonNode((Object)this.get(EVENTS)), (TypeReference)new TypeReference<List<RegisterValueEventModel>>(this){});
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

