/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import java.util.List;
import java.util.Optional;

public class AdminManagementOntologyLoader
implements OntologyLoader {
    private final AdminManagementClientFactory factory;
    private final ObjectNode select;

    public AdminManagementOntologyLoader(AdminManagementClientFactory factory, Optional<String> collectionName) {
        this.factory = factory;
        this.select = this.getSelectOntology(collectionName);
    }

    private ObjectNode getSelectOntology(Optional<String> collectionName) {
        try {
            Select selectOntologies = new Select();
            if (collectionName.isPresent()) {
                selectOntologies.setQuery((Query)QueryHelper.in((String)"Collections", (String[])new String[]{collectionName.get()}));
            }
            selectOntologies.addUsedProjection(new String[]{"Identifier"});
            selectOntologies.addUsedProjection(new String[]{"Type"});
            return selectOntologies.getFinalSelect();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new VitamRuntimeException(e);
        }
    }

    public List<OntologyModel> loadOntologies() {
        List list;
        block9: {
            AdminManagementClient adminClient = this.factory.getClient();
            try {
                RequestResponse<OntologyModel> responseOntologies = adminClient.findOntologies((JsonNode)this.select);
                if (!responseOntologies.isOk()) {
                    throw new VitamRuntimeException("Could not load ontologies.");
                }
                list = ((RequestResponseOK)responseOntologies).getResults();
                if (adminClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    throw new VitamRuntimeException("Could not load ontologies.", (Throwable)e);
                }
            }
            adminClient.close();
        }
        return list;
    }
}

