/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.ForbiddenClientException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitam.common.model.ProcessPause;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.AbstractContractModel;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSummaryModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSymbolicModel;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.model.administration.CombinedSchemaModel;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.FileFormatModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitam.common.model.administration.preservation.GriffinModel;
import fr.gouv.vitam.common.model.administration.preservation.PreservationScenarioModel;
import fr.gouv.vitam.common.model.administration.profile.ProfileModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaInputModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.common.model.audit.AuditReferentialOptions;
import fr.gouv.vitam.common.model.configuration.PublicConfiguration;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.ReconstructionRequestItem;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientBadRequestException;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.DatabaseConflictException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesNotFoundException;
import fr.gouv.vitam.functional.administration.common.exception.ProfileNotFoundException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialImportInProgressException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.functional.administration.common.server.AccessionRegisterSymbolic;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.List;

class AdminManagementClientRest
extends DefaultClient
implements AdminManagementClient {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminManagementClientRest.class);
    private static final String FORMAT_CHECK_URL = "/format/check";
    private static final String FORMAT_IMPORT_URL = "/format/import";
    private static final String FORMAT_GET_DOCUMENT_URL = "/format/document";
    private static final String FORMAT_URL = "/format";
    private static final String RULESMANAGER_CHECK_URL = "/rules/check";
    private static final String AGENCIESMANAGER_CHECK_URL = "/agencies/check";
    private static final String RULESMANAGER_IMPORT_URL = "/rules/import";
    private static final String AGENCIESMANAGER_IMPORT_URL = "/agencies/import";
    private static final String AGENCIES_URL = "/agencies";
    private static final String RULESMANAGER_GET_DOCUMENT_URL = "/rules/document";
    private static final String RULESMANAGER_URL = "/rules";
    private static final String ACCESSION_REGISTER_CREATE_URI = "/accession-register";
    private static final String ACCESSION_REGISTER_GET_DOCUMENT_URL = "/accession-register/document";
    private static final String ACCESSION_REGISTER_GET_DETAIL_URL = "/accession-register/detail";
    private static final String INGEST_CONTRACTS_URI = "/ingestcontracts";
    private static final String ACCESS_CONTRACTS_URI = "/accesscontracts";
    private static final String MANAGEMENT_CONTRACTS_URI = "/managementcontracts";
    private static final String UPDATE_ACCESS_CONTRACT_URI = "/accesscontracts/";
    private static final String UPDATE_INGEST_CONTRACT_URI = "/ingestcontracts/";
    private static final String UPDATE_MANAGEMENT_CONTRACT_URI = "/managementcontracts/";
    private static final String PROFILE_URI = "/profiles";
    private static final String CONTEXT_URI = "/contexts";
    private static final String AUDIT_URI = "/audit";
    private static final String AUDIT_RULE_URI = "/auditRule";
    private static final String REFERENTIAL_AUDIT_URI = "/audit/referential";
    private static final String UPDATE_CONTEXT_URI = "/context/";
    private static final String UPDATE_PROFIL_URI = "/profiles/";
    private static final String SECURITY_PROFILES_URI = "/securityprofiles";
    private static final String EVIDENCE_AUDIT_URI = "/evidenceaudit";
    private static final String ARCHIVE_UNIT_PROFILE_URI = "/archiveunitprofiles";
    private static final String UPDATE_ARCHIVE_UNIT_PROFILE_URI = "/archiveunitprofiles/";
    private static final String ONTOLOGY_URI = "/ontologies";
    private static final String PROBATIVE_VALUE_URI = "/probativevalueexport";
    private static final String REINDEX_URI = "/reindex";
    private static final String ALIASES_URI = "/alias";
    private static final String RECTIFICATION_AUDIT = "/rectificationaudit";
    private static final String CREATE_EXTERNAL_OPERATION_URI = "/logbookoperations";
    private static final String FORCE_PAUSE_URI = "/forcepause";
    private static final String REMOVE_FORCE_PAUSE_URI = "/removeforcepause";
    private static final String INTERNAL_SERVER_ERROR_MSG = "Internal Server Error";
    private static final String RECONSTRUCTION_URI = "/reconstruction/";
    private static final String RECONSTRUCTION_ACCESSION_REGISTER = "/accessionregisterreconstruction/";
    public static final String SCHEMA_UNIT_URI = "/schema/unit";
    public static final String CONFIGURATION_URL = "/configuration";
    public static final String SCHEMA_ARCHIVE_UNIT_PROFILE_URI = "/archiveunitprofiles/{id}/schema";
    public static final String SCHEMA_OBJECTGROUP_URI = "/schema/objectgroup";

    AdminManagementClientRest(AdminManagementClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    @Override
    public Response checkFormat(InputStream stream) throws ReferentialException {
        ParametersChecker.checkParameter((String)"stream is a mandatory parameter", (Object[])new Object[]{stream});
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(FORMAT_CHECK_URL).withBody((Object)stream).withOctetContentType().withJsonAccept();
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(request);
            this.checkWithSpecificException(response);
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
            throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public Response.Status importFormat(InputStream stream, String filename) throws ReferentialException, DatabaseConflictException {
        Response.Status status;
        block8: {
            ParametersChecker.checkParameter((String)"stream is a mandatory parameter", (Object[])new Object[]{stream});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(FORMAT_IMPORT_URL).withHeader("X-Filename", (Object)filename).withBody((Object)stream).withOctetContentType().withJsonAccept();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                status = Response.Status.fromStatusCode((int)response.getStatus());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return status;
    }

    @Override
    public JsonNode getFormatByID(String id) throws ReferentialException, InvalidParseOperationException {
        JsonNode jsonNode;
        block8: {
            ParametersChecker.checkParameter((String)"id is a mandatory parameter", (String[])new String[]{id});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/format/" + id).withJsonAccept();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                jsonNode = JsonHandler.getFromString((String)((String)response.readEntity(String.class)));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public RequestResponse<FileFormatModel> getFormats(JsonNode query) throws ReferentialException, InvalidParseOperationException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"query is a mandatory parameter", (Object[])new Object[]{query});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(FORMAT_GET_DOCUMENT_URL).withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = (RequestResponse)JsonHandler.getFromString((String)((String)response.readEntity(String.class)), RequestResponseOK.class, FileFormatModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Response checkRulesFile(InputStream stream) throws AdminManagementClientServerException {
        ParametersChecker.checkParameter((String)"stream is a mandatory parameter", (Object[])new Object[]{stream});
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(RULESMANAGER_CHECK_URL).withBody((Object)stream).withOctetContentType().withOctetAccept();
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(request);
            this.checkWithSpecificException(response);
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        catch (AccessUnauthorizedException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException | ReferentialNotFoundException e) {
            String reason = response != null ? (String)response.readEntity(String.class) : INTERNAL_SERVER_ERROR_MSG;
            throw new AdminManagementClientServerException(reason, e);
        }
        catch (BadRequestException e) {
            throw new AdminManagementClientBadRequestException((Throwable)e);
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public Response checkAgenciesFile(InputStream stream) throws AdminManagementClientServerException {
        ParametersChecker.checkParameter((String)"stream is a mandatory parameter", (Object[])new Object[]{stream});
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(AGENCIESMANAGER_CHECK_URL).withBody((Object)stream).withOctetContentType().withOctetAccept();
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(request);
            this.checkWithSpecificException(response);
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        catch (AccessUnauthorizedException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException | ReferentialNotFoundException e) {
            throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
        }
        catch (BadRequestException e) {
            throw new AdminManagementClientBadRequestException((Throwable)e);
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public Response.Status importRulesFile(InputStream stream, String filename) throws ReferentialException, DatabaseConflictException {
        Response.Status status;
        block10: {
            ParametersChecker.checkParameter((String)"stream is a mandatory parameter", (Object[])new Object[]{stream});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(RULESMANAGER_IMPORT_URL).withHeader("X-Filename", (Object)filename).withBody((Object)stream).withOctetContentType().withJsonAccept();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                status = Response.Status.fromStatusCode((int)response.getStatus());
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
                catch (BadRequestException e) {
                    throw new FileRulesException((Throwable)e);
                }
                catch (ForbiddenClientException e) {
                    throw new ReferentialImportInProgressException((Throwable)e);
                }
            }
            response.close();
        }
        return status;
    }

    @Override
    public Response.Status importAgenciesFile(InputStream stream, String filename) throws ReferentialException {
        Response.Status status;
        block9: {
            ParametersChecker.checkParameter((String)"filename is a mandatory parameter", (String[])new String[]{filename});
            ParametersChecker.checkParameter((String)"stream is a mandatory parameter", (Object[])new Object[]{stream});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(AGENCIESMANAGER_IMPORT_URL).withHeader("X-Filename", (Object)filename).withBody((Object)stream).withOctetContentType().withJsonAccept();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                status = Response.Status.fromStatusCode((int)response.getStatus());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
                catch (BadRequestException e) {
                    throw new AdminManagementClientBadRequestException((Throwable)e);
                }
            }
            response.close();
        }
        return status;
    }

    @Override
    public JsonNode getAgencies(JsonNode query) throws ReferentialException, InvalidParseOperationException {
        JsonNode jsonNode;
        block9: {
            ParametersChecker.checkParameter((String)"query is a mandatory parameter", (Object[])new Object[]{query});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(AGENCIES_URL).withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                jsonNode = JsonHandler.getFromString((String)((String)response.readEntity(String.class)));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
                catch (BadRequestException e) {
                    throw new FileRulesNotFoundException("Agency Not found", (Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public RequestResponse<AgenciesModel> getAgencyById(String id) throws InvalidParseOperationException, ReferentialNotFoundException, AdminManagementClientServerException {
        RequestResponseOK requestResponseOK;
        block11: {
            JsonNode queryDsl;
            ParametersChecker.checkParameter((String)"The input documentId json is mandatory", (String[])new String[]{id});
            try {
                queryDsl = this.getIdentifierQuery("Identifier", id);
            }
            catch (InvalidCreateOperationException e) {
                throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            }
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(AGENCIES_URL).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                RequestResponseOK resp = (RequestResponseOK)JsonHandler.getFromString((String)((String)response.readEntity(String.class)), RequestResponseOK.class, AgenciesModel.class);
                if (resp.getResults() == null || resp.getResults().isEmpty()) {
                    throw new ReferentialNotFoundException("Agency not found with id: " + id);
                }
                requestResponseOK = resp;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public JsonNode getRuleByID(String id) throws FileRulesException, InvalidParseOperationException, AdminManagementClientServerException {
        JsonNode jsonNode;
        block9: {
            ParametersChecker.checkParameter((String)"id is a mandatory parameter", (String[])new String[]{id});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/rules/" + id).withJsonAccept();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                jsonNode = JsonHandler.getFromString((String)((String)response.readEntity(String.class)));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
                catch (ReferentialNotFoundException e) {
                    throw new FileRulesNotFoundException("Rule " + id + " not found", (Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode getRules(JsonNode query) throws FileRulesException, InvalidParseOperationException, AdminManagementClientServerException {
        JsonNode jsonNode;
        block9: {
            ParametersChecker.checkParameter((String)"query is a mandatory parameter", (Object[])new Object[]{query});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(RULESMANAGER_GET_DOCUMENT_URL).withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                jsonNode = JsonHandler.getFromString((String)((String)response.readEntity(String.class)));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
                catch (ReferentialNotFoundException e) {
                    throw new FileRulesNotFoundException("Rule Not found", (Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public RequestResponse<AccessionRegisterDetailModel> createOrUpdateAccessionRegister(AccessionRegisterDetailModel register) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"Accession register is a mandatory parameter", (Object[])new Object[]{register});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(ACCESSION_REGISTER_CREATE_URI).withBody((Object)register).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, AccessionRegisterDetailModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<AccessionRegisterSummaryModel> getAccessionRegister(JsonNode query) throws ReferentialException, AccessUnauthorizedException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"query is a mandatory parameter", (Object[])new Object[]{query});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(ACCESSION_REGISTER_GET_DOCUMENT_URL).withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, AccessionRegisterSummaryModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<AccessionRegisterDetailModel> getAccessionRegisterDetail(String originatingAgency, JsonNode query) throws ReferentialException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"query is a mandatory parameter", (Object[])new Object[]{query});
            ParametersChecker.checkParameter((String)"documentId is a mandatory parameter", (String[])new String[]{originatingAgency});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/accession-register/detail/" + originatingAgency).withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, AccessionRegisterDetailModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<AccessionRegisterDetailModel> getAccessionRegisterDetail(JsonNode query) throws ReferentialException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"query is a mandatory parameter", (Object[])new Object[]{query});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(ACCESSION_REGISTER_GET_DETAIL_URL).withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, AccessionRegisterDetailModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Response.Status importIngestContracts(List<IngestContractModel> ingestContractModelList) throws AdminManagementClientServerException {
        ParametersChecker.checkParameter((String)"The input ingest contracts json is mandatory", (Object[])new Object[]{ingestContractModelList});
        return this.importContracts(ingestContractModelList, INGEST_CONTRACTS_URI);
    }

    @Override
    public Response.Status importAccessContracts(List<AccessContractModel> accessContractModelList) throws AdminManagementClientServerException {
        ParametersChecker.checkParameter((String)"The input access contracts json is mandatory", (Object[])new Object[]{accessContractModelList});
        return this.importContracts(accessContractModelList, ACCESS_CONTRACTS_URI);
    }

    @Override
    public Response.Status importManagementContracts(List<ManagementContractModel> managementContractModelList) throws AdminManagementClientServerException {
        ParametersChecker.checkParameter((String)"The input management contracts json is mandatory", (Object[])new Object[]{managementContractModelList});
        return this.importContracts(managementContractModelList, MANAGEMENT_CONTRACTS_URI);
    }

    private <T extends AbstractContractModel> Response.Status importContracts(List<T> contractModelList, String uri) throws AdminManagementClientServerException {
        Response.Status status;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(uri).withBody(contractModelList).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                status = Response.Status.fromStatusCode((int)response.getStatus());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return status;
    }

    @Override
    public RequestResponse<AccessContractModel> findAccessContracts(JsonNode queryDsl) throws AdminManagementClientServerException {
        ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
        return this.findContracts(queryDsl, ACCESS_CONTRACTS_URI, AccessContractModel.class);
    }

    @Override
    public RequestResponse<IngestContractModel> findIngestContracts(JsonNode queryDsl) throws AdminManagementClientServerException {
        ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
        return this.findContracts(queryDsl, INGEST_CONTRACTS_URI, IngestContractModel.class);
    }

    @Override
    public RequestResponse<ManagementContractModel> findManagementContracts(JsonNode queryDsl) throws AdminManagementClientServerException {
        ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
        return this.findContracts(queryDsl, MANAGEMENT_CONTRACTS_URI, ManagementContractModel.class);
    }

    private <T extends AbstractContractModel> RequestResponse<T> findContracts(JsonNode queryDsl, String uri, Class<T> clasz) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(uri).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, clasz);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<AccessContractModel> findAccessContractsByID(String documentId) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        ParametersChecker.checkParameter((String)"The input documentId json is mandatory", (String[])new String[]{documentId});
        return this.findContractByID(documentId, ACCESS_CONTRACTS_URI, AccessContractModel.class);
    }

    @Override
    public RequestResponse<IngestContractModel> findIngestContractsByID(String documentId) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        ParametersChecker.checkParameter((String)"The input documentId json is mandatory", (String[])new String[]{documentId});
        return this.findContractByID(documentId, INGEST_CONTRACTS_URI, IngestContractModel.class);
    }

    @Override
    public RequestResponse<ManagementContractModel> findManagementContractsByID(String documentId) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        ParametersChecker.checkParameter((String)"The input documentId json is mandatory", (String[])new String[]{documentId});
        return this.findContractByID(documentId, MANAGEMENT_CONTRACTS_URI, ManagementContractModel.class);
    }

    private <T extends AbstractContractModel> RequestResponse<T> findContractByID(String documentId, String uri, Class<T> clasz) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        RequestResponseOK requestResponseOK;
        block11: {
            JsonNode queryDsl;
            try {
                queryDsl = this.getIdentifierQuery("Identifier", documentId);
            }
            catch (InvalidCreateOperationException e) {
                throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            }
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(uri).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                RequestResponseOK resp = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response, clasz);
                if (resp.getResults() == null || resp.getResults().isEmpty()) {
                    throw new ReferentialNotFoundException("Contract not found with id: " + documentId);
                }
                requestResponseOK = resp;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponse<AccessContractModel> updateAccessContract(String id, JsonNode queryDsl) throws AdminManagementClientServerException, ReferentialNotFoundException {
        ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
        return this.updateContract(id, queryDsl, UPDATE_ACCESS_CONTRACT_URI, AccessContractModel.class);
    }

    @Override
    public RequestResponse<IngestContractModel> updateIngestContract(String id, JsonNode queryDsl) throws AdminManagementClientServerException, ReferentialNotFoundException {
        ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
        return this.updateContract(id, queryDsl, UPDATE_INGEST_CONTRACT_URI, IngestContractModel.class);
    }

    @Override
    public RequestResponse<ManagementContractModel> updateManagementContract(String id, JsonNode queryDsl) throws AdminManagementClientServerException, ReferentialNotFoundException {
        ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
        return this.updateContract(id, queryDsl, UPDATE_MANAGEMENT_CONTRACT_URI, ManagementContractModel.class);
    }

    private <T extends AbstractContractModel> RequestResponse<T> updateContract(String id, JsonNode queryDsl, String updateUri, Class<T> clasz) throws AdminManagementClientServerException, ReferentialNotFoundException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(updateUri + id).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, clasz);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException e) {
                    throw new AdminManagementClientBadRequestException((Throwable)e);
                }
                catch (AccessUnauthorizedException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    public RequestResponse<ProfileModel> createProfiles(List<ProfileModel> profileModelList) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The input profile json is mandatory", (Object[])new Object[]{profileModelList});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(PROFILE_URI).withBody(profileModelList).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ProfileModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ProfileModel> importProfileFile(String profileMetadataId, InputStream stream) throws ReferentialException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The input profile stream is mandatory", (Object[])new Object[]{stream});
            ParametersChecker.checkParameter((String)profileMetadataId, (String[])new String[]{"The profile id is mandatory"});
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(UPDATE_PROFIL_URI + profileMetadataId).withBody((Object)stream).withOctetContentType().withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ProfileModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Response downloadProfileFile(String profileMetadataId) throws AdminManagementClientServerException, ProfileNotFoundException {
        ParametersChecker.checkParameter((String)"Profile id is required", (String[])new String[]{profileMetadataId});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath(UPDATE_PROFIL_URI + profileMetadataId).withOctetAccept();
        Response response = null;
        Response.Status status = null;
        try {
            response = this.make(request);
            status = Response.Status.fromStatusCode((int)response.getStatus());
            if (status == Response.Status.OK) {
                Response response2 = response;
                return response2;
            }
            try {
                Object msgErr = "Error while download profile file : " + profileMetadataId;
                RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (!requestResponse.isOk()) {
                    VitamError error = (VitamError)requestResponse;
                    msgErr = error.getDescription();
                }
                throw new ProfileNotFoundException((String)msgErr);
            }
            catch (VitamClientInternalException e) {
                throw new AdminManagementClientServerException(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase(), (Throwable)e);
            }
        }
        finally {
            if (status != Response.Status.OK) {
                this.consumeAnyEntityAndClose(response);
            }
        }
    }

    @Override
    public RequestResponse<ProfileModel> findProfiles(JsonNode queryDsl) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(PROFILE_URI).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ProfileModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException | ReferentialNotFoundException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ProfileModel> findProfilesByID(String documentId) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        RequestResponseOK requestResponseOK;
        block11: {
            JsonNode queryDsl;
            ParametersChecker.checkParameter((String)"The input documentId json is mandatory", (String[])new String[]{documentId});
            try {
                queryDsl = this.getIdentifierQuery("Identifier", documentId);
            }
            catch (InvalidCreateOperationException e) {
                LOGGER.error("unable to create query", (Throwable)e);
                throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            }
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(PROFILE_URI).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                RequestResponseOK resp = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response, ProfileModel.class);
                if (resp.getResults() == null || resp.getResults().isEmpty()) {
                    throw new ReferentialNotFoundException("Profile not found with id: " + documentId);
                }
                requestResponseOK = resp;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponse<ProfileModel> updateProfile(String id, JsonNode queryDsl) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(UPDATE_PROFIL_URI + id).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = (RequestResponse)JsonHandler.getFromString((String)((String)response.readEntity(String.class)), RequestResponseOK.class, ProfileModel.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException e) {
                    throw new AdminManagementClientBadRequestException((Throwable)e);
                }
                catch (AccessUnauthorizedException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    public RequestResponse<ArchiveUnitProfileModel> createArchiveUnitProfiles(List<ArchiveUnitProfileModel> profileModelList) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The input archive unit profile json is mandatory", (Object[])new Object[]{profileModelList});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(ARCHIVE_UNIT_PROFILE_URI).withBody(profileModelList).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ArchiveUnitProfileModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ArchiveUnitProfileModel> findArchiveUnitProfiles(JsonNode queryDsl) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(ARCHIVE_UNIT_PROFILE_URI).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ArchiveUnitProfileModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ArchiveUnitProfileModel> findArchiveUnitProfilesByID(String documentId) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        RequestResponseOK requestResponseOK;
        block11: {
            JsonNode queryDsl;
            ParametersChecker.checkParameter((String)"The input documentId json is mandatory", (String[])new String[]{documentId});
            try {
                queryDsl = this.getIdentifierQuery("Identifier", documentId);
            }
            catch (InvalidCreateOperationException e) {
                throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            }
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(ARCHIVE_UNIT_PROFILE_URI).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                RequestResponseOK resp = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response, ArchiveUnitProfileModel.class);
                if (resp.getResults() == null || resp.getResults().isEmpty()) {
                    throw new ReferentialNotFoundException("ArchiveUnitProfile not found with id: " + documentId);
                }
                requestResponseOK = resp;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponse<ArchiveUnitProfileModel> updateArchiveUnitProfile(String id, JsonNode queryDsl) throws AdminManagementClientServerException, ReferentialNotFoundException {
        RequestResponseOK requestResponseOK;
        block8: {
            ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(UPDATE_ARCHIVE_UNIT_PROFILE_URI + id).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponseOK = new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public Response.Status importContexts(List<ContextModel> contextModelList) throws ReferentialException {
        Response.Status status;
        block8: {
            ParametersChecker.checkParameter((String)"The input ingest contracts json is mandatory", (Object[])new Object[]{contextModelList});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(CONTEXT_URI).withBody(contextModelList).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                status = Response.Status.fromStatusCode((int)response.getStatus());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return status;
    }

    @Override
    public RequestResponse<ContextModel> updateContext(String id, JsonNode queryDsl) throws AdminManagementClientServerException, ReferentialNotFoundException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(UPDATE_CONTEXT_URI + id).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = (RequestResponse)JsonHandler.getFromString((String)((String)response.readEntity(String.class)), RequestResponseOK.class, ContextModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | InvalidParseOperationException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ContextModel> findContexts(JsonNode queryDsl) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(CONTEXT_URI).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ContextModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ContextModel> findContextById(String id) throws InvalidParseOperationException, ReferentialNotFoundException, AdminManagementClientServerException {
        RequestResponseOK requestResponseOK;
        block11: {
            JsonNode queryDsl;
            ParametersChecker.checkParameter((String)"The input documentId json is mandatory", (String[])new String[]{id});
            try {
                queryDsl = this.getIdentifierQuery("Identifier", id);
            }
            catch (InvalidCreateOperationException e) {
                throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            }
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(CONTEXT_URI).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                RequestResponseOK resp = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response, ContextModel.class);
                if (resp.getResults() == null || resp.getResults().isEmpty()) {
                    throw new ReferentialNotFoundException("Context not found with id: " + id);
                }
                requestResponseOK = resp;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponse<Boolean> securityProfileIsUsedInContexts(String securityProfileId) throws InvalidParseOperationException, AdminManagementClientServerException {
        ParametersChecker.checkParameter((String)"The input security profile Id json is mandatory", (String[])new String[]{securityProfileId});
        try {
            JsonNode queryDsl = this.getIdentifierQuery("SecurityProfile", securityProfileId);
            RequestResponse<ContextModel> requestResponse = this.findContexts(queryDsl);
            List results = ((RequestResponseOK)requestResponse).getResults();
            RequestResponseOK result = new RequestResponseOK();
            if (results.isEmpty()) {
                result.addResult((Object)false);
                return result;
            }
            result.addResult((Object)true);
            return result;
        }
        catch (InvalidCreateOperationException e) {
            LOGGER.error("unable to create query", (Throwable)e);
            throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
        }
    }

    @Override
    public RequestResponse<JsonNode> launchAuditWorkflow(AuditOptions options, boolean checkAccessContract) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The options are mandatory", (Object[])new Object[]{options});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(AUDIT_URI).withHeader("Check-Access-Contract", (Object)checkAccessContract).withBody((Object)options).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> launchReferentialAudit(AuditReferentialOptions auditReferentialOptions) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(REFERENTIAL_AUDIT_URI).withBody((Object)auditReferentialOptions).withJsonContentType().withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> launchRuleAudit(List<Integer> tenants) throws AdminManagementClientServerException, InvalidParseOperationException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(AUDIT_RULE_URI).withBody((Object)JsonHandler.toJsonNode(tenants)).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Response.Status importSecurityProfiles(List<SecurityProfileModel> securityProfileModelList) throws AdminManagementClientServerException {
        Response.Status status;
        block8: {
            ParametersChecker.checkParameter((String)"The input security profiles json is mandatory", (Object[])new Object[]{securityProfileModelList});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(SECURITY_PROFILES_URI).withBody(securityProfileModelList).withJson();
            Response response = this.make(request);
            try {
                this.checkCreation(response);
                status = Response.Status.fromStatusCode((int)response.getStatus());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return status;
    }

    @Override
    public RequestResponse<SecurityProfileModel> findSecurityProfiles(JsonNode queryDsl) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(SECURITY_PROFILES_URI).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, SecurityProfileModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<SecurityProfileModel> findSecurityProfileByIdentifier(String identifier) throws AdminManagementClientServerException, ReferentialNotFoundException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The input identifier is mandatory", (String[])new String[]{identifier});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/securityprofiles/" + identifier).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, SecurityProfileModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<SecurityProfileModel> updateSecurityProfile(String identifier, JsonNode queryDsl) throws AdminManagementClientServerException, ReferentialNotFoundException {
        RequestResponseOK requestResponseOK;
        block9: {
            ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{queryDsl});
            ParametersChecker.checkParameter((String)"Tidentifier is mandatory", (String[])new String[]{identifier});
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath("/securityprofiles/" + identifier).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponseOK = new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException e) {
                    throw new AdminManagementClientBadRequestException((Throwable)e);
                }
                catch (AccessUnauthorizedException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponse<ReindexationResult> launchReindexation(JsonNode options) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The options are mandatory", (Object[])new Object[]{options});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(REINDEX_URI).withBody((Object)options).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ReindexationResult.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ReindexationResult> switchIndexes(JsonNode options) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The options are mandatory", (Object[])new Object[]{options});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(ALIASES_URI).withBody((Object)options).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ReindexationResult.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> evidenceAudit(JsonNode query) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The query is mandatory", (Object[])new Object[]{query});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(EVIDENCE_AUDIT_URI).withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> rectificationAudit(String operationId) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(RECTIFICATION_AUDIT).withBody((Object)operationId).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> exportProbativeValue(ProbativeValueRequest probativeValueRequest) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The query is mandatory", (Object[])new Object[]{probativeValueRequest});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(PROBATIVE_VALUE_URI).withBody((Object)probativeValueRequest).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    public RequestResponse<OntologyModel> importOntologies(boolean forceUpdate, List<OntologyModel> ontologyModelList) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The ontology json is mandatory", (Object[])new Object[]{ontologyModelList});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(ONTOLOGY_URI).withHeader("Force-Update", (Object)forceUpdate).withBody(ontologyModelList).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, OntologyModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<OntologyModel> findOntologies(JsonNode query) {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The input queryDsl json is mandatory", (Object[])new Object[]{query});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(ONTOLOGY_URI).withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, OntologyModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new VitamRuntimeException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<OntologyModel> findOntologyByID(String documentId) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        RequestResponse requestResponse;
        block10: {
            JsonNode queryDsl;
            ParametersChecker.checkParameter((String)"The input documentId json is mandatory", (String[])new String[]{documentId});
            try {
                queryDsl = this.getIdentifierQuery("Identifier", documentId);
            }
            catch (InvalidCreateOperationException e) {
                throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            }
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(ONTOLOGY_URI).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = (RequestResponse)JsonHandler.getFromString((String)((String)response.readEntity(String.class)), RequestResponseOK.class, OntologyModel.class);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    private JsonNode getIdentifierQuery(String identifierFiled, String documentId) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectParserSingle parser = new SelectParserSingle();
        Select select = new Select();
        parser.parse((JsonNode)select.getFinalSelect());
        parser.addCondition((Query)QueryHelper.eq((String)identifierFiled, (String)documentId));
        return parser.getRequest().getFinalSelect();
    }

    public RequestResponse<ProcessPause> forcePause(ProcessPause info) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The input ProcessPause json is mandatory", (Object[])new Object[]{info});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(FORCE_PAUSE_URI).withBody((Object)info).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ProcessPause.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    public RequestResponse<ProcessPause> removeForcePause(ProcessPause info) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"The input ProcessPause json is mandatory", (Object[])new Object[]{info});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(REMOVE_FORCE_PAUSE_URI).withBody((Object)info).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ProcessPause.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<AccessionRegisterSymbolic> createAccessionRegisterSymbolic(List<Integer> tenants) throws AdminManagementClientServerException, InvalidParseOperationException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"Tenant is mandatory.", (Object[])new Object[]{tenants});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("accession-register/symbolic").withBody((Object)JsonHandler.toJsonNode(tenants)).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, AccessionRegisterSymbolic.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<AccessionRegisterSymbolicModel> getAccessionRegisterSymbolic(Integer tenant, JsonNode queryDsl) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)"Tenant is mandatory.", (Object[])new Object[]{tenant});
            ParametersChecker.checkParameter((String)"QueryDsl is mandatory.", (Object[])new Object[]{tenant});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("accession-register/symbolic").withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, AccessionRegisterSymbolicModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<GriffinModel> importGriffins(List<GriffinModel> griffinModelList) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)"griffin file  is mandatory", (Object[])new Object[]{griffinModelList});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/importGriffins").withBody(griffinModelList).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, GriffinModel.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException | ReferentialNotFoundException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
                catch (BadRequestException e) {
                    throw new AdminManagementClientBadRequestException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<PreservationScenarioModel> importPreservationScenarios(List<PreservationScenarioModel> preservationScenarioModels) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)"PreservationScenario file  is mandatory", (Object[])new Object[]{preservationScenarioModels});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/importPreservationScenarios").withBody(preservationScenarioModels).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, PreservationScenarioModel.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | ForbiddenClientException | VitamClientInternalException | DatabaseConflictException | ReferentialNotFoundException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
                catch (BadRequestException e) {
                    throw new AdminManagementClientBadRequestException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<GriffinModel> findGriffin(JsonNode queryDsl) throws AdminManagementClientServerException, InvalidParseOperationException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/griffin").withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                String entity = (String)response.readEntity(String.class);
                requestResponse = (RequestResponse)JsonHandler.getFromString((String)entity, RequestResponseOK.class, GriffinModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<GriffinModel> findGriffinByID(String id) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        ParametersChecker.checkParameter((String)"The input documentId json is mandatory", (String[])new String[]{id});
        try {
            JsonNode queryDsl = this.getIdentifierQuery("Identifier", id);
            RequestResponse<GriffinModel> requestResponse = this.findGriffin(queryDsl);
            if (((RequestResponseOK)requestResponse).getResults() == null || ((RequestResponseOK)requestResponse).getResults().isEmpty()) {
                throw new ReferentialNotFoundException("Griffin not found ");
            }
            return requestResponse;
        }
        catch (InvalidCreateOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public RequestResponse<PreservationScenarioModel> findPreservationByID(String id) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        ParametersChecker.checkParameter((String)"The input documentId json is mandatory", (String[])new String[]{id});
        try {
            JsonNode queryDsl = this.getIdentifierQuery("Identifier", id);
            RequestResponse<PreservationScenarioModel> requestResponseOK = this.findPreservation(queryDsl);
            if (((RequestResponseOK)requestResponseOK).getResults() == null || ((RequestResponseOK)requestResponseOK).isEmpty()) {
                throw new ReferentialNotFoundException(String.format("Preservation Scenario not found %s", id));
            }
            return requestResponseOK;
        }
        catch (InvalidCreateOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public RequestResponse<PreservationScenarioModel> findPreservation(JsonNode queryDsl) throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/preservationScenario").withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, PreservationScenarioModel.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Response.Status createExternalOperation(LogbookOperationParameters logbookOperationparams) throws AdminManagementClientServerException, BadRequestException, LogbookClientAlreadyExistsException {
        Response.Status status;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(CREATE_EXTERNAL_OPERATION_URI).withBody((Object)logbookOperationparams).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                status = Response.Status.fromStatusCode((int)response.getStatus());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | ForbiddenClientException | VitamClientInternalException | ReferentialNotFoundException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
                catch (DatabaseConflictException e) {
                    throw new LogbookClientAlreadyExistsException((Throwable)e);
                }
            }
            response.close();
        }
        return status;
    }

    @Override
    public RequestResponse<JsonNode> findJobs() throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/jobs").withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public void reconstructCollection(String collection) throws AdminManagementClientServerException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath(RECONSTRUCTION_URI + collection).withJson());){
            this.check(response);
        }
        catch (VitamClientInternalException e) {
            throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
        }
    }

    @Override
    public void reconstructAccessionRegister(List<ReconstructionRequestItem> reconstructionItems) throws AdminManagementClientServerException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath(RECONSTRUCTION_ACCESSION_REGISTER).withBody(reconstructionItems).withJson());){
            this.check(response);
        }
        catch (VitamClientInternalException e) {
            throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
        }
    }

    @Override
    public RequestResponse<SchemaResponse> getUnitSchema() throws AdminManagementClientServerException {
        RequestResponseOK requestResponseOK;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(SCHEMA_UNIT_URI).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponseOK = new RequestResponseOK().addAllResults((List)JsonHandler.getFromInputStreamAsTypeReference((InputStream)((InputStream)response.readEntity(InputStream.class)), (TypeReference)new TypeReference<List<SchemaResponse>>(this){})).setHttpCode(Response.Status.OK.getStatusCode());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidFormatException | InvalidParseOperationException | VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponse<CombinedSchemaModel> getArchiveUnitProfileSchema(String id) throws AdminManagementClientServerException {
        RequestResponseOK requestResponseOK;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(SCHEMA_ARCHIVE_UNIT_PROFILE_URI.replace("{id}", id)).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponseOK = new RequestResponseOK().addAllResults((List)JsonHandler.getFromInputStreamAsTypeReference((InputStream)((InputStream)response.readEntity(InputStream.class)), (TypeReference)new TypeReference<List<CombinedSchemaModel>>(this){})).setHttpCode(Response.Status.OK.getStatusCode());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidFormatException | InvalidParseOperationException | VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public Response.Status importUnitExternalSchema(List<SchemaInputModel> externalSchemaInputList) throws AdminManagementClientServerException {
        Response.Status status;
        block8: {
            ParametersChecker.checkParameter((String)"The unit external schema json is mandatory", (Object[])new Object[]{externalSchemaInputList});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(SCHEMA_UNIT_URI).withBody(externalSchemaInputList).withJson();
            Response response = this.make(request);
            try {
                this.checkCreation(response);
                status = Response.Status.fromStatusCode((int)response.getStatus());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return status;
    }

    @Override
    public Response.Status deleteUnitExternalSchemas(List<String> paths) throws InvalidParseOperationException, AdminManagementClientServerException {
        Response.Status status;
        block8: {
            ParametersChecker.checkParameter((String)"The unit external schema paths list is mandatory", (Object[])new Object[]{paths});
            VitamRequestBuilder request = VitamRequestBuilder.delete().withPath(SCHEMA_UNIT_URI).withBody(paths).withJson();
            Response response = this.make(request);
            try {
                this.checkCreation(response);
                status = Response.Status.fromStatusCode((int)response.getStatus());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return status;
    }

    @Override
    public RequestResponse<SchemaResponse> getObjectGroupSchema() throws AdminManagementClientServerException {
        RequestResponseOK requestResponseOK;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(SCHEMA_OBJECTGROUP_URI).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponseOK = new RequestResponseOK().addAllResults((List)JsonHandler.getFromInputStreamAsTypeReference((InputStream)((InputStream)response.readEntity(InputStream.class)), (TypeReference)new TypeReference<List<SchemaResponse>>(this){})).setHttpCode(Response.Status.OK.getStatusCode());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidFormatException | InvalidParseOperationException | VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponse<PublicConfiguration> getPublicConfiguration() throws AdminManagementClientServerException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(CONFIGURATION_URL).withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, PublicConfiguration.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AdminManagementClientServerException(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    private void check(Response response) throws VitamClientInternalException {
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        throw new VitamClientInternalException(String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
    }

    private void checkCreation(Response response) throws VitamClientInternalException, AdminManagementClientBadRequestException {
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        if (status == Response.Status.BAD_REQUEST) {
            String reason = response.hasEntity() ? (String)response.readEntity(String.class) : Response.Status.BAD_REQUEST.getReasonPhrase();
            throw new AdminManagementClientBadRequestException(reason);
        }
        throw new VitamClientInternalException(String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
    }

    private void checkWithSpecificException(Response response) throws BadRequestException, VitamClientInternalException, ReferentialNotFoundException, AccessUnauthorizedException, ForbiddenClientException, DatabaseConflictException {
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        switch (status) {
            case NOT_FOUND: {
                throw new ReferentialNotFoundException(status.getReasonPhrase());
            }
            case BAD_REQUEST: {
                String reason = response.hasEntity() ? (String)response.readEntity(String.class) : Response.Status.BAD_REQUEST.getReasonPhrase();
                throw new BadRequestException(reason);
            }
            case UNAUTHORIZED: {
                throw new AccessUnauthorizedException("Contract not found ");
            }
            case FORBIDDEN: {
                String reason = response.hasEntity() ? (String)response.readEntity(String.class) : Response.Status.BAD_REQUEST.getReasonPhrase();
                throw new ForbiddenClientException(reason);
            }
            case CONFLICT: {
                throw new DatabaseConflictException(Response.Status.CONFLICT.getReasonPhrase());
            }
        }
        throw new VitamClientInternalException(String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), status.getReasonPhrase()));
    }
}

