/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.AbstractMockClient;
import fr.gouv.vitam.common.client.ClientMockResultHelper;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitam.common.model.ProcessPause;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterStatus;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSummaryModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSymbolicModel;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.model.administration.CombinedSchemaModel;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.FileFormatModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.RegisterValueDetailModel;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitam.common.model.administration.preservation.GriffinModel;
import fr.gouv.vitam.common.model.administration.preservation.PreservationScenarioModel;
import fr.gouv.vitam.common.model.administration.profile.ProfileModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaInputModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.common.model.audit.AuditReferentialOptions;
import fr.gouv.vitam.common.model.configuration.PublicConfiguration;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.common.ReconstructionRequestItem;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.DatabaseConflictException;
import fr.gouv.vitam.functional.administration.common.exception.FileFormatException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesException;
import fr.gouv.vitam.functional.administration.common.exception.ProfileNotFoundException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.functional.administration.common.server.AccessionRegisterSymbolic;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.input.NullInputStream;

public class AdminManagementClientMock
extends AbstractMockClient
implements AdminManagementClient {
    private static final String STREAM_IS_A_MANDATORY_PARAMETER = "stream is a mandatory parameter";
    private static final String CANNOT_BE_USED = "Cannot be used";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminManagementClientMock.class);

    @Override
    public Response checkFormat(InputStream stream) throws FileFormatException {
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{stream});
        LOGGER.debug("Check file format request:");
        StreamUtils.closeSilently((InputStream)stream);
        return Response.ok((Object)new NullInputStream(0L)).build();
    }

    @Override
    public Response.Status importFormat(InputStream stream, String filename) throws FileFormatException {
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{stream});
        LOGGER.debug("Import file format request:");
        StreamUtils.closeSilently((InputStream)stream);
        return Response.Status.CREATED;
    }

    @Override
    public JsonNode getFormatByID(String id) throws InvalidParseOperationException {
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (String[])new String[]{id});
        LOGGER.debug("get format by id request:");
        return ClientMockResultHelper.getFormat().toJsonNode();
    }

    @Override
    public RequestResponse<FileFormatModel> getFormats(JsonNode query) throws FileFormatException, InvalidParseOperationException, IOException {
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{query});
        LOGGER.debug("get document format request:");
        return ClientMockResultHelper.getFormatList();
    }

    @Override
    public Response checkRulesFile(InputStream stream) throws FileRulesException {
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{stream});
        LOGGER.debug("Check file rules  request:");
        StreamUtils.closeSilently((InputStream)stream);
        return new AbstractMockClient.FakeInboundResponse(Response.Status.OK, (Object)StreamUtils.toInputStream((String)"Vitam Test"), MediaType.APPLICATION_OCTET_STREAM_TYPE, null);
    }

    @Override
    public Response checkAgenciesFile(InputStream stream) {
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{stream});
        LOGGER.debug("Check file agencies  request:");
        StreamUtils.closeSilently((InputStream)stream);
        return new AbstractMockClient.FakeInboundResponse(Response.Status.OK, (Object)StreamUtils.toInputStream((String)"Vitam Test"), MediaType.APPLICATION_OCTET_STREAM_TYPE, null);
    }

    @Override
    public Response.Status importRulesFile(InputStream stream, String filename) throws ReferentialException, DatabaseConflictException {
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{stream});
        LOGGER.debug("import file Rules request:");
        StreamUtils.closeSilently((InputStream)stream);
        return Response.Status.CREATED;
    }

    @Override
    public Response.Status importAgenciesFile(InputStream stream, String filename) throws ReferentialException {
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{stream});
        LOGGER.debug("import file Agencies request:");
        StreamUtils.closeSilently((InputStream)stream);
        return Response.Status.CREATED;
    }

    @Override
    public JsonNode getAgencies(JsonNode query) throws InvalidParseOperationException {
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{query});
        LOGGER.debug("get document rules request:");
        return ClientMockResultHelper.getAgency().toJsonNode();
    }

    @Override
    public JsonNode getRuleByID(String id) throws FileRulesException, InvalidParseOperationException {
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (String[])new String[]{id});
        LOGGER.debug("get rule by id request:");
        return ClientMockResultHelper.getRuleList((String)id).toJsonNode();
    }

    @Override
    public RequestResponse<AgenciesModel> getAgencyById(String id) throws InvalidParseOperationException {
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (String[])new String[]{id});
        LOGGER.debug("get agency by id request:");
        return ClientMockResultHelper.getAgenciesList();
    }

    @Override
    public JsonNode getRules(JsonNode query) throws FileRulesException, InvalidParseOperationException, IOException {
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{query});
        LOGGER.debug("get document rules request:");
        return ClientMockResultHelper.getRule().toJsonNode();
    }

    public RequestResponse createOrUpdateAccessionRegister(AccessionRegisterDetailModel register) {
        String result;
        try {
            result = JsonHandler.writeAsString((Object)register);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Cannot serialize parameters", (Throwable)e);
            return new RequestResponseOK().setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        LOGGER.info("AccessionRegister: " + result);
        return new RequestResponseOK().setHttpCode(Response.Status.CREATED.getStatusCode());
    }

    public RequestResponse getAccessionRegister(JsonNode query) throws InvalidParseOperationException {
        AccessionRegisterSummaryModel model = new AccessionRegisterSummaryModel();
        RegisterValueDetailModel totalObjectsGroups = new RegisterValueDetailModel();
        RegisterValueDetailModel totalUnits = new RegisterValueDetailModel();
        RegisterValueDetailModel totalObjects = new RegisterValueDetailModel();
        RegisterValueDetailModel objectSize = new RegisterValueDetailModel();
        LOGGER.debug("get document Register Fund request:");
        model.setId("aefaaaaaaaaam7mxaa2gyakygejizayaaaaq").setTenant(Integer.valueOf(0)).setOriginatingAgency("FRAN_NP_005568");
        totalObjects.setIngested(12L).setDeleted(0L).setRemained(12L);
        model.setTotalObjects(totalObjects);
        totalObjectsGroups.setIngested(3L).setDeleted(0L).setRemained(3L);
        model.setTotalObjectsGroups(totalObjectsGroups);
        totalUnits.setIngested(3L).setDeleted(0L).setRemained(3L);
        model.setTotalUnits(totalUnits);
        objectSize.setIngested(1035126L).setDeleted(0L).setRemained(1035126L);
        model.setObjectSize(objectSize).setCreationDate("2016-11-04T20:40:49.030");
        return ClientMockResultHelper.createResponse((Object)model);
    }

    public RequestResponse getAccessionRegisterDetail(String originatingAgency, JsonNode query) throws InvalidParseOperationException {
        RegisterValueDetailModel totalObjectsGroups = new RegisterValueDetailModel().setIngested(1L).setRemained(1L);
        RegisterValueDetailModel totalUnits = new RegisterValueDetailModel().setIngested(1L).setRemained(1L);
        RegisterValueDetailModel totalObjects = new RegisterValueDetailModel().setIngested(4L).setRemained(4L);
        RegisterValueDetailModel objectSize = new RegisterValueDetailModel().setIngested(345042L).setRemained(345042L);
        ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{query});
        LOGGER.debug("get document Accession Register request:");
        AccessionRegisterDetailModel detailBuider = new AccessionRegisterDetailModel();
        detailBuider.setId(originatingAgency).setTenant(Integer.valueOf(0)).setOpc("Identifier").setOpi("OP_GROUP").setOriginatingAgency("FRAN_NP_005568").setSubmissionAgency("FRAN_NP_005061").setArchivalAgreement("Something").setEndDate("2016-11-04T21:40:47.912+01:00").setStartDate("2016-11-04T21:40:47.912+01:00").setStatus(AccessionRegisterStatus.STORED_AND_COMPLETED).setTotalObjects(totalObjects).setTotalObjectsGroups(totalObjectsGroups).setTotalUnits(totalUnits).setObjectSize(objectSize);
        return ClientMockResultHelper.createResponse((Object)detailBuider);
    }

    @Override
    public RequestResponse<AccessionRegisterDetailModel> getAccessionRegisterDetail(JsonNode query) {
        throw new IllegalStateException("No mocks in production");
    }

    @Override
    public Response.Status importIngestContracts(List<IngestContractModel> ingestContractModelList) {
        LOGGER.debug("import Ingest contracts request ");
        return Response.Status.OK;
    }

    @Override
    public Response.Status importAccessContracts(List<AccessContractModel> accessContractModelList) throws InvalidParseOperationException, AdminManagementClientServerException {
        LOGGER.debug("import access contracts request ");
        return Response.Status.OK;
    }

    @Override
    public Response.Status importManagementContracts(List<ManagementContractModel> accessContractModelList) throws InvalidParseOperationException, AdminManagementClientServerException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    public RequestResponse findAccessContracts(JsonNode queryDsl) throws InvalidParseOperationException, AdminManagementClientServerException {
        LOGGER.debug("find access contracts request ");
        if (VitamThreadUtils.getVitamSession().getTenantId() == null) {
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(0));
        }
        String identifier = queryDsl.findPath("Identifier").asText();
        return ClientMockResultHelper.createResponse((Object)ClientMockResultHelper.ACCESS_CONTRACTS.stream().filter(ac -> ac.getIdentifier().equals(identifier)).findFirst().orElse(ClientMockResultHelper.DEFAULT_ACCESS_CONTRACT));
    }

    public RequestResponse findAccessContractsByID(String documentId) throws InvalidParseOperationException {
        LOGGER.debug("find access contracts by id request ");
        return ClientMockResultHelper.getAccessContractOrDefault((String)documentId);
    }

    @Override
    public RequestResponse<IngestContractModel> findIngestContracts(JsonNode query) throws InvalidParseOperationException, AdminManagementClientServerException {
        LOGGER.debug("find ingest contracts request");
        IngestContractModel ingestContract = (IngestContractModel)JsonHandler.getFromString((String)"{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq\", \"_tenant\":\"0\", \"Name\":\"ArchivalAgreement0\", \"Identifier\":\"ArchivalAgreement0\", \"Description\":\"DESCRIPTION D'UN CONTRAT\", \"Status\":\"ACTIVE\", \"CreationDate\":\"2016-11-02\", \"ArchiveProfiles\":[\"FakeProfile\"], \"LastUpdate\":\"2016-11-02\", \"ActivationDate\":\"2016-11-02\", \"DeactivationDate\":\"2016-11-02\"}", IngestContractModel.class);
        return ClientMockResultHelper.createResponse((Object)ingestContract);
    }

    @Override
    public RequestResponse<IngestContractModel> findIngestContractsByID(String id) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        LOGGER.debug("find ingest contracts by id request ");
        return ClientMockResultHelper.getIngestContracts();
    }

    public RequestResponse findManagementContracts(JsonNode queryDsl) throws InvalidParseOperationException, AdminManagementClientServerException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    public RequestResponse findManagementContractsByID(String documentId) throws InvalidParseOperationException, AdminManagementClientServerException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public RequestResponse createProfiles(List<ProfileModel> profileModelList) throws InvalidParseOperationException, AdminManagementClientServerException {
        return new RequestResponseOK().setHttpCode(Response.Status.CREATED.getStatusCode());
    }

    public RequestResponse importProfileFile(String profileMetadataId, InputStream stream) throws ReferentialException, DatabaseConflictException {
        return new RequestResponseOK().setHttpCode(Response.Status.CREATED.getStatusCode());
    }

    @Override
    public Response downloadProfileFile(String profileMetadataId) throws AdminManagementClientServerException, ProfileNotFoundException {
        return new AbstractMockClient.FakeInboundResponse(Response.Status.OK, (Object)StreamUtils.toInputStream((String)"Vitam Test"), MediaType.APPLICATION_OCTET_STREAM_TYPE, null);
    }

    @Override
    public RequestResponse<ProfileModel> findProfiles(JsonNode query) throws InvalidParseOperationException, AdminManagementClientServerException {
        LOGGER.debug("find profiles by id request ");
        return ClientMockResultHelper.getProfiles((int)Response.Status.OK.getStatusCode());
    }

    @Override
    public RequestResponse<ProfileModel> findProfilesByID(String id) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        LOGGER.debug("find profiles by id request ");
        RequestResponse var = ClientMockResultHelper.getProfiles((int)Response.Status.OK.getStatusCode());
        RequestResponseOK onr = (RequestResponseOK)var;
        ObjectNode on = (ObjectNode)onr.getResults().iterator().next();
        JsonNode idin = on.get("_id");
        if (null == idin || !idin.asText().equals(id)) {
            throw new ReferentialNotFoundException("No profile found with id " + id);
        }
        return var;
    }

    @Override
    public RequestResponse createArchiveUnitProfiles(List<ArchiveUnitProfileModel> archiveUnitProfileModelList) throws InvalidParseOperationException, AdminManagementClientServerException {
        return new RequestResponseOK().setHttpCode(Response.Status.CREATED.getStatusCode());
    }

    @Override
    public RequestResponse<ArchiveUnitProfileModel> findArchiveUnitProfiles(JsonNode query) throws InvalidParseOperationException, AdminManagementClientServerException {
        LOGGER.debug("find archive unit profiles");
        return ClientMockResultHelper.getArchiveUnitProfiles((int)Response.Status.OK.getStatusCode());
    }

    @Override
    public RequestResponse<ArchiveUnitProfileModel> findArchiveUnitProfilesByID(String requestedId) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        LOGGER.debug("find archive unit profile by id: " + requestedId);
        RequestResponse responses = ClientMockResultHelper.getArchiveUnitProfiles((int)Response.Status.OK.getStatusCode());
        RequestResponseOK responcesIterator = (RequestResponseOK)responses;
        ObjectNode firstObject = (ObjectNode)responcesIterator.getResults().iterator().next();
        JsonNode idFirst = firstObject.get("_id");
        if (null == idFirst || !idFirst.asText().equals(requestedId)) {
            throw new ReferentialNotFoundException("No archive unit profile found with id " + requestedId);
        }
        return responses;
    }

    @Override
    public RequestResponse<ArchiveUnitProfileModel> updateArchiveUnitProfile(String id, JsonNode queryDsl) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        ArchiveUnitProfileModel model = (ArchiveUnitProfileModel)JsonHandler.getFromString((String)"{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq\", \"_tenant\":0, \"Identifier\":\"FAKE_IDENTIFIER\", \"Name\":\"Archive Unit Ptofile\", \"Description\":\"Description d'un document type\", \"Status\":\"ACTIVE\", \"CreationDate\":\"2016-11-02\", \"LastUpdate\":\"2016-11-02\", \"ActivationDate\":\"2016-11-02\", \"DeactivationDate\":\"2016-11-02\"}", ArchiveUnitProfileModel.class);
        return ClientMockResultHelper.createResponse((Object)model).setHttpCode(200);
    }

    @Override
    public RequestResponse<AccessContractModel> updateAccessContract(String id, JsonNode queryDsl) throws InvalidParseOperationException, AdminManagementClientServerException {
        LOGGER.debug("uddate access contract");
        return new RequestResponseOK();
    }

    @Override
    public RequestResponse<IngestContractModel> updateIngestContract(String id, JsonNode queryDsl) throws InvalidParseOperationException, AdminManagementClientServerException {
        LOGGER.debug("uddate ingest contract");
        return new RequestResponseOK();
    }

    @Override
    public RequestResponse<ManagementContractModel> updateManagementContract(String id, JsonNode queryDsl) throws InvalidParseOperationException, AdminManagementClientServerException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public Response.Status importContexts(List<ContextModel> contextModelList) throws ReferentialException {
        LOGGER.debug("import context ");
        return Response.Status.OK;
    }

    @Override
    public RequestResponse<ContextModel> updateContext(String id, JsonNode queryDsl) throws InvalidParseOperationException {
        ContextModel model = (ContextModel)JsonHandler.getFromString((String)"{\"Name\": \"My_Context_1\", \"Status\":\"ACTIVE\", \"SecurityProfile\" : \"SEC_PROFILE-000001\",\"Permissions\": [{\"_tenant\": 0,\"AccessContracts\": [],\"IngestContracts\": [\"ArchivalAgreement0\"]}]}", ContextModel.class);
        return ClientMockResultHelper.createResponse((Object)model);
    }

    @Override
    public RequestResponse<ContextModel> findContexts(JsonNode queryDsl) throws InvalidParseOperationException {
        ContextModel model = (ContextModel)JsonHandler.getFromString((String)"{\"Name\": \"My_Context_1\", \"Status\":\"ACTIVE\", \"SecurityProfile\" : \"SEC_PROFILE-000001\",\"Permissions\": [{\"_tenant\": 0,\"AccessContracts\": [],\"IngestContracts\": [\"ArchivalAgreement0\"]}]}", ContextModel.class);
        return ClientMockResultHelper.createResponse((Object)model);
    }

    @Override
    public RequestResponse<ContextModel> findContextById(String id) throws InvalidParseOperationException {
        ContextModel model = (ContextModel)JsonHandler.getFromString((String)"{\"Name\": \"My_Context_1\", \"Status\":\"ACTIVE\", \"SecurityProfile\" : \"SEC_PROFILE-000001\",\"Permissions\": [{\"_tenant\": 0,\"AccessContracts\": [],\"IngestContracts\": [\"ArchivalAgreement0\"]}]}", ContextModel.class);
        return ClientMockResultHelper.createResponse((Object)model);
    }

    @Override
    public RequestResponse<Boolean> securityProfileIsUsedInContexts(String securityProfileId) throws InvalidParseOperationException, ReferentialNotFoundException, AdminManagementClientServerException {
        RequestResponseOK response = new RequestResponseOK();
        response.addResult((Object)false);
        return response;
    }

    @Override
    public RequestResponse<JsonNode> launchAuditWorkflow(AuditOptions options, boolean checkAccessContract) throws AdminManagementClientServerException {
        return new RequestResponseOK();
    }

    @Override
    public RequestResponse<JsonNode> launchRuleAudit(List<Integer> tenants) {
        throw new IllegalStateException("Stop using mocks in production");
    }

    @Override
    public RequestResponse<JsonNode> launchReferentialAudit(AuditReferentialOptions auditReferentialOptions) {
        return new RequestResponseOK();
    }

    @Override
    public Response.Status importSecurityProfiles(List<SecurityProfileModel> securityProfileModelList) throws InvalidParseOperationException, AdminManagementClientServerException {
        LOGGER.debug("import security profiles request ");
        return Response.Status.CREATED;
    }

    public RequestResponse findSecurityProfiles(JsonNode queryDsl) throws InvalidParseOperationException {
        LOGGER.debug("find security profiles request ");
        SecurityProfileModel model = (SecurityProfileModel)JsonHandler.getFromString((String)"{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetcaaaabbbcc\",\"Identifier\": \"SEC_PROFILE-000001\",\"Name\": \"TEST_PROFILE_1\",\"FullAccess\": false,\"Permissions\": [\"permission_one:read\",\"permission_one:id:write\"]}", SecurityProfileModel.class);
        return ClientMockResultHelper.createResponse((Object)model);
    }

    public RequestResponse findSecurityProfileByIdentifier(String identifier) throws InvalidParseOperationException {
        LOGGER.debug("find security profiles by identifier request ");
        return ClientMockResultHelper.getSecurityProfiles();
    }

    @Override
    public RequestResponse<SecurityProfileModel> updateSecurityProfile(String identifier, JsonNode queryDsl) throws InvalidParseOperationException, AdminManagementClientServerException {
        SecurityProfileModel model = (SecurityProfileModel)JsonHandler.getFromString((String)"{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetcaaaabbbcc\",\"Identifier\": \"SEC_PROFILE-000001\",\"Name\": \"TEST_PROFILE_1\",\"FullAccess\": false,\"Permissions\": [\"permission_one:read\",\"permission_one:id:write\"]}", SecurityProfileModel.class);
        return ClientMockResultHelper.createResponse((Object)model);
    }

    @Override
    public RequestResponse<ProfileModel> updateProfile(String id, JsonNode queryDsl) throws InvalidParseOperationException, AdminManagementClientServerException {
        ProfileModel model = (ProfileModel)JsonHandler.getFromString((String)"{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq\", \"_tenant\":0, \"Identifier\":\"FAKE_IDENTIFIER\", \"Name\":\"Un Profile\", \"Description\":\"DESCRIPTION D'UN PROFILE\", \"Status\":\"ACTIVE\", \"Format\":\"XSD\", \"CreationDate\":\"2016-11-02\", \"LastUpdate\":\"2016-11-02\", \"ActivationDate\":\"2016-11-02\", \"DeactivationDate\":\"2016-11-02\"}", ProfileModel.class);
        return ClientMockResultHelper.createResponse((Object)model).setHttpCode(200);
    }

    @Override
    public RequestResponse<ReindexationResult> launchReindexation(JsonNode options) throws AdminManagementClientServerException {
        return new RequestResponseOK();
    }

    @Override
    public RequestResponse<ReindexationResult> switchIndexes(JsonNode options) throws AdminManagementClientServerException {
        return new RequestResponseOK();
    }

    @Override
    public RequestResponse<JsonNode> evidenceAudit(JsonNode query) throws AdminManagementClientServerException {
        return new RequestResponseOK();
    }

    @Override
    public RequestResponse<JsonNode> rectificationAudit(String operationId) {
        return new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode());
    }

    @Override
    public RequestResponse<JsonNode> exportProbativeValue(ProbativeValueRequest queryDsl) {
        return new RequestResponseOK();
    }

    @Override
    public RequestResponse importOntologies(boolean forceUpdate, List<OntologyModel> ontologyModelList) throws InvalidParseOperationException, AdminManagementClientServerException {
        return new RequestResponseOK().setHttpCode(Response.Status.CREATED.getStatusCode());
    }

    @Override
    public RequestResponse<OntologyModel> findOntologies(JsonNode query) throws InvalidParseOperationException {
        LOGGER.debug("find Ontologies");
        return ClientMockResultHelper.getOntologies((int)Response.Status.OK.getStatusCode());
    }

    @Override
    public RequestResponse<OntologyModel> findOntologyByID(String requestedId) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        LOGGER.debug("find Ontology by id: " + requestedId);
        RequestResponse responses = ClientMockResultHelper.getOntologies((int)Response.Status.OK.getStatusCode());
        RequestResponseOK responsesIterator = (RequestResponseOK)responses;
        ObjectNode firstObject = (ObjectNode)responsesIterator.getResults().iterator().next();
        JsonNode idFirst = firstObject.get("_id");
        if (null == idFirst || !idFirst.asText().equals(requestedId)) {
            throw new ReferentialNotFoundException("No ontology found with id " + requestedId);
        }
        return responses;
    }

    @Override
    public RequestResponse forcePause(ProcessPause info) {
        return new RequestResponseOK().addResult((Object)info).setHttpCode(Response.Status.OK.getStatusCode());
    }

    @Override
    public RequestResponse removeForcePause(ProcessPause info) {
        return new RequestResponseOK().addResult((Object)info).setHttpCode(Response.Status.OK.getStatusCode());
    }

    @Override
    public RequestResponse<AccessionRegisterSymbolic> createAccessionRegisterSymbolic(List<Integer> tenants) {
        throw new RuntimeException(CANNOT_BE_USED);
    }

    @Override
    public RequestResponse<AccessionRegisterSymbolicModel> getAccessionRegisterSymbolic(Integer tenant, JsonNode queryDsl) throws AdminManagementClientServerException {
        throw new RuntimeException(CANNOT_BE_USED);
    }

    public RequestResponse importGriffins(List<GriffinModel> griffinModelList) throws AdminManagementClientServerException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    public RequestResponse importPreservationScenarios(List<PreservationScenarioModel> preservationScenarioModelList) throws AdminManagementClientServerException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public RequestResponse<GriffinModel> findGriffinByID(String id) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public RequestResponse<PreservationScenarioModel> findPreservationByID(String id) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public RequestResponse<PreservationScenarioModel> findPreservation(JsonNode dslQuery) throws AdminManagementClientServerException, InvalidParseOperationException, ReferentialNotFoundException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public RequestResponse<GriffinModel> findGriffin(JsonNode dslQuery) {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public Response.Status createExternalOperation(LogbookOperationParameters logbookOperationparams) throws AdminManagementClientServerException, BadRequestException, LogbookClientAlreadyExistsException {
        LOGGER.debug("create Operation request ");
        return Response.Status.CREATED;
    }

    @Override
    public RequestResponse<JsonNode> findJobs() {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public void reconstructCollection(String collection) throws AdminManagementClientServerException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public void reconstructAccessionRegister(List<ReconstructionRequestItem> reconstructionItems) throws AdminManagementClientServerException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public RequestResponse<SchemaResponse> getUnitSchema() throws AdminManagementClientServerException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public RequestResponse<CombinedSchemaModel> getArchiveUnitProfileSchema(String id) throws AdminManagementClientServerException {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public RequestResponse<SchemaResponse> getObjectGroupSchema() {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public Response.Status importUnitExternalSchema(List<SchemaInputModel> externalSchemaInputList) {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public Response.Status deleteUnitExternalSchemas(List<String> paths) {
        throw new IllegalStateException(CANNOT_BE_USED);
    }

    @Override
    public RequestResponse<PublicConfiguration> getPublicConfiguration() {
        throw new IllegalStateException(CANNOT_BE_USED);
    }
}

