/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.MockOrRestClient;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitam.common.model.ProcessPause;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSummaryModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSymbolicModel;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.model.administration.CombinedSchemaModel;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.FileFormatModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitam.common.model.administration.preservation.GriffinModel;
import fr.gouv.vitam.common.model.administration.preservation.PreservationScenarioModel;
import fr.gouv.vitam.common.model.administration.profile.ProfileModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaInputModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.common.model.audit.AuditReferentialOptions;
import fr.gouv.vitam.common.model.configuration.PublicConfiguration;
import fr.gouv.vitam.functional.administration.common.ReconstructionRequestItem;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.DatabaseConflictException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesException;
import fr.gouv.vitam.functional.administration.common.exception.ProfileNotFoundException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.functional.administration.common.server.AccessionRegisterSymbolic;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public interface AdminManagementClient
extends MockOrRestClient {
    public Response checkFormat(InputStream var1) throws ReferentialException;

    public Response.Status importFormat(InputStream var1, String var2) throws ReferentialException, DatabaseConflictException;

    public JsonNode getFormatByID(String var1) throws ReferentialException, InvalidParseOperationException;

    public RequestResponse<FileFormatModel> getFormats(JsonNode var1) throws ReferentialException, InvalidParseOperationException, IOException;

    public Response checkRulesFile(InputStream var1) throws FileRulesException, AdminManagementClientServerException;

    public Response checkAgenciesFile(InputStream var1) throws ReferentialException, AdminManagementClientServerException;

    public Response.Status importRulesFile(InputStream var1, String var2) throws ReferentialException, DatabaseConflictException;

    public Response.Status importAgenciesFile(InputStream var1, String var2) throws ReferentialException;

    public RequestResponse<AgenciesModel> getAgencyById(String var1) throws InvalidParseOperationException, ReferentialNotFoundException, AdminManagementClientServerException;

    public JsonNode getAgencies(JsonNode var1) throws ReferentialException, InvalidParseOperationException, AdminManagementClientServerException;

    public JsonNode getRuleByID(String var1) throws FileRulesException, InvalidParseOperationException, AdminManagementClientServerException;

    public JsonNode getRules(JsonNode var1) throws FileRulesException, InvalidParseOperationException, IOException, AdminManagementClientServerException;

    public RequestResponse<AccessionRegisterDetailModel> createOrUpdateAccessionRegister(AccessionRegisterDetailModel var1) throws AdminManagementClientServerException;

    public RequestResponse<AccessionRegisterSummaryModel> getAccessionRegister(JsonNode var1) throws InvalidParseOperationException, ReferentialException, AccessUnauthorizedException;

    public RequestResponse<AccessionRegisterDetailModel> getAccessionRegisterDetail(String var1, JsonNode var2) throws InvalidParseOperationException, ReferentialException;

    public RequestResponse<AccessionRegisterDetailModel> getAccessionRegisterDetail(JsonNode var1) throws InvalidParseOperationException, ReferentialException;

    public Response.Status importIngestContracts(List<IngestContractModel> var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public Response.Status importAccessContracts(List<AccessContractModel> var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public Response.Status importManagementContracts(List<ManagementContractModel> var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<AccessContractModel> updateAccessContract(String var1, JsonNode var2) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse<IngestContractModel> updateIngestContract(String var1, JsonNode var2) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse<ManagementContractModel> updateManagementContract(String var1, JsonNode var2) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse<AccessContractModel> findAccessContracts(JsonNode var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<AccessContractModel> findAccessContractsByID(String var1) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse<IngestContractModel> findIngestContracts(JsonNode var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<IngestContractModel> findIngestContractsByID(String var1) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse<ManagementContractModel> findManagementContracts(JsonNode var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<ManagementContractModel> findManagementContractsByID(String var1) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse createProfiles(List<ProfileModel> var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<ProfileModel> importProfileFile(String var1, InputStream var2) throws ReferentialException, DatabaseConflictException;

    public Response downloadProfileFile(String var1) throws AdminManagementClientServerException, ProfileNotFoundException;

    public RequestResponse<ProfileModel> findProfiles(JsonNode var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<ProfileModel> findProfilesByID(String var1) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse<ProfileModel> updateProfile(String var1, JsonNode var2) throws AdminManagementClientServerException, InvalidParseOperationException, ReferentialNotFoundException;

    public Response.Status importContexts(List<ContextModel> var1) throws ReferentialException;

    public RequestResponse<ContextModel> updateContext(String var1, JsonNode var2) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse<ContextModel> findContexts(JsonNode var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<ContextModel> findContextById(String var1) throws InvalidParseOperationException, ReferentialNotFoundException, AdminManagementClientServerException;

    public RequestResponse<Boolean> securityProfileIsUsedInContexts(String var1) throws InvalidParseOperationException, ReferentialNotFoundException, AdminManagementClientServerException;

    public RequestResponse<JsonNode> launchAuditWorkflow(AuditOptions var1, boolean var2) throws AdminManagementClientServerException;

    public RequestResponse<JsonNode> launchReferentialAudit(AuditReferentialOptions var1) throws AdminManagementClientServerException;

    public RequestResponse<JsonNode> launchRuleAudit(List<Integer> var1) throws AdminManagementClientServerException, InvalidParseOperationException;

    public Response.Status importSecurityProfiles(List<SecurityProfileModel> var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<SecurityProfileModel> updateSecurityProfile(String var1, JsonNode var2) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse<SecurityProfileModel> findSecurityProfiles(JsonNode var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<SecurityProfileModel> findSecurityProfileByIdentifier(String var1) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse<ReindexationResult> launchReindexation(JsonNode var1) throws AdminManagementClientServerException;

    public RequestResponse<ReindexationResult> switchIndexes(JsonNode var1) throws AdminManagementClientServerException;

    public RequestResponse<JsonNode> evidenceAudit(JsonNode var1) throws AdminManagementClientServerException;

    public RequestResponse<JsonNode> rectificationAudit(String var1) throws AdminManagementClientServerException;

    public RequestResponse<JsonNode> exportProbativeValue(ProbativeValueRequest var1) throws AdminManagementClientServerException;

    public RequestResponse createArchiveUnitProfiles(List<ArchiveUnitProfileModel> var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<ArchiveUnitProfileModel> findArchiveUnitProfiles(JsonNode var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<ArchiveUnitProfileModel> findArchiveUnitProfilesByID(String var1) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse<ArchiveUnitProfileModel> updateArchiveUnitProfile(String var1, JsonNode var2) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse importOntologies(boolean var1, List<OntologyModel> var2) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<OntologyModel> findOntologies(JsonNode var1) throws InvalidParseOperationException;

    public RequestResponse<OntologyModel> findOntologyByID(String var1) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse forcePause(ProcessPause var1) throws AdminManagementClientServerException;

    public RequestResponse removeForcePause(ProcessPause var1) throws AdminManagementClientServerException;

    public RequestResponse<AccessionRegisterSymbolic> createAccessionRegisterSymbolic(List<Integer> var1) throws AdminManagementClientServerException, InvalidParseOperationException;

    public RequestResponse<AccessionRegisterSymbolicModel> getAccessionRegisterSymbolic(Integer var1, JsonNode var2) throws AdminManagementClientServerException;

    public RequestResponse<GriffinModel> importGriffins(List<GriffinModel> var1) throws AdminManagementClientServerException;

    public RequestResponse<PreservationScenarioModel> importPreservationScenarios(List<PreservationScenarioModel> var1) throws AdminManagementClientServerException;

    public RequestResponse<GriffinModel> findGriffinByID(String var1) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse<PreservationScenarioModel> findPreservationByID(String var1) throws InvalidParseOperationException, AdminManagementClientServerException, ReferentialNotFoundException;

    public RequestResponse<PreservationScenarioModel> findPreservation(JsonNode var1) throws AdminManagementClientServerException, InvalidParseOperationException, ReferentialNotFoundException;

    public RequestResponse<GriffinModel> findGriffin(JsonNode var1) throws AdminManagementClientServerException, InvalidParseOperationException, ReferentialNotFoundException;

    public Response.Status createExternalOperation(LogbookOperationParameters var1) throws AdminManagementClientServerException, BadRequestException, LogbookClientAlreadyExistsException;

    public RequestResponse<JsonNode> findJobs() throws AdminManagementClientServerException;

    public void reconstructCollection(String var1) throws AdminManagementClientServerException;

    public void reconstructAccessionRegister(List<ReconstructionRequestItem> var1) throws AdminManagementClientServerException;

    public RequestResponse<SchemaResponse> getUnitSchema() throws AdminManagementClientServerException;

    public RequestResponse<CombinedSchemaModel> getArchiveUnitProfileSchema(String var1) throws AdminManagementClientServerException;

    public RequestResponse<SchemaResponse> getObjectGroupSchema() throws AdminManagementClientServerException;

    public Response.Status importUnitExternalSchema(List<SchemaInputModel> var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public Response.Status deleteUnitExternalSchemas(List<String> var1) throws InvalidParseOperationException, AdminManagementClientServerException;

    public RequestResponse<PublicConfiguration> getPublicConfiguration() throws AdminManagementClientServerException;
}

