/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.common.service;

import java.io.ByteArrayInputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;

public class X509PKIUtil {
    public static X509Certificate parseX509Certificate(byte[] certificate) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certificate));
        x509Certificate.checkValidity();
        return x509Certificate;
    }

    public static boolean validateX509CRL(X509CRL crl) throws CRLException {
        Date now = new Date();
        return crl.getThisUpdate() != null && now.after(crl.getThisUpdate()) && crl.getNextUpdate() != null && now.before(crl.getNextUpdate());
    }

    public static X509CRL parseX509CRLCertificate(byte[] crlCertificate) throws CertificateException, CRLException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(crlCertificate));
    }
}

