/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.workspace.client;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import java.net.URI;

public class WorkspaceCollectClientFactory
extends WorkspaceClientFactory {
    private static final WorkspaceCollectClientFactory WORKSPACE_COLLECT_CLIENT_FACTORY = new WorkspaceCollectClientFactory("/workspace-collect/v1");

    private WorkspaceCollectClientFactory(String resourcePath) {
        super(resourcePath);
    }

    public static WorkspaceCollectClientFactory getInstance() {
        return WORKSPACE_COLLECT_CLIENT_FACTORY;
    }

    @Override
    public WorkspaceClient getClient() {
        return new WorkspaceClient(this);
    }

    public static void changeMode(String serviceUrl, WorkFlowExecutionContext executionContext) {
        ParametersChecker.checkParameter((String)"Server Url can not be null", (String[])new String[]{serviceUrl});
        URI uri = URI.create(serviceUrl);
        ClientConfigurationImpl configuration = new ClientConfigurationImpl(uri.getHost(), uri.getPort());
        WorkspaceCollectClientFactory.changeMode((ClientConfiguration)configuration, executionContext);
    }

    static void changeMode(ClientConfiguration configuration, WorkFlowExecutionContext executionContext) {
        WorkspaceCollectClientFactory instance = WorkspaceCollectClientFactory.getInstance();
        instance.initialisation(configuration, instance.getResourcePath());
    }
}

