/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.workspace.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.CommonMediaType;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.storage.constants.ErrorMessage;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageAlreadyExistException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageBadRequestException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotAcceptableException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageZipException;
import fr.gouv.vitam.workspace.api.exception.ZipFilesNameNotAllowedException;
import fr.gouv.vitam.workspace.api.model.FileParams;
import fr.gouv.vitam.workspace.api.model.TimeToLive;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.common.BulkMoveRequest;
import fr.gouv.vitam.workspace.common.CompressInformation;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WorkspaceClient
extends DefaultClient {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkspaceClient.class);
    private static final String OBJECTS = "/objects/";
    private static final String FOLDERS = "/folders/";
    private static final String OLD_FILES = "/old_files";
    private static final String CONTAINERS = "/containers/";
    private static final String ATOMIC_CONTAINERS = "/atomic_containers/";
    private static final String FILES_WITH_PARAMS = "/filesWithParams";
    private static final String FREESPACE_URL = "/freespace";
    private static final GenericType<List<URI>> URI_LIST_TYPE = new GenericType<List<URI>>(){};
    private static final GenericType<Map<String, FileParams>> FILES_MAP_TYPE = new GenericType<Map<String, FileParams>>(){};

    WorkspaceClient(WorkspaceClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonNode getFreespacePercent() throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.get().withPath(FREESPACE_URL).withJsonAccept());){
            Response.StatusType status = response.getStatusInfo();
            if (!Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) throw new VitamClientException("Could not retrieve workspace free space");
            JsonNode jsonNode = JsonHandler.getFromInputStream((InputStream)((InputStream)response.readEntity(InputStream.class)));
            return jsonNode;
        }
        catch (InvalidParseOperationException | VitamClientInternalException e) {
            throw new VitamClientException(e);
        }
    }

    public void createContainer(String containerName) throws ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        try (Response response = this.make(VitamRequestBuilder.post().withPath(CONTAINERS + containerName).withJsonAccept());){
            this.check(response);
        }
        catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException | ContentAddressableStorageNotFoundException e) {
            throw new ContentAddressableStorageServerException(e);
        }
    }

    public void deleteContainer(String containerName, boolean deleteRecursive) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        try (Response response = this.make(VitamRequestBuilder.delete().withPath(CONTAINERS + containerName).withHeader("X-Recursive", (Object)deleteRecursive).withJsonAccept());){
            this.check(response);
        }
        catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException e) {
            throw new ContentAddressableStorageServerException(e);
        }
    }

    public boolean isExistingContainer(String containerName) throws ContentAddressableStorageServerException {
        boolean bl;
        block9: {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
            Response response = this.make(VitamRequestBuilder.head().withPath(CONTAINERS + containerName).withJsonAccept());
            try {
                this.check(response);
                bl = true;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageAlreadyExistException | ContentAddressableStorageNotFoundException e) {
                    LOGGER.info(e);
                    return false;
                }
                catch (VitamClientInternalException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException e) {
                    throw new ContentAddressableStorageServerException(e);
                }
            }
            response.close();
        }
        return bl;
    }

    public void createFolder(String containerName, String folderName) throws ContentAddressableStorageAlreadyExistException, ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_FOLDER_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, folderName});
        try (Response response = this.make(VitamRequestBuilder.post().withPath(CONTAINERS + containerName + FOLDERS + folderName).withJsonAccept());){
            this.check(response);
        }
        catch (VitamClientInternalException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException | ContentAddressableStorageNotFoundException e) {
            throw new ContentAddressableStorageServerException(e);
        }
    }

    public void deleteFolder(String containerName, String folderName) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_FOLDER_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, folderName});
        try (Response response = this.make(VitamRequestBuilder.delete().withPath(CONTAINERS + containerName + FOLDERS + folderName).withJsonAccept());){
            this.check(response);
        }
        catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException e) {
            throw new ContentAddressableStorageServerException(e);
        }
    }

    public boolean isExistingFolder(String containerName, String folderName) throws ContentAddressableStorageServerException {
        boolean bl;
        block9: {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_FOLDER_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, folderName});
            Response response = this.make(VitamRequestBuilder.head().withPath(CONTAINERS + containerName + FOLDERS + folderName).withJsonAccept());
            try {
                this.check(response);
                bl = true;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageBadRequestException | ContentAddressableStorageNotFoundException e) {
                    LOGGER.info(e);
                    return false;
                }
                catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageNotAcceptableException e) {
                    throw new ContentAddressableStorageServerException(e);
                }
            }
            response.close();
        }
        return bl;
    }

    public void putObject(String containerName, String objectName, InputStream stream) throws ContentAddressableStorageServerException {
        this.putObject(containerName, objectName, (Object)stream);
    }

    public void putObject(String containerName, String objectName, Object object) throws ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(CONTAINERS + containerName + OBJECTS + objectName).withBody(object).withContentType(MediaType.APPLICATION_OCTET_STREAM_TYPE).withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
        }
        catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException | ContentAddressableStorageNotFoundException e) {
            throw new ContentAddressableStorageServerException(e);
        }
    }

    public void putAtomicObject(String containerName, String objectName, InputStream stream, long size) throws ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid size " + size);
        }
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(ATOMIC_CONTAINERS + containerName + OBJECTS + objectName).withHeader("X-Content-Length", (Object)size).withBody((Object)stream).withContentType(MediaType.APPLICATION_OCTET_STREAM_TYPE).withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
        }
        catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException | ContentAddressableStorageNotFoundException e) {
            throw new ContentAddressableStorageServerException(e);
        }
    }

    public Response getObject(String containerName, String objectName) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(VitamRequestBuilder.get().withPath(CONTAINERS + containerName + OBJECTS + objectName).withOctetAccept());
            this.check(response);
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException e) {
            throw new ContentAddressableStorageServerException(e);
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    public Response getObject(String containerName, String objectName, long offset, Long maxChunkSize) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        Response response = null;
        try {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(CONTAINERS + containerName + OBJECTS + objectName).withHeader("X-Vitam-Chunk-Offset", (Object)offset).withHeaderIgnoreNull("X-Vitam-Chunk-Max-Size", (Object)maxChunkSize).withOctetAccept();
            response = this.make(request);
            this.check(response);
            Response response2 = response;
            return response2;
        }
        catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException e) {
            throw new ContentAddressableStorageServerException(e);
        }
        finally {
            if (response != null && !Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
                response.close();
            }
        }
    }

    public Response bulkGetObjects(String containerName, List<String> objectURIs) throws ContentAddressableStorageServerException, ContentAddressableStorageNotFoundException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (Object[])new Object[]{containerName, objectURIs});
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (Object[])objectURIs.toArray());
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(VitamRequestBuilder.get().withPath(CONTAINERS + containerName + "/objects").withBody(objectURIs).withJsonOctet());
            this.check(response);
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException e) {
            throw new ContentAddressableStorageServerException(e);
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    public void deleteObject(String containerName, String objectName) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        try (Response response = this.make(VitamRequestBuilder.delete().withPath(CONTAINERS + containerName + OBJECTS + objectName).withJsonAccept());){
            this.check(response);
        }
        catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException e) {
            throw new ContentAddressableStorageServerException(e);
        }
    }

    public boolean isExistingObject(String containerName, String objectName) throws ContentAddressableStorageServerException {
        boolean bl;
        block9: {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_FOLDER_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
            Response response = this.make(VitamRequestBuilder.head().withPath(CONTAINERS + containerName + OBJECTS + objectName).withJsonAccept());
            try {
                this.check(response);
                bl = true;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageAlreadyExistException | ContentAddressableStorageNotFoundException e) {
                    LOGGER.info(e);
                    return false;
                }
                catch (VitamClientInternalException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException e) {
                    throw new ContentAddressableStorageServerException(e);
                }
            }
            response.close();
        }
        return bl;
    }

    public RequestResponse<URI> getListUriDigitalObjectFromFolder(String containerName, String folderName) throws ContentAddressableStorageServerException {
        return this.getListUriDigitalObjectFromFolder(containerName, folderName, Integer.MAX_VALUE);
    }

    public RequestResponse<URI> getListUriDigitalObjectFromFolder(String containerName, String folderName, int limit) throws ContentAddressableStorageServerException {
        RequestResponseOK requestResponseOK;
        block9: {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_FOLDER_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, folderName});
            Response response = this.make(VitamRequestBuilder.get().withPath(CONTAINERS + containerName + FOLDERS + folderName).withQueryParam("limit", String.valueOf(limit)).withJsonAccept());
            try {
                this.check(response);
                List uris = (List)response.readEntity(URI_LIST_TYPE);
                requestResponseOK = new RequestResponseOK().addAllResults(uris == null ? Collections.emptyList() : uris);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageAlreadyExistException | ContentAddressableStorageNotFoundException e) {
                    LOGGER.info(e);
                    return new RequestResponseOK();
                }
                catch (VitamClientInternalException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException e) {
                    throw new ContentAddressableStorageServerException(e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    public RequestResponse<Map<String, FileParams>> getFilesWithParamsFromFolder(String containerName, String folderName) throws ContentAddressableStorageServerException {
        RequestResponseOK requestResponseOK;
        block9: {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_FOLDER_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, folderName});
            Response response = this.make(VitamRequestBuilder.get().withPath(CONTAINERS + containerName + FOLDERS + folderName + FILES_WITH_PARAMS).withJsonAccept());
            try {
                this.check(response);
                Map filesMap = (Map)response.readEntity(FILES_MAP_TYPE);
                requestResponseOK = new RequestResponseOK().addResult((Object)(filesMap == null ? Collections.emptyMap() : filesMap));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageAlreadyExistException | ContentAddressableStorageNotFoundException e) {
                    LOGGER.info(e);
                    return new RequestResponseOK().addResult(Collections.emptyMap());
                }
                catch (VitamClientInternalException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException e) {
                    throw new ContentAddressableStorageServerException(e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    public void compress(String containerName, CompressInformation compressInformation) throws ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        try (Response response = this.make(VitamRequestBuilder.post().withPath(CONTAINERS + containerName).withBody((Object)compressInformation).withJson());){
            this.check(response);
        }
        catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException | ContentAddressableStorageNotFoundException e) {
            throw new ContentAddressableStorageServerException(e);
        }
    }

    public void uncompressObject(String containerName, String folderName, String archiveType, InputStream inputStreamObject) throws ContentAddressableStorageException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_FOLDER_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, folderName, archiveType});
        if (!this.isExistingContainer(containerName)) {
            LOGGER.debug(ErrorMessage.CONTAINER_NOT_FOUND.getMessage());
            throw new ContentAddressableStorageNotFoundException(ErrorMessage.CONTAINER_NOT_FOUND.getMessage());
        }
        if (this.isExistingFolder(containerName, folderName)) {
            LOGGER.warn(ErrorMessage.FOLDER_ALREADY_EXIST.getMessage());
            throw new ContentAddressableStorageAlreadyExistException(ErrorMessage.FOLDER_ALREADY_EXIST.getMessage());
        }
        VitamRequestBuilder request = VitamRequestBuilder.put().withPath(CONTAINERS + containerName + FOLDERS + folderName).withBody((Object)inputStreamObject).withContentType(CommonMediaType.valueOf((String)archiveType)).withJsonAccept().withChunckedMode(true);
        try (Response response = this.make(request);){
            this.check(response);
        }
        catch (ContentAddressableStorageBadRequestException e) {
            throw new ContentAddressableStorageZipException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
        }
        catch (ContentAddressableStorageNotAcceptableException e) {
            throw new ZipFilesNameNotAllowedException("File or folder name not allowed", (Throwable)e);
        }
        catch (VitamClientInternalException e) {
            throw new ContentAddressableStorageServerException((Throwable)e);
        }
    }

    public String computeObjectDigest(String containerName, String objectName, DigestType algo) throws ContentAddressableStorageException {
        String string;
        block8: {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (Object[])new Object[]{containerName, objectName, algo});
            Response response = this.make(VitamRequestBuilder.head().withPath(CONTAINERS + containerName + OBJECTS + objectName).withHeader("X-digest-algorithm", (Object)algo.getName()).withJsonAccept());
            try {
                this.check(response);
                string = response.getHeaderString("X-digest");
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new ContentAddressableStorageServerException((Throwable)e);
                }
            }
            response.close();
        }
        return string;
    }

    RequestResponse<JsonNode> getObjectInformation(String containerName, String objectName) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        RequestResponseOK requestResponseOK;
        block8: {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
            Response response = this.make(VitamRequestBuilder.get().withPath(CONTAINERS + containerName + OBJECTS + objectName).withJsonAccept());
            try {
                this.check(response);
                requestResponseOK = new RequestResponseOK().addResult(response.readEntity(JsonNode.class));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException e) {
                    throw new ContentAddressableStorageServerException(e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    boolean checkObject(String containerName, String objectId, String digest, DigestType digestAlgorithm) throws ContentAddressableStorageException {
        return this.computeObjectDigest(containerName, objectId, digestAlgorithm).equals(digest);
    }

    public void bulkMove(String containerName, BulkMoveRequest bulkMoveRequest) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (Object[])new Object[]{containerName, bulkMoveRequest});
        try (Response response = this.make(VitamRequestBuilder.post().withPath(CONTAINERS + containerName + "/bulk-move").withBody((Object)bulkMoveRequest).withJson());){
            this.check(response);
        }
        catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException e) {
            throw new ContentAddressableStorageServerException(e);
        }
    }

    public void purgeOldFilesInContainer(String containerName, TimeToLive timeToLive) throws ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)"Mandatory parameters", (Object[])new Object[]{containerName, timeToLive});
        try (Response response = this.make(VitamRequestBuilder.delete().withPath(CONTAINERS + containerName + OLD_FILES).withBody((Object)timeToLive).withJson());){
            this.check(response);
        }
        catch (VitamClientInternalException | ContentAddressableStorageAlreadyExistException | ContentAddressableStorageBadRequestException | ContentAddressableStorageNotAcceptableException | ContentAddressableStorageNotFoundException e) {
            throw new ContentAddressableStorageServerException(e);
        }
    }

    private void check(Response response) throws ContentAddressableStorageServerException, ContentAddressableStorageNotFoundException, ContentAddressableStorageAlreadyExistException, ContentAddressableStorageNotAcceptableException, ContentAddressableStorageBadRequestException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        switch (status) {
            case NOT_FOUND: {
                throw new ContentAddressableStorageNotFoundException(ErrorMessage.CONTAINER_NOT_FOUND.getMessage());
            }
            case CONFLICT: {
                throw new ContentAddressableStorageAlreadyExistException(ErrorMessage.FOLDER_ALREADY_EXIST.getMessage());
            }
            case BAD_REQUEST: {
                throw new ContentAddressableStorageBadRequestException(ErrorMessage.BAD_REQUEST.getMessage());
            }
            case NOT_ACCEPTABLE: {
                throw new ContentAddressableStorageNotAcceptableException(ErrorMessage.NOT_ACCEPTABLE_FILES.getMessage());
            }
        }
        throw new ContentAddressableStorageServerException(String.format("Response in error with status '%d' and reason '%s'.", status.getStatusCode(), status.getReasonPhrase()));
    }
}

