/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.workspace.client;

import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.DeferredFileBufferingInputStream;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class WorkspaceBufferingInputStream
extends InputStream {
    private final WorkspaceClientFactory workspaceClientFactory;
    private final String containerName;
    private final String objectName;
    private final int maxOnDiskBufferSize;
    private final int maxInMemoryBufferSize;
    private final File tmpDirectory;
    private InputStream inputStream;
    private long totalReadBytes;
    private boolean isLastChunk = false;
    private boolean closed = false;

    public WorkspaceBufferingInputStream(WorkspaceClientFactory workspaceClientFactory, String containerName, String objectName, int maxOnDiskBufferSize, int maxInMemoryBufferSize, File tmpDirectory) throws IOException, ContentAddressableStorageNotFoundException {
        this.workspaceClientFactory = workspaceClientFactory;
        this.containerName = containerName;
        this.objectName = objectName;
        this.maxOnDiskBufferSize = maxOnDiskBufferSize;
        this.maxInMemoryBufferSize = maxInMemoryBufferSize;
        this.tmpDirectory = tmpDirectory;
        this.totalReadBytes = 0L;
        this.loadNextBuffer();
    }

    private void loadNextBuffer() throws ContentAddressableStorageNotFoundException, IOException {
        this.cleanup();
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
             Response response = workspaceClient.getObject(this.containerName, this.objectName, this.totalReadBytes, Long.valueOf(this.maxOnDiskBufferSize));
             InputStream objInputStream = (InputStream)response.readEntity(InputStream.class);){
            int chunkSize = Integer.parseInt(response.getHeaderString("X-Chunk-Length"));
            this.inputStream = new DeferredFileBufferingInputStream(objInputStream, chunkSize, this.maxInMemoryBufferSize, this.tmpDirectory);
            this.isLastChunk = chunkSize < this.maxOnDiskBufferSize;
        }
        catch (ContentAddressableStorageServerException e) {
            throw new IOException(e);
        }
    }

    private void cleanup() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureNotClosed();
        int result = this.inputStream.read();
        if (result == -1 && !this.isLastChunk) {
            try {
                this.loadNextBuffer();
            }
            catch (ContentAddressableStorageNotFoundException ex) {
                throw new IOException("Could not find file anymore " + this.containerName + "/" + this.objectName, ex);
            }
            result = this.inputStream.read();
        }
        if (result != -1) {
            ++this.totalReadBytes;
        }
        return result;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        this.ensureNotClosed();
        int result = this.inputStream.read(buffer, off, len);
        if (result == -1 && !this.isLastChunk) {
            try {
                this.loadNextBuffer();
            }
            catch (ContentAddressableStorageNotFoundException ex) {
                throw new IOException("Could not find file anymore " + this.containerName + "/" + this.objectName, ex);
            }
            result = this.inputStream.read(buffer, off, len);
        }
        if (result != -1) {
            this.totalReadBytes += (long)result;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.cleanup();
            this.closed = true;
        }
        super.close();
    }

    private void ensureNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed input stream");
        }
    }
}

