/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.manifest.naming;

import fr.gouv.vitam.common.exception.ExportException;
import fr.gouv.vitam.common.manifest.naming.ArchiveUnitTreeExportModel;
import fr.gouv.vitam.common.manifest.naming.FileNameCleaner;
import fr.gouv.vitam.common.manifest.naming.FolderResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;

public class UnitTreeFolderResolver
implements FolderResolver {
    private static final String PATH_SEPARATOR = "/";
    private static final String DEFAULT_TITLE_LANGUAGE = "fr";
    private static final int MAX_DIRECTORY_NAME_SIZE_LIMIT = 100;
    private final Map<String, ArchiveUnitTreeExportModel> unitsByIds;
    private final Map<String, String> unitIdsByObjectGroupId = new HashMap<String, String>();
    private final Map<String, String> resolvedFolderByUnitId = new HashMap<String, String>();
    private final Set<String> resolvedBasePaths = new HashSet<String>();

    public UnitTreeFolderResolver(List<ArchiveUnitTreeExportModel> units) throws ExportException {
        UnitTreeFolderResolver.checkDuplicatePathsForUnits(units);
        UnitTreeFolderResolver.checkDuplicatePathsForObjectGroups(units);
        this.unitsByIds = units.stream().collect(Collectors.toMap(ArchiveUnitTreeExportModel::id, unit -> unit));
        for (ArchiveUnitTreeExportModel unit2 : units) {
            Optional<String> objectGroupId = Optional.ofNullable(unit2.objectGroupId());
            objectGroupId.ifPresent(ogId -> this.unitIdsByObjectGroupId.put((String)ogId, unit2.id()));
        }
    }

    private static void checkDuplicatePathsForUnits(List<ArchiveUnitTreeExportModel> units) throws ExportException {
        Set unitIds = units.stream().map(ArchiveUnitTreeExportModel::id).collect(Collectors.toSet());
        for (ArchiveUnitTreeExportModel unit : units) {
            List<String> exportedParentUnitIds = unit.parentUnitIds().stream().filter(unitIds::contains).toList();
            if (exportedParentUnitIds.size() <= 1) continue;
            throw new ExportException("Multiple paths for unit with ID " + unit.id());
        }
    }

    private static void checkDuplicatePathsForObjectGroups(List<ArchiveUnitTreeExportModel> units) throws ExportException {
        HashSet<String> objectGroupIds = new HashSet<String>();
        for (ArchiveUnitTreeExportModel unit : units) {
            Optional<String> objectGroupId = Optional.ofNullable(unit.objectGroupId());
            if (!objectGroupId.isPresent() || objectGroupIds.add(objectGroupId.get())) continue;
            throw new ExportException("Multiple paths for object group with ID " + objectGroupId.get());
        }
    }

    @Override
    public String resolve(String objectGroupId) {
        if (!this.unitIdsByObjectGroupId.containsKey(objectGroupId)) {
            throw new IllegalStateException("Unknown unit for object group with ID " + objectGroupId);
        }
        String unitId = this.unitIdsByObjectGroupId.get(objectGroupId);
        return this.resolveUnitPath(unitId);
    }

    private String resolveUnitPath(String unitId) {
        Object baseParentPath;
        if (this.resolvedFolderByUnitId.containsKey(unitId)) {
            return this.resolvedFolderByUnitId.get(unitId);
        }
        ArchiveUnitTreeExportModel unit = this.unitsByIds.get(unitId);
        if (unit == null) {
            throw new IllegalStateException("Unknown unit with ID " + unitId);
        }
        List<String> exportParentUnitIds = unit.parentUnitIds().stream().filter(this.unitsByIds::containsKey).toList();
        if (exportParentUnitIds.size() > 2) {
            throw new IllegalStateException("Multiple paths not expected for unit with ID " + unitId);
        }
        if (exportParentUnitIds.isEmpty()) {
            baseParentPath = "";
        } else {
            String parentUnitId = exportParentUnitIds.get(0);
            baseParentPath = this.resolveUnitPath(parentUnitId) + PATH_SEPARATOR;
        }
        String title = UnitTreeFolderResolver.getTitle(unit);
        String normalizedTitle = FileNameCleaner.cleanFileName(title);
        if ((this.resolvedBasePaths.contains((String)baseParentPath + normalizedTitle) || normalizedTitle.length() > 100) && this.resolvedBasePaths.contains((String)baseParentPath + (normalizedTitle = UnitTreeFolderResolver.truncateAndAddSuffix(normalizedTitle, unitId)))) {
            throw new IllegalStateException("Deduplicated title still exists for unit with ID " + unitId + ". Title: '" + normalizedTitle + "'");
        }
        this.resolvedBasePaths.add((String)baseParentPath + normalizedTitle);
        this.resolvedFolderByUnitId.put(unitId, (String)baseParentPath + normalizedTitle);
        return (String)baseParentPath + normalizedTitle;
    }

    private static String truncateAndAddSuffix(String sanitizedTitle, String unitId) {
        int maxLength = Math.min(100, sanitizedTitle.length() + 1 + unitId.length());
        return sanitizedTitle.substring(0, maxLength - unitId.length() - 1) + "_" + unitId;
    }

    private static String getTitle(ArchiveUnitTreeExportModel unit) {
        if (unit.title() != null) {
            return unit.title();
        }
        if (MapUtils.isEmpty(unit.title_())) {
            throw new IllegalStateException("Unit with ID " + unit.id() + " does not have a Title or Title_ field");
        }
        if (unit.title_().containsKey(DEFAULT_TITLE_LANGUAGE)) {
            return unit.title_().get(DEFAULT_TITLE_LANGUAGE);
        }
        return unit.title_().values().iterator().next();
    }
}

