/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.manifest.naming;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.manifest.naming.ExtensionHelper;
import fr.gouv.vitam.common.manifest.naming.FilenameResolver;
import org.apache.commons.lang3.StringUtils;

public class GuidFilenameResolver
implements FilenameResolver {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(GuidFilenameResolver.class);
    private static final String CONTENT_PREFIX = "Content/";
    private static final String PATH_SEPARATOR = "/";
    public static GuidFilenameResolver INSTANCE = new GuidFilenameResolver();

    private GuidFilenameResolver() {
    }

    @Override
    public String resolve(String basePath, String objectId, String uri, String filename) {
        String objectPath = this.getObjectPathFromObjectId(objectId, uri, filename);
        return CONTENT_PREFIX + (String)(basePath.isEmpty() ? objectPath : basePath + PATH_SEPARATOR + objectPath);
    }

    private String getObjectPathFromObjectId(String objectId, String uri, String filename) {
        String extension = this.getExtension(objectId, uri, filename).toLowerCase();
        return objectId + (String)(extension.isEmpty() ? "" : "." + extension);
    }

    private String getExtension(String objectId, String uri, String filename) {
        String extension = ExtensionHelper.getExtension(uri);
        if (StringUtils.isEmpty((CharSequence)extension)) {
            extension = ExtensionHelper.getExtension(filename);
        }
        if (StringUtils.isEmpty((CharSequence)extension)) {
            extension = "";
            LOGGER.warn("cannot find extension for object" + objectId);
        }
        return extension;
    }
}

