/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.manifest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import fr.gouv.culture.archivesdefrance.seda.v2.ArchiveUnitType;
import fr.gouv.culture.archivesdefrance.seda.v2.BinaryDataObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.CodeListVersionsType;
import fr.gouv.culture.archivesdefrance.seda.v2.CodeType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectGroupType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectPackageType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectRefType;
import fr.gouv.culture.archivesdefrance.seda.v2.EventLogBookOgType;
import fr.gouv.culture.archivesdefrance.seda.v2.IdentifierType;
import fr.gouv.culture.archivesdefrance.seda.v2.LegalStatusType;
import fr.gouv.culture.archivesdefrance.seda.v2.LogBookOgType;
import fr.gouv.culture.archivesdefrance.seda.v2.LogBookType;
import fr.gouv.culture.archivesdefrance.seda.v2.ManagementMetadataType;
import fr.gouv.culture.archivesdefrance.seda.v2.ManagementType;
import fr.gouv.culture.archivesdefrance.seda.v2.MinimalDataObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.ObjectFactory;
import fr.gouv.culture.archivesdefrance.seda.v2.OrganizationWithIdType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.exception.ExportException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.manifest.LogbookMapper;
import fr.gouv.vitam.common.manifest.naming.FilenameResolver;
import fr.gouv.vitam.common.manifest.naming.FolderResolver;
import fr.gouv.vitam.common.mapping.dip.ArchiveUnitMapper;
import fr.gouv.vitam.common.mapping.dip.ObjectGroupMapper;
import fr.gouv.vitam.common.mapping.mapper.VitamObjectMapper;
import fr.gouv.vitam.common.model.export.ExportRequestParameters;
import fr.gouv.vitam.common.model.export.ExportType;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import fr.gouv.vitam.common.model.unit.ArchiveUnitModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleObjectGroup;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleUnit;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.collections4.CollectionUtils;
import org.bson.Document;

public class ManifestBuilder
implements AutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ManifestBuilder.class);
    private static JAXBContext jaxbContext;
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private final XMLStreamWriter writer;
    private final Marshaller marshaller;
    private final ArchiveUnitMapper archiveUnitMapper = new ArchiveUnitMapper();
    private final ObjectMapper objectMapper;
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final ObjectGroupMapper objectGroupMapper;
    private final SupportedSedaVersions supportedSedaVersion;

    public ManifestBuilder(OutputStream outputStream, SupportedSedaVersions supportedSedaVersion) throws XMLStreamException, JAXBException {
        this.objectMapper = VitamObjectMapper.getDeserializationObjectMapper();
        this.objectGroupMapper = new ObjectGroupMapper();
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
        this.writer = xmlOutputFactory.createXMLStreamWriter(outputStream);
        this.marshaller = jaxbContext.createMarshaller();
        this.marshaller.setProperty("jaxb.fragment", (Object)true);
        this.supportedSedaVersion = supportedSedaVersion != null ? supportedSedaVersion : SupportedSedaVersions.SEDA_2_3;
    }

    public void startDocument(String operationId, ExportType exportType, ExportRequestParameters exportRequestParameters) throws XMLStreamException, JAXBException {
        this.initWriter(exportType);
        switch (exportType) {
            case ArchiveTransfer: 
            case ArchiveDeliveryRequestReply: {
                this.writeComment(exportRequestParameters.getComment());
                this.writeDate(LocalDateUtil.getFormattedDate((LocalDateTime)LocalDateUtil.now()));
                this.writeMessageIdentifier(operationId);
                this.writeArchivalAgreement(exportRequestParameters.getArchivalAgreement());
                this.writeCodeListVersions(ParameterHelper.getTenantParameter());
                break;
            }
        }
    }

    private void initWriter(ExportType exportType) throws XMLStreamException {
        final String namespaceForExport = this.supportedSedaVersion.getNamespaceURI();
        this.writer.writeStartDocument();
        this.writer.setNamespaceContext(new NamespaceContext(){

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return "";
            }

            @Override
            public String getNamespaceURI(String prefix) {
                return namespaceForExport;
            }
        });
        switch (exportType) {
            case ArchiveTransfer: {
                this.writer.writeStartElement(namespaceForExport, "ArchiveTransfer");
                break;
            }
            case ArchiveDeliveryRequestReply: 
            case MinimalArchiveDeliveryRequestReply: {
                this.writer.writeStartElement(namespaceForExport, "ArchiveDeliveryRequestReply");
            }
        }
        this.writer.writeNamespace("xlink", "http://www.w3.org/1999/xlink");
        this.writer.writeNamespace("pr", "info:lc/xmlns/premis-v2");
        this.writer.writeDefaultNamespace(namespaceForExport);
        this.writer.writeNamespace("xsi", XSI_URI);
        this.writer.writeAttribute("xsi", XSI_URI, "schemaLocation", namespaceForExport + " " + this.supportedSedaVersion.getSedaValidatorXSD());
    }

    public Map<String, JsonNode> writeGOT(JsonNode og, String linkedAU, Stream<LogbookLifeCycleObjectGroup> logbookLifeCycleObjectGroupStream, FolderResolver folderResolver, FilenameResolver filenameResolver) throws JsonProcessingException, JAXBException {
        ObjectGroupResponse objectGroup = (ObjectGroupResponse)this.objectMapper.treeToValue((TreeNode)og, ObjectGroupResponse.class);
        Map<String, String> strategiesByVersion = objectGroup.getQualifiers().stream().flatMap(qualifier -> qualifier.getVersions().stream()).filter(version -> version.getStorage() != null && version.getStorage().getStrategyId() != null).collect(Collectors.toMap(VersionsModel::getDataObjectVersion, version -> version.getStorage().getStrategyId()));
        HashMap<String, JsonNode> maps = new HashMap<String, JsonNode>();
        DataObjectPackageType xmlObject = this.objectGroupMapper.map(objectGroup);
        List dataObjectGroupList = xmlObject.getDataObjectGroupOrBinaryDataObjectOrPhysicalDataObject();
        if (dataObjectGroupList.isEmpty()) {
            return maps;
        }
        DataObjectGroupType dataObjectGroup = (DataObjectGroupType)dataObjectGroupList.get(0);
        List<EventLogBookOgType> events = logbookLifeCycleObjectGroupStream.flatMap(lifecycle -> Stream.concat(lifecycle.events().stream(), Stream.of(lifecycle))).map(LogbookMapper::getEventOGTypeFromDocument).toList();
        if (!events.isEmpty()) {
            LogBookOgType logbookType = new LogBookOgType();
            logbookType.getEvent().addAll(events);
            dataObjectGroup.setLogBook(logbookType);
        }
        List binaryDataObjectOrPhysicalDataObject = dataObjectGroup.getBinaryDataObjectOrPhysicalDataObject();
        for (MinimalDataObjectType minimalDataObjectType : binaryDataObjectOrPhysicalDataObject) {
            if (!(minimalDataObjectType instanceof BinaryDataObjectType)) continue;
            BinaryDataObjectType binaryDataObjectType = (BinaryDataObjectType)minimalDataObjectType;
            String fileName = ManifestBuilder.generateExportFileName(folderResolver, filenameResolver, binaryDataObjectType, dataObjectGroup);
            binaryDataObjectType.setUri(fileName);
            String[] dataObjectVersion = minimalDataObjectType.getDataObjectVersion().split("_");
            String xmlQualifier = dataObjectVersion[0];
            Integer xmlVersion = Integer.parseInt(dataObjectVersion[1]);
            ObjectNode objectInfo = (ObjectNode)AccessLogUtils.getWorkerInfo((String)xmlQualifier, (Integer)xmlVersion, (Long)binaryDataObjectType.getSize().longValue(), (String)linkedAU, (String)fileName);
            objectInfo.put("strategyId", strategiesByVersion.get(minimalDataObjectType.getDataObjectVersion()));
            maps.put(minimalDataObjectType.getId(), (JsonNode)objectInfo);
        }
        this.marshallHackForNonXmlRootObject(dataObjectGroup);
        return maps;
    }

    private static String generateExportFileName(FolderResolver folderResolver, FilenameResolver filenameResolver, BinaryDataObjectType binaryDataObjectType, DataObjectGroupType dataObjectGroup) {
        String baseFilePath = folderResolver.resolve(dataObjectGroup.getId());
        String binaryFilename = binaryDataObjectType.getFileInfo() != null ? binaryDataObjectType.getFileInfo().getFilename() : null;
        return filenameResolver.resolve(baseFilePath, binaryDataObjectType.getId(), binaryDataObjectType.getUri(), binaryFilename);
    }

    private void marshallHackForNonXmlRootObject(DataObjectGroupType dataObjectGroup) throws JAXBException {
        this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "DataObjectGroup"), DataObjectGroupType.class, (Object)dataObjectGroup), this.writer);
    }

    public void writeArchiveUnit(ArchiveUnitModel archiveUnitModel, ListMultimap<String, String> multimap, Map<String, String> ogs) throws JAXBException, DatatypeConfigurationException, ExportException {
        this.writeArchiveUnitWithLFC(archiveUnitModel, multimap, ogs, null);
    }

    public void writeArchiveUnitWithLFC(ArchiveUnitModel archiveUnitModel, ListMultimap<String, String> multimap, Map<String, String> ogs, @Nullable LogbookLifeCycleUnit logbookLFC) throws DatatypeConfigurationException, JAXBException, ExportException {
        ArchiveUnitType archiveUnitType = this.mapUnitModelToXML(archiveUnitModel, multimap, ogs);
        if (logbookLFC != null) {
            LogBookType logBookType = this.addArchiveUnitLogbookType(logbookLFC);
            if (archiveUnitType.getManagement() == null) {
                archiveUnitType.setManagement(new ManagementType());
            }
            archiveUnitType.getManagement().setLogBook(logBookType);
        }
        this.marshaller.marshal((Object)archiveUnitType, this.writer);
    }

    private ArchiveUnitType mapUnitModelToXML(ArchiveUnitModel archiveUnitModel, ListMultimap<String, String> multimap, Map<String, String> ogs) throws DatatypeConfigurationException, ExportException {
        ArchiveUnitType xmlUnit = this.archiveUnitMapper.map(archiveUnitModel, this.supportedSedaVersion);
        List<Object> unitChildren = new ArrayList();
        if (multimap.containsKey((Object)xmlUnit.getId())) {
            List children = multimap.get((Object)xmlUnit.getId());
            unitChildren = children.stream().map(item -> {
                ArchiveUnitType archiveUnitType = new ArchiveUnitType();
                archiveUnitType.setId(GUIDFactory.newGUID().toString());
                archiveUnitType.setArchiveUnitRefId(item);
                return archiveUnitType;
            }).toList();
        }
        xmlUnit.getArchiveUnitOrDataObjectReferenceOrDataObjectGroup().addAll(unitChildren);
        Optional.ofNullable(ogs).map(tmp -> (String)tmp.get(xmlUnit.getId())).ifPresent(og -> {
            DataObjectRefType value = new DataObjectRefType();
            value.setDataObjectGroupReferenceId(og);
            JAXBElement archiveUnitTypeDataObjectReference = this.objectFactory.createArchiveUnitTypeDataObjectReference(value);
            xmlUnit.getArchiveUnitOrDataObjectReferenceOrDataObjectGroup().add(archiveUnitTypeDataObjectReference);
        });
        return xmlUnit;
    }

    private LogBookType addArchiveUnitLogbookType(LogbookLifeCycleUnit logbookLFC) {
        LogBookType logbookType = new LogBookType();
        for (Document event : logbookLFC.events()) {
            logbookType.getEvent().add(LogbookMapper.getEventTypeFromDocument(event));
        }
        logbookType.getEvent().add(LogbookMapper.getEventTypeFromDocument((Document)logbookLFC));
        return logbookType;
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    public void startDescriptiveMetadata() throws XMLStreamException {
        this.writer.writeStartElement("fr:gouv:culture:archivesdefrance:seda:v2", "DescriptiveMetadata");
    }

    public void startDataObjectPackage() throws XMLStreamException {
        this.writer.writeStartElement("fr:gouv:culture:archivesdefrance:seda:v2", "DataObjectPackage");
    }

    public void endDescriptiveMetadata() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    public void endDataObjectPackage() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    public void writeComment(String comment) throws XMLStreamException {
        if (null == comment) {
            return;
        }
        this.writer.writeStartElement("fr:gouv:culture:archivesdefrance:seda:v2", "Comment");
        this.writer.writeCharacters(comment);
        this.writer.writeEndElement();
    }

    public void writeDate(String date) throws XMLStreamException {
        if (null == date) {
            return;
        }
        this.writer.writeStartElement("fr:gouv:culture:archivesdefrance:seda:v2", "Date");
        this.writer.writeCharacters(date);
        this.writer.writeEndElement();
    }

    public void writeMessageIdentifier(String operationId) throws XMLStreamException {
        if (null == operationId) {
            return;
        }
        this.writer.writeStartElement("fr:gouv:culture:archivesdefrance:seda:v2", "MessageIdentifier");
        this.writer.writeCharacters(operationId);
        this.writer.writeEndElement();
    }

    public void writeArchivalAgreement(String archivalAgreement) throws XMLStreamException {
        if (Strings.isNullOrEmpty((String)archivalAgreement)) {
            return;
        }
        this.writer.writeStartElement("fr:gouv:culture:archivesdefrance:seda:v2", "ArchivalAgreement");
        this.writer.writeCharacters(archivalAgreement);
        this.writer.writeEndElement();
    }

    private ManagementMetadataType buildManagementMetadata(String originatingAgency, String submissionAgencyIdentifier) {
        ManagementMetadataType managementMetadataType = new ManagementMetadataType();
        IdentifierType identifierType = new IdentifierType();
        identifierType.setValue(originatingAgency);
        managementMetadataType.setOriginatingAgencyIdentifier(identifierType);
        if (!Strings.isNullOrEmpty((String)submissionAgencyIdentifier)) {
            identifierType = new IdentifierType();
            identifierType.setValue(submissionAgencyIdentifier);
            managementMetadataType.setSubmissionAgencyIdentifier(identifierType);
        }
        return managementMetadataType;
    }

    public void writeManagementMetadata(String acquisitionInformation, String legalStatus, String originatingAgency, String submissionAgencyIdentifier, String archivalProfile) throws JAXBException, ExportException {
        if (Strings.isNullOrEmpty((String)originatingAgency)) {
            throw new ExportException("OriginatingAgencyIdentifier parameter is required");
        }
        ManagementMetadataType managementMetadataType = this.buildManagementMetadata(originatingAgency, submissionAgencyIdentifier);
        if (!Strings.isNullOrEmpty((String)archivalProfile)) {
            IdentifierType identifierType = new IdentifierType();
            identifierType.setValue(archivalProfile);
            managementMetadataType.setArchivalProfile(identifierType);
        }
        if (!Strings.isNullOrEmpty((String)legalStatus)) {
            managementMetadataType.setLegalStatus(LegalStatusType.fromValue((String)legalStatus));
        }
        if (!Strings.isNullOrEmpty((String)acquisitionInformation)) {
            managementMetadataType.setAcquisitionInformation(acquisitionInformation);
        }
        this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "ManagementMetadata"), ManagementMetadataType.class, (Object)managementMetadataType), this.writer);
    }

    public void writeManagementMetadata(String originatingAgency, String submissionAgencyIdentifier) throws JAXBException, ExportException {
        if (Strings.isNullOrEmpty((String)originatingAgency)) {
            throw new ExportException("OriginatingAgencyIdentifier parameter is required");
        }
        ManagementMetadataType managementMetadataType = this.buildManagementMetadata(originatingAgency, submissionAgencyIdentifier);
        this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "ManagementMetadata"), ManagementMetadataType.class, (Object)managementMetadataType), this.writer);
    }

    public void writeCodeListVersions(int tenant) throws JAXBException {
        CodeListVersionsType codeListVersionsType = new CodeListVersionsType();
        CodeType value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("ReplyCodeListVersion", "ReplyCodeListVersion") + tenant);
        codeListVersionsType.setReplyCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("MessageDigestAlgorithmCodeListVersion", "MessageDigestAlgorithmCodeListVersion") + tenant);
        codeListVersionsType.setMessageDigestAlgorithmCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("MimeTypeCodeListVersion", "MimeTypeCodeListVersion") + tenant);
        codeListVersionsType.setMimeTypeCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("EncodingCodeListVersion", "EncodingCodeListVersion") + tenant);
        codeListVersionsType.setEncodingCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("FileFormatCodeListVersion", "FileFormatCodeListVersion") + tenant);
        codeListVersionsType.setFileFormatCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("CompressionAlgorithmCodeListVersion", "CompressionAlgorithmCodeListVersion") + tenant);
        codeListVersionsType.setCompressionAlgorithmCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("DataObjectVersionCodeListVersion", "DataObjectVersionCodeListVersion") + tenant);
        codeListVersionsType.setDataObjectVersionCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("StorageRuleCodeListVersion", "StorageRuleCodeListVersion") + tenant);
        codeListVersionsType.setStorageRuleCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("AppraisalRuleCodeListVersion", "AppraisalRuleCodeListVersion") + tenant);
        codeListVersionsType.setAppraisalRuleCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("AccessRuleCodeListVersion", "AccessRuleCodeListVersion") + tenant);
        codeListVersionsType.setAccessRuleCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("DisseminationRuleCodeListVersion", "DisseminationRuleCodeListVersion") + tenant);
        codeListVersionsType.setDisseminationRuleCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("ReuseRuleCodeListVersion", "ReuseRuleCodeListVersion") + tenant);
        codeListVersionsType.setReuseRuleCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("ClassificationRuleCodeListVersion", "ClassificationRuleCodeListVersion") + tenant);
        codeListVersionsType.setClassificationRuleCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("AuthorizationReasonCodeListVersion", "AuthorizationReasonCodeListVersion") + tenant);
        codeListVersionsType.setAuthorizationReasonCodeListVersion(value);
        value = new CodeType();
        value.setValue(VitamConfiguration.getVitamDefaultCodeListVersion().getOrDefault("RelationshipCodeListVersion", "RelationshipCodeListVersion") + tenant);
        codeListVersionsType.setRelationshipCodeListVersion(value);
        this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "CodeListVersions"), CodeListVersionsType.class, (Object)codeListVersionsType), this.writer);
    }

    public void writeFooter(ExportType exportType, ExportRequestParameters parameters) throws JAXBException {
        switch (exportType) {
            case ArchiveTransfer: {
                IdentifierType identifierType;
                if (CollectionUtils.isNotEmpty((Collection)parameters.getRelatedTransferReference())) {
                    for (String elem : parameters.getRelatedTransferReference()) {
                        identifierType = new IdentifierType();
                        identifierType.setValue(elem);
                        this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "RelatedTransferReference"), IdentifierType.class, (Object)identifierType), this.writer);
                    }
                }
                if (!Strings.isNullOrEmpty((String)parameters.getTransferRequestReplyIdentifier())) {
                    identifierType = new IdentifierType();
                    identifierType.setValue(parameters.getTransferRequestReplyIdentifier());
                    this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "TransferRequestReplyIdentifier"), IdentifierType.class, (Object)identifierType), this.writer);
                }
                OrganizationWithIdType organizationWithIdType = new OrganizationWithIdType();
                identifierType = new IdentifierType();
                identifierType.setValue(parameters.getArchivalAgencyIdentifier());
                organizationWithIdType.setIdentifier(identifierType);
                this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "ArchivalAgency"), OrganizationWithIdType.class, (Object)organizationWithIdType), this.writer);
                organizationWithIdType = new OrganizationWithIdType();
                identifierType = new IdentifierType();
                identifierType.setValue(parameters.getTransferringAgency());
                organizationWithIdType.setIdentifier(identifierType);
                this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "TransferringAgency"), OrganizationWithIdType.class, (Object)organizationWithIdType), this.writer);
                break;
            }
            case ArchiveDeliveryRequestReply: {
                IdentifierType identifierType = new IdentifierType();
                identifierType.setValue(parameters.getMessageRequestIdentifier());
                this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "MessageRequestIdentifier"), IdentifierType.class, (Object)identifierType), this.writer);
                if (!Strings.isNullOrEmpty((String)parameters.getAuthorizationRequestReplyIdentifier())) {
                    identifierType = new IdentifierType();
                    identifierType.setValue(parameters.getAuthorizationRequestReplyIdentifier());
                    this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "AuthorizationRequestReplyIdentifier"), IdentifierType.class, (Object)identifierType), this.writer);
                }
                identifierType = new IdentifierType();
                identifierType.setValue("Not Implemented");
                this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "UnitIdentifier"), IdentifierType.class, (Object)identifierType), this.writer);
                OrganizationWithIdType organizationWithIdType = new OrganizationWithIdType();
                identifierType = new IdentifierType();
                identifierType.setValue(parameters.getArchivalAgencyIdentifier());
                organizationWithIdType.setIdentifier(identifierType);
                this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "ArchivalAgency"), OrganizationWithIdType.class, (Object)organizationWithIdType), this.writer);
                organizationWithIdType = new OrganizationWithIdType();
                identifierType = new IdentifierType();
                identifierType.setValue(parameters.getRequesterIdentifier());
                organizationWithIdType.setIdentifier(identifierType);
                this.marshaller.marshal((Object)new JAXBElement(new QName("fr:gouv:culture:archivesdefrance:seda:v2", "Requester"), OrganizationWithIdType.class, (Object)organizationWithIdType), this.writer);
            }
        }
    }

    public void closeManifest() throws XMLStreamException {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.close();
    }

    public void validate(ExportType exportType, ExportRequestParameters exportRequestParameters) throws ExportException {
        if (null == exportRequestParameters) {
            throw new ExportException("Export type (" + String.valueOf(exportType) + ") export request parameters mustn't be null");
        }
        Object msg = "";
        switch (exportType) {
            case ArchiveTransfer: {
                if (Strings.isNullOrEmpty((String)exportRequestParameters.getArchivalAgreement())) {
                    msg = "ArchivalAgreement parameter is required, ";
                }
                if (Strings.isNullOrEmpty((String)exportRequestParameters.getOriginatingAgencyIdentifier())) {
                    msg = (String)msg + "OriginatingAgencyIdentifier parameter is required, ";
                }
                if (Strings.isNullOrEmpty((String)exportRequestParameters.getArchivalAgencyIdentifier())) {
                    msg = (String)msg + "ArchivalAgency parameter is required.";
                }
                if (Strings.isNullOrEmpty((String)msg)) break;
                throw new ExportException((String)msg);
            }
            case ArchiveDeliveryRequestReply: {
                if (Strings.isNullOrEmpty((String)exportRequestParameters.getMessageRequestIdentifier())) {
                    msg = "MessageRequestIdentifier parameter is required, ";
                }
                if (Strings.isNullOrEmpty((String)exportRequestParameters.getArchivalAgencyIdentifier())) {
                    msg = (String)msg + "ArchivalAgency parameter is required, ";
                }
                if (Strings.isNullOrEmpty((String)exportRequestParameters.getRequesterIdentifier())) {
                    msg = (String)msg + "Requester parameter is required.";
                }
                if (Strings.isNullOrEmpty((String)msg)) break;
                throw new ExportException((String)msg);
            }
            default: {
                throw new ExportException("Export type (" + String.valueOf(exportType) + ") not yet implemented");
            }
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((String)"fr.gouv.culture.archivesdefrance.seda.v2");
        }
        catch (JAXBException e) {
            LOGGER.error("unable to create jaxb context", (Throwable)e);
        }
    }
}

