/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.manifest;

import fr.gouv.culture.archivesdefrance.seda.v2.EventLogBookOgType;
import fr.gouv.culture.archivesdefrance.seda.v2.EventType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.mapping.dip.TransformJsonTreeToListOfXmlElement;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bson.Document;

public class LogbookMapper {
    public static final String AGENT_IDENTIFIER = "AgentIdentifier";
    public static final String OBJECT_IDENTIFIER = "ObjectIdentifier";
    private static final String LOGBOOK_EVENT_OBJECT_IDENTIFIER = "obId";
    private static final String LOGBOOK_EVENT_AGENT_IDENTIFIER = "agId";

    public static EventType getEventTypeFromDocument(Document eventData) {
        EventType event = new EventType();
        LogbookMapper.setDataInEvent(eventData, event);
        return event;
    }

    public static EventLogBookOgType getEventOGTypeFromDocument(Document eventData) {
        EventLogBookOgType event = new EventLogBookOgType();
        LogbookMapper.setDataInEvent(eventData, event);
        return event;
    }

    private static <T extends EventType> void setDataInEvent(Document eventData, T event) {
        event.setEventIdentifier(eventData.getString((Object)"evId"));
        event.setEventTypeCode(eventData.getString((Object)"evTypeProc"));
        event.setEventType(eventData.getString((Object)"evType"));
        event.setEventDateTime(LogbookMapper.reformatEventDateTime(eventData.getString((Object)"evDateTime")));
        event.setOutcome(eventData.getString((Object)"outcome"));
        event.setOutcomeDetail(eventData.getString((Object)"outDetail"));
        event.setOutcomeDetailMessage(eventData.getString((Object)"outMessg"));
        event.setEventDetailData(eventData.getString((Object)"evDetData"));
        HashMap<String, List<String>> extensions = new HashMap<String, List<String>>();
        extensions.put(AGENT_IDENTIFIER, Collections.singletonList(eventData.getString((Object)LOGBOOK_EVENT_AGENT_IDENTIFIER)));
        extensions.put(OBJECT_IDENTIFIER, Collections.singletonList(eventData.getString((Object)LOGBOOK_EVENT_OBJECT_IDENTIFIER)));
        event.getAny().addAll(TransformJsonTreeToListOfXmlElement.mapJsonToElement(extensions));
    }

    private static String reformatEventDateTime(String persistedEvDateTime) {
        return LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.parseMongoFormattedDate((String)persistedEvDateTime));
    }
}

