/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.workspace.common.compress;

import fr.gouv.vitam.common.CommonMediaType;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class VitamArchiveStreamFactory {
    public ArchiveInputStream createArchiveInputStream(MediaType mediaType, InputStream in) throws ArchiveException, IOException {
        if (mediaType == null) {
            throw new IllegalArgumentException("archiverMediaType must not be null.");
        }
        if (in == null) {
            throw new IllegalArgumentException("InputStream must not be null");
        }
        switch (CommonMediaType.mimeTypeOf((MediaType)mediaType)) {
            case "application/zip": {
                return new ZipArchiveInputStream(in);
            }
            case "application/x-tar": {
                return new TarArchiveInputStream(in);
            }
            case "application/x-gzip": 
            case "application/gzip": {
                return new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(in));
            }
            case "application/x-bzip2": {
                return new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(in));
            }
        }
        throw new ArchiveException("Archiver: " + String.valueOf(mediaType) + " not found.");
    }
}

