/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.workspace.common;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageAlreadyExistException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.api.model.FileParams;
import fr.gouv.vitam.workspace.api.model.TimeToLive;
import fr.gouv.vitam.workspace.common.BulkMoveEntry;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;

public interface WorkspaceContentAddressableStorage {
    public void createContainer(String var1) throws ContentAddressableStorageAlreadyExistException, ContentAddressableStorageServerException;

    public void purgeContainer(String var1) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException;

    public void deleteContainer(String var1, boolean var2) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException;

    public boolean isExistingContainer(String var1);

    public void createFolder(String var1, String var2) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageAlreadyExistException, ContentAddressableStorageServerException;

    public void deleteFolder(String var1, String var2) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException;

    public boolean isExistingFolder(String var1, String var2);

    public List<URI> getListUriDigitalObjectFromFolder(String var1, String var2, int var3) throws ContentAddressableStorageException;

    public void uncompressObject(String var1, String var2, String var3, InputStream var4) throws ContentAddressableStorageException;

    public void putObject(String var1, String var2, InputStream var3) throws ContentAddressableStorageException;

    public void putAtomicObject(String var1, String var2, InputStream var3, long var4) throws ContentAddressableStorageException;

    public Response getObject(String var1, String var2, Long var3, Long var4) throws ContentAddressableStorageException;

    public void deleteObject(String var1, String var2) throws ContentAddressableStorageException;

    public boolean isExistingObject(String var1, String var2);

    public String computeObjectDigest(String var1, String var2, DigestType var3) throws ContentAddressableStorageException;

    public ContainerInformation getContainerInformation(String var1) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException;

    public JsonNode getObjectInformation(String var1, String var2) throws ContentAddressableStorageException;

    public void purgeOldFilesInContainer(String var1, TimeToLive var2) throws ContentAddressableStorageException;

    public Map<String, FileParams> getFilesWithParamsFromFolder(String var1, String var2) throws ContentAddressableStorageException;

    public void moveObjects(String var1, List<BulkMoveEntry> var2) throws ContentAddressableStorageException;
}

