/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageEntity;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.ReadWriteOrder;

public class WriteOrder
extends QueueMessageEntity
implements ReadWriteOrder {
    public static final String BUCKET = "bucket";
    public static final String FILE_BUCKET_ID = "fileBucketId";
    public static final String FILE_PATH = "filePath";
    public static final String SIZE = "size";
    public static final String DIGEST = "digest";
    public static final String ARCHIVE_ID = "archiveId";
    @JsonProperty(value="bucket")
    private String bucket;
    @JsonProperty(value="fileBucketId")
    private String fileBucketId;
    @JsonProperty(value="filePath")
    private String filePath;
    @JsonProperty(value="size")
    private long size;
    @JsonProperty(value="digest")
    private String digest;
    @JsonProperty(value="archiveId")
    private String archiveId;

    public WriteOrder() {
        super(GUIDFactory.newGUID().getId(), QueueMessageType.WriteOrder);
    }

    public WriteOrder(String bucket, String fileBucketId, String filePath, long size, String digest, String archiveId, QueueMessageType queueMessageType) {
        this();
        this.setMessageType(queueMessageType);
        this.bucket = bucket;
        this.fileBucketId = fileBucketId;
        this.filePath = filePath;
        this.size = size;
        this.digest = digest;
        this.archiveId = archiveId;
    }

    public String getBucket() {
        return this.bucket;
    }

    public WriteOrder setBucket(String bucket) {
        ParametersChecker.checkParameter((String)"bucket is required", (String[])new String[]{bucket});
        this.bucket = bucket;
        return this;
    }

    public String getFileBucketId() {
        return this.fileBucketId;
    }

    public WriteOrder setFileBucketId(String fileBucketId) {
        this.fileBucketId = fileBucketId;
        return this;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public WriteOrder setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    public WriteOrder setSize(long size) {
        this.size = size;
        return this;
    }

    public String getDigest() {
        return this.digest;
    }

    public WriteOrder setDigest(String digest) {
        this.digest = digest;
        return this;
    }

    @Override
    @JsonIgnore
    public boolean isWriteOrder() {
        return true;
    }

    public String getArchiveId() {
        return this.archiveId;
    }

    public WriteOrder setArchiveId(String archiveId) {
        this.archiveId = archiveId;
        return this;
    }
}

