/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.storage.engine.common.model.FileInTape;
import fr.gouv.vitam.storage.engine.common.model.TarLocation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TapeReadRequestReferentialEntity {
    public static final String ID = "_id";
    public static final String TAR_LOCATIONS = "tarLocation";
    public static final String FILES = "files";
    public static final String CONTAINER_NAME = "containerName";
    public static final String CREATE_DATE = "createDate";
    public static final String EXPIRE_DATE = "expireDate";
    public static final String IS_COMPLETED = "isCompleted";
    public static final String IS_EXPIRED = "isExpired";
    @JsonProperty(value="_id")
    private String requestId;
    @JsonProperty(value="containerName")
    private String containerName;
    @JsonProperty(value="tarLocation")
    private Map<String, TarLocation> tarLocations = new HashMap<String, TarLocation>();
    @JsonProperty(value="files")
    private List<FileInTape> files;
    @JsonProperty(value="createDate")
    private String creationDate = LocalDateUtil.nowFormatted();
    @JsonProperty(value="expireDate")
    private String expireDate;

    public TapeReadRequestReferentialEntity() {
    }

    public TapeReadRequestReferentialEntity(String requestId, String containerName, Map<String, TarLocation> tarLocations, List<FileInTape> files) {
        this.requestId = requestId;
        this.containerName = containerName;
        this.tarLocations = tarLocations;
        this.files = files;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public Map<String, TarLocation> getTarLocations() {
        return this.tarLocations;
    }

    public void setTarLocations(Map<String, TarLocation> tarLocations) {
        this.tarLocations = tarLocations;
    }

    public List<FileInTape> getFiles() {
        return this.files;
    }

    public void setFiles(List<FileInTape> files) {
        this.files = files;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(String expireDate) {
        this.expireDate = expireDate;
    }

    @JsonProperty(value="isExpired")
    public Boolean isExpired() {
        return this.expireDate == null ? false : LocalDateUtil.now().isAfter(LocalDateUtil.parseMongoFormattedDate((String)this.expireDate));
    }

    @JsonProperty(value="isCompleted")
    public boolean isCompleted() {
        return this.tarLocations.values().stream().filter(o -> TarLocation.DISK.equals(o)).count() == (long)this.tarLocations.size();
    }
}

