/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageEntity;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.ReadWriteOrder;

public class ReadOrder
extends QueueMessageEntity
implements ReadWriteOrder {
    public static final String TAPE_CODE = "tapeCode";
    public static final String FILE_POSITION = "filePosition";
    public static final String FILE_NAME = "fileName";
    public static final String BUCKET = "bucket";
    public static final String FILE_BUCKET_ID = "fileBucketId";
    public static final String SIZE = "size";
    @JsonProperty(value="tapeCode")
    private String tapeCode;
    @JsonProperty(value="bucket")
    private String bucket;
    @JsonProperty(value="filePosition")
    private Integer filePosition;
    @JsonProperty(value="fileName")
    private String fileName;
    @JsonProperty(value="fileBucketId")
    private String fileBucketId;
    @JsonProperty(value="size")
    private long size;

    public ReadOrder() {
        super(GUIDFactory.newGUID().getId(), QueueMessageType.ReadOrder);
    }

    public ReadOrder(String tapeCode, Integer filePosition, String fileName, String bucket, String fileBucketId, long size) {
        this();
        ParametersChecker.checkParameter((String)"All params are required", (Object[])new Object[]{tapeCode, filePosition, fileName, bucket, fileBucketId});
        this.tapeCode = tapeCode;
        this.filePosition = filePosition;
        this.fileName = fileName;
        this.bucket = bucket;
        this.fileBucketId = fileBucketId;
        this.size = size;
    }

    public String getTapeCode() {
        return this.tapeCode;
    }

    public ReadOrder setTapeCode(String tapeCode) {
        ParametersChecker.checkParameter((String)"tapeCode params is required", (String[])new String[]{tapeCode});
        this.tapeCode = tapeCode;
        return this;
    }

    public Integer getFilePosition() {
        return this.filePosition;
    }

    public ReadOrder setFilePosition(Integer filePosition) {
        ParametersChecker.checkParameter((String)"filePosition param is required", (Object[])new Object[]{filePosition});
        this.filePosition = filePosition;
        return this;
    }

    @Override
    @JsonIgnore
    public boolean isWriteOrder() {
        return false;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ReadOrder setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String getBucket() {
        return this.bucket;
    }

    public ReadOrder setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public String getFileBucketId() {
        return this.fileBucketId;
    }

    public ReadOrder setFileBucketId(String fileBucketId) {
        this.fileBucketId = fileBucketId;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    public ReadOrder setSize(long size) {
        this.size = size;
        return this;
    }
}

